/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.issues.IssueUnmanagedKeysHistoryIndex;
import com.teamscale.index.issues.PathIssueIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class IssueUnmanagedKeysSynchronizer
extends ChangeProcessorAnalysisStep {
    @DeltaSource(value=PathIssueIndex.class)
    private PathIssueIndex.Delta affectedFilesDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PathIssueIndex pathToIssueIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueUnmanagedKeysHistoryIndex issueUnmanagedKeysHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;

    public void execute() throws Exception {
        HashMap<String, Set> updatedEntries = new HashMap<String, Set>();
        for (TeamscaleIssueId changedIssue : this.affectedFilesDelta.changedIssues()) {
            List<String> uniformPaths = this.pathToIssueIndex.getReferencedPaths(changedIssue);
            Set<String> existingPaths = this.basicTokenElementIndex.getTokenElementsByPath(uniformPaths).keySet();
            updatedEntries.put(changedIssue.getInternalId(), UniformPathCompatibilityUtil.convertSet(existingPaths));
        }
        this.issueUnmanagedKeysHistoryIndex.updateEntries(updatedEntries, this.getSchedulingCommit().getTimestamp(), Collections.emptySet());
    }
}

