/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.utils.TeamscaleIssueIdDeserializer;
import com.teamscale.index.utils.TeamscaleIssueIdSerializer;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreWithAbbreviationSupport;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="issues-paths", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={byte[].class})
public class PathIssueIndex
implements IProjectIndex,
IDeltaTranslatingIndex<Delta> {
    public static final String INDEX_NAME = "issues-paths";
    private static final String ISSUE_TO_PATH_MAPPING_PREFIX = "#0#";
    private static final String PATH_TO_ISSUE_MAPPING_PREFIX = "#1#";
    private final ValueIndex<List<String>> issueToPathDelegate;
    private final ValueIndex<List<TeamscaleIssueId>> pathToIssueDelegate;

    public PathIssueIndex(IStore store) {
        if (!(store instanceof StoreWithAbbreviationSupport)) {
            throw new IllegalArgumentException("Provided store '%s' does not have string abbreviation support".formatted(store));
        }
        StoreWithAbbreviationSupport abbreviatedStore = (StoreWithAbbreviationSupport)store;
        this.issueToPathDelegate = ValueIndex.forStringListWithAbbreviation((IStore)new DelegatingPartitionStore(store, ISSUE_TO_PATH_MAPPING_PREFIX), (StorageStringAbbreviator)abbreviatedStore.getStringAbbreviator());
        this.pathToIssueDelegate = ValueIndex.of((IStore)new DelegatingPartitionStore(store, PATH_TO_ISSUE_MAPPING_PREFIX), (ISerializer)new IssueIdSerializerWithAbbreviation(abbreviatedStore.getStringAbbreviator()));
    }

    public void updateMappings(List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths) throws StorageException {
        this.updateIssueToPathsMappings(addedPaths, editedAndDeletedPaths, movedPaths);
        this.updatePathToIssuesMappings(addedPaths, editedAndDeletedPaths, movedPaths);
    }

    public void updatePathToIssuesMappings(Map<String, @NonNull List<TeamscaleIssueId>> updatedPathToIssuesMapping) throws StorageException {
        Map<String, @NonNull List<TeamscaleIssueId>> existingPathToIssuesMapping = this.getPathToIssuesMapping(updatedPathToIssuesMapping.keySet());
        HashMap<String, @NonNull HashSet<TeamscaleIssueId>> updatedAffectedIssuesByPath = new HashMap<String, HashSet<TeamscaleIssueId>>();
        for (Map.Entry<String, List<TeamscaleIssueId>> affectedIssuesForPath : updatedPathToIssuesMapping.entrySet()) {
            String uniformPath = affectedIssuesForPath.getKey();
            HashSet affectedIssues = new HashSet(affectedIssuesForPath.getValue());
            if (existingPathToIssuesMapping.containsKey(uniformPath)) {
                affectedIssues.addAll(existingPathToIssuesMapping.get(uniformPath));
            }
            updatedAffectedIssuesByPath.put(uniformPath, affectedIssues);
        }
        this.storePathToIssuesMapping(updatedAffectedIssuesByPath);
    }

    public void updateIssueToPathsMappings(Map<TeamscaleIssueId, @NonNull List<String>> updatedIssueToPathsMapping) throws StorageException {
        Map<TeamscaleIssueId, @NonNull List<String>> existingIssueToPathsMapping = this.getIssueToPathsMapping(updatedIssueToPathsMapping.keySet());
        HashMap<TeamscaleIssueId, @NonNull HashSet<String>> updatedPathsByIssue = new HashMap<TeamscaleIssueId, HashSet<String>>();
        for (Map.Entry<TeamscaleIssueId, List<String>> affectedPathsForIssue : updatedIssueToPathsMapping.entrySet()) {
            TeamscaleIssueId issueId = affectedPathsForIssue.getKey();
            List<String> updatedAffectedPaths = affectedPathsForIssue.getValue();
            HashSet<String> mergedAffectedPaths = new HashSet<String>(updatedAffectedPaths);
            if (existingIssueToPathsMapping.containsKey(issueId)) {
                mergedAffectedPaths.addAll((Collection<String>)existingIssueToPathsMapping.get(issueId));
            }
            updatedPathsByIssue.put(issueId, mergedAffectedPaths);
        }
        this.storeIssueToPathsMapping(updatedPathsByIssue);
    }

    public Map<String, @NonNull List<TeamscaleIssueId>> getPathToIssuesMapping(Collection<String> uniformPaths) throws StorageException {
        return this.pathToIssueDelegate.getValuesByKeys(uniformPaths);
    }

    public Map<TeamscaleIssueId, @NonNull List<String>> getIssueToPathsMappingsForUniformPaths(Collection<String> uniformPaths) throws StorageException {
        Map<String, @NonNull List<TeamscaleIssueId>> pathToIssuesMapping = this.getPathToIssuesMapping(uniformPaths);
        Set<TeamscaleIssueId> issueIds = pathToIssuesMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return this.getIssueToPathsMapping(issueIds);
    }

    public SetMap<String, TeamscaleIssueId> getPathToIssueMappingForAffectedIssues(Set<String> uniformPaths, List<TeamscaleIssueId> issueIds) throws StorageException {
        Map<String, @NonNull List<TeamscaleIssueId>> allAffectedIssuesByPath = this.getPathToIssuesMapping(uniformPaths);
        SetMap affectedIssuesByPath = new SetMap();
        for (Map.Entry<String, List<TeamscaleIssueId>> allAffectedIssuesByPathEntry : allAffectedIssuesByPath.entrySet()) {
            String uniformPath = allAffectedIssuesByPathEntry.getKey();
            HashSet allAffectedIssueIds = new HashSet(allAffectedIssuesByPathEntry.getValue());
            for (TeamscaleIssueId affectedIssueId : issueIds) {
                if (!allAffectedIssueIds.contains(affectedIssueId)) continue;
                affectedIssuesByPath.add((Object)uniformPath, (Object)affectedIssueId);
            }
        }
        return affectedIssuesByPath;
    }

    public @Nullable List<String> getReferencedPaths(TeamscaleIssueId issueId) throws StorageException {
        return (List)this.issueToPathDelegate.getValue(issueId.toString());
    }

    public @NonNull Delta resolveDelta(KeyDelta delta) {
        if (!delta.getDeletedKeys().isEmpty()) {
            throw new IllegalStateException("Expected delta without deleted entries");
        }
        HashSet<String> changedPaths = new HashSet<String>();
        HashSet<TeamscaleIssueId> changedIssues = new HashSet<TeamscaleIssueId>();
        for (StorageKey addedOrChangedKey : delta.getAddedOrChangedKeys()) {
            DelegatingPartitionStore pathToIssueStore;
            DelegatingPartitionStore issueToPathStore;
            byte[] key = addedOrChangedKey.getKey();
            IStore iStore = this.issueToPathDelegate.getWrappedStore(DelegatingPartitionStore.class);
            if (iStore instanceof DelegatingPartitionStore && (issueToPathStore = (DelegatingPartitionStore)iStore).isFromThisPartition(key)) {
                changedIssues.add(TeamscaleIssueId.fromInternalId((String)StringUtils.bytesToString((byte[])issueToPathStore.getOriginalKey(key))));
                continue;
            }
            iStore = this.pathToIssueDelegate.getWrappedStore(DelegatingPartitionStore.class);
            if (iStore instanceof DelegatingPartitionStore && (pathToIssueStore = (DelegatingPartitionStore)iStore).isFromThisPartition(key)) {
                changedPaths.add(StringUtils.bytesToString((byte[])pathToIssueStore.getOriginalKey(key)));
                continue;
            }
            throw new IllegalArgumentException("Unexpected key: " + String.valueOf(addedOrChangedKey));
        }
        return new Delta(changedPaths, changedIssues);
    }

    private void updateIssueToPathsMappings(List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths) throws StorageException {
        UnmodifiableMap<String, @NonNull List<TeamscaleIssueId>> pathsToIssuesMappingsForMovesAndDeletes = this.getStoredPathToIssuesMappingForMoves(movedPaths.stream().map(movedPath -> movedPath.oldPath).collect(Collectors.toSet()));
        Map<TeamscaleIssueId, @NonNull HashSet<String>> issueToPathsMappings = this.preloadExistingIssueToPathsMappings(addedPaths, editedAndDeletedPaths, movedPaths, pathsToIssuesMappingsForMovesAndDeletes);
        PathIssueIndex.processAddedEditedDeletedPathsForIssueToPathsMappings(issueToPathsMappings, addedPaths, editedAndDeletedPaths);
        PathIssueIndex.processMovedPathsForIssueToPathsMappings(movedPaths, pathsToIssuesMappingsForMovesAndDeletes, issueToPathsMappings);
        this.storeIssueToPathsMapping(issueToPathsMappings);
    }

    private UnmodifiableMap<String, @NonNull List<TeamscaleIssueId>> getStoredPathToIssuesMappingForMoves(Set<String> deletedPaths) throws StorageException {
        return CollectionUtils.asUnmodifiable(this.getPathToIssuesMapping(deletedPaths));
    }

    private Map<TeamscaleIssueId, @NonNull HashSet<String>> preloadExistingIssueToPathsMappings(List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths, UnmodifiableMap<String, @NonNull List<TeamscaleIssueId>> pathToIssuesMappingsForMovesAndDeletes) throws StorageException {
        Stream newlyAddedIssueIdsFromAddedPaths = addedPaths.stream().flatMap(editedPath -> editedPath.referencedIssues.stream());
        Stream newlyAddedIssueIdsFromEditedPaths = editedAndDeletedPaths.stream().flatMap(editedPath -> editedPath.referencedIssues.stream());
        Stream newlyAddedIssueIdsFromMovedPaths = movedPaths.stream().filter(movedPath -> movedPath.addedIssues != null).flatMap(movedPath -> movedPath.addedIssues.stream());
        Stream issueIdsReferencedByOldAndDeletedPaths = pathToIssuesMappingsForMovesAndDeletes.values().stream().flatMap(Collection::stream);
        Set<TeamscaleIssueId> issueIdsReferencedByEditedAndMovedPaths = Stream.of(newlyAddedIssueIdsFromAddedPaths, newlyAddedIssueIdsFromEditedPaths, newlyAddedIssueIdsFromMovedPaths, issueIdsReferencedByOldAndDeletedPaths).flatMap(Function.identity()).collect(Collectors.toSet());
        Map<TeamscaleIssueId, @NonNull List<String>> storedIssueToPathsMappings = this.getIssueToPathsMapping(issueIdsReferencedByEditedAndMovedPaths);
        HashMap<TeamscaleIssueId, @NonNull HashSet<String>> issueToPaths = new HashMap<TeamscaleIssueId, HashSet<String>>();
        storedIssueToPathsMappings.forEach((issueId, paths) -> issueToPaths.put((TeamscaleIssueId)issueId, new HashSet(paths)));
        return issueToPaths;
    }

    private static void processAddedEditedDeletedPathsForIssueToPathsMappings(Map<TeamscaleIssueId, @NonNull HashSet<String>> issueToPathsMappings, List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths) {
        ArrayList<PathToIssuesMapping> addedAndEditedPaths = new ArrayList<PathToIssuesMapping>(addedPaths);
        addedAndEditedPaths.addAll(editedAndDeletedPaths);
        for (PathToIssuesMapping pathToIssuesMapping : addedAndEditedPaths) {
            PathIssueIndex.assertAffectedIssuesNotEmpty(pathToIssuesMapping);
            for (TeamscaleIssueId addedIssueId : pathToIssuesMapping.referencedIssues) {
                if (!issueToPathsMappings.containsKey(addedIssueId)) {
                    issueToPathsMappings.put(addedIssueId, new HashSet());
                }
                issueToPathsMappings.get(addedIssueId).add(pathToIssuesMapping.uniformPath);
            }
        }
    }

    private static void processMovedPathsForIssueToPathsMappings(List<PathMove> movedPaths, UnmodifiableMap<String, @NonNull List<TeamscaleIssueId>> pathsToIssuesMappingsForMovesAndDeletes, Map<TeamscaleIssueId, @NonNull HashSet<String>> issueToPathsMappings) {
        for (PathMove movedPath : movedPaths) {
            HashSet<TeamscaleIssueId> affectedIssueIds = new HashSet<TeamscaleIssueId>();
            List affectedIssueIdsFromExistingPathToIssueMappings = (List)pathsToIssuesMappingsForMovesAndDeletes.get((Object)movedPath.oldPath);
            if (affectedIssueIdsFromExistingPathToIssueMappings != null) {
                affectedIssueIds.addAll(affectedIssueIdsFromExistingPathToIssueMappings);
            }
            if (movedPath.addedIssues != null) {
                affectedIssueIds.addAll(movedPath.addedIssues);
            }
            if (affectedIssueIds.isEmpty()) continue;
            for (TeamscaleIssueId affectedIssueId : affectedIssueIds) {
                HashSet<String> updatedPaths = new HashSet<String>();
                updatedPaths.add(movedPath.newPath);
                if (issueToPathsMappings.containsKey(affectedIssueId)) {
                    updatedPaths.addAll((Collection)issueToPathsMappings.get(affectedIssueId));
                }
                issueToPathsMappings.put(affectedIssueId, updatedPaths);
            }
        }
    }

    private void updatePathToIssuesMappings(List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths) throws StorageException {
        HashMap<String, @NonNull HashSet<TeamscaleIssueId>> pathToIssuesMapping = new HashMap<String, HashSet<TeamscaleIssueId>>();
        PathIssueIndex.processAddedPathForPathToIssuesMapping(addedPaths, pathToIssuesMapping);
        Map<String, @NonNull List<TeamscaleIssueId>> storedPathToIssueMappings = this.preloadExistingPathToIssuesMapping(editedAndDeletedPaths, movedPaths);
        PathIssueIndex.processEditedAndDeletedPathsForPathToIssuesMapping(editedAndDeletedPaths, storedPathToIssueMappings, pathToIssuesMapping);
        PathIssueIndex.processMovedPathsForPathToIssuesMapping(movedPaths, storedPathToIssueMappings, pathToIssuesMapping);
        this.storePathToIssuesMapping(pathToIssuesMapping);
    }

    private static void processAddedPathForPathToIssuesMapping(List<PathToIssuesMapping> addedPaths, Map<String, @NonNull HashSet<TeamscaleIssueId>> pathToIssuesMapping) {
        for (PathToIssuesMapping pathAddition : addedPaths) {
            PathIssueIndex.assertAffectedIssuesNotEmpty(pathAddition);
            pathToIssuesMapping.put(pathAddition.uniformPath, new HashSet<TeamscaleIssueId>(pathAddition.referencedIssues));
        }
    }

    private Map<String, @NonNull List<TeamscaleIssueId>> preloadExistingPathToIssuesMapping(List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths) throws StorageException {
        List<String> editedAndMovedPath = Stream.concat(editedAndDeletedPaths.stream().map(PathToIssuesMapping::uniformPath), movedPaths.stream().map(PathMove::oldPath)).toList();
        return this.getPathToIssuesMapping(editedAndMovedPath);
    }

    private static void processEditedAndDeletedPathsForPathToIssuesMapping(List<PathToIssuesMapping> editedAndDeletedPaths, Map<String, @NonNull List<TeamscaleIssueId>> storedPathToIssueMappings, Map<String, @NonNull HashSet<TeamscaleIssueId>> pathToIssuesMapping) {
        for (PathToIssuesMapping editedPath : editedAndDeletedPaths) {
            PathIssueIndex.assertAffectedIssuesNotEmpty(editedPath);
            HashSet oldAndNewIssueIds = CollectionUtils.unionSet((Collection)storedPathToIssueMappings.get(editedPath.uniformPath), (Collection[])new Collection[]{editedPath.referencedIssues});
            pathToIssuesMapping.put(editedPath.uniformPath, oldAndNewIssueIds);
        }
    }

    private static void processMovedPathsForPathToIssuesMapping(List<PathMove> movedPaths, Map<String, @NonNull List<TeamscaleIssueId>> storedPathToIssueMappings, Map<String, @NonNull HashSet<TeamscaleIssueId>> pathToIssuesMapping) {
        for (PathMove movedPath : movedPaths) {
            HashSet<TeamscaleIssueId> referencedIssueIds = new HashSet<TeamscaleIssueId>();
            if (storedPathToIssueMappings.containsKey(movedPath.oldPath)) {
                referencedIssueIds.addAll((Collection)storedPathToIssueMappings.get(movedPath.oldPath));
            }
            if (movedPath.addedIssues != null) {
                referencedIssueIds.addAll(movedPath.addedIssues);
            }
            pathToIssuesMapping.put(movedPath.newPath, referencedIssueIds);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Map<TeamscaleIssueId, @NonNull List<String>> getIssueToPathsMapping(Collection<TeamscaleIssueId> issueIds) throws StorageException {
        @NonNull Map pathsByStringIssues = this.issueToPathDelegate.getValuesByKeys(issueIds.stream().map(TeamscaleIssueId::toString).toList());
        HashMap<TeamscaleIssueId, @NonNull List<String>> pathByIssues = new HashMap<TeamscaleIssueId, List<String>>();
        for (Map.Entry pathByStringIssue : pathsByStringIssues.entrySet()) {
            pathByIssues.put(TeamscaleIssueId.fromInternalId((String)((String)pathByStringIssue.getKey())), (List)pathByStringIssue.getValue());
        }
        return pathByIssues;
    }

    private static void assertAffectedIssuesNotEmpty(PathToIssuesMapping uniformPath) {
        CCSMAssert.isNotEmpty(uniformPath.referencedIssues, (String)"expected at least one affected issue, but the affected issues of the added path '%s' where empty.".formatted(uniformPath.uniformPath));
    }

    private void storePathToIssuesMapping(Map<String, @NonNull HashSet<TeamscaleIssueId>> affectedIssuesByPath) throws StorageException {
        PairList mappingToStore = new PairList();
        for (Map.Entry<String, HashSet<TeamscaleIssueId>> affectedIssueByPath : affectedIssuesByPath.entrySet()) {
            mappingToStore.add((Object)affectedIssueByPath.getKey(), affectedIssueByPath.getValue().stream().toList());
        }
        this.pathToIssueDelegate.setValues(mappingToStore);
    }

    private void storeIssueToPathsMapping(Map<TeamscaleIssueId, @NonNull HashSet<String>> affectedPathsByIssue) throws StorageException {
        PairList mappingToStore = new PairList();
        for (Map.Entry<TeamscaleIssueId, HashSet<String>> affectedPathByIssue : affectedPathsByIssue.entrySet()) {
            mappingToStore.add((Object)affectedPathByIssue.getKey().toString(), affectedPathByIssue.getValue().stream().toList());
        }
        this.issueToPathDelegate.setValues(mappingToStore);
    }

    private record IssueIdSerializerWithAbbreviation(StorageStringAbbreviator stringAbbreviator) implements ISerializer<List<TeamscaleIssueId>, byte[]>
    {
        public byte @NonNull [] serialize(@NonNull List<TeamscaleIssueId> issueIds) throws StorageException {
            TeamscaleIssueIdSerializer issueIdSerializer = new TeamscaleIssueIdSerializer(this.stringAbbreviator, issueIds);
            ByteArrayOutputStream serializedIssueIds = new ByteArrayOutputStream();
            for (TeamscaleIssueId issueId : issueIds) {
                serializedIssueIds.writeBytes(issueIdSerializer.serialize(issueId));
            }
            return serializedIssueIds.toByteArray();
        }

        public @NonNull List<TeamscaleIssueId> deserialize(byte @NonNull [] serializedIssueIds) throws StorageException {
            int offset;
            TeamscaleIssueIdDeserializer issueIdDeserializer = new TeamscaleIssueIdDeserializer(this.stringAbbreviator);
            for (offset = 0; offset < serializedIssueIds.length; offset += TeamscaleIssueIdDeserializer.getEntryLength(serializedIssueIds, offset)) {
                issueIdDeserializer.extractStringIdsToLoadIntoUnAbbreviationMap(serializedIssueIds, offset);
            }
            ArrayList<TeamscaleIssueId> deserializedIssueIds = new ArrayList<TeamscaleIssueId>();
            for (offset = 0; offset < serializedIssueIds.length; offset += TeamscaleIssueIdDeserializer.getEntryLength(serializedIssueIds, offset)) {
                TeamscaleIssueId issueId = (TeamscaleIssueId)issueIdDeserializer.deserialize(serializedIssueIds, offset);
                deserializedIssueIds.add(issueId);
            }
            return deserializedIssueIds;
        }
    }

    @IndexValueClass
    public record Delta(Set<String> changedPaths, Set<TeamscaleIssueId> changedIssues) implements IIndexDelta
    {
        public static Delta empty() {
            return new Delta(Collections.emptySet(), Collections.emptySet());
        }

        public int size() {
            return this.changedPaths.size() + this.changedIssues.size();
        }

        public List<? extends IIndexDelta> split(int maxDeltaSize) {
            UnmodifiableIterator iter;
            if (this.size() < maxDeltaSize) {
                return List.of(this);
            }
            ArrayList<Delta> result = new ArrayList<Delta>();
            if (!this.changedPaths.isEmpty()) {
                iter = Iterators.partition(this.changedPaths.iterator(), (int)maxDeltaSize);
                while (iter.hasNext()) {
                    result.add(new Delta(new HashSet<String>((Collection)iter.next()), Collections.emptySet()));
                }
            }
            if (!this.changedIssues.isEmpty()) {
                iter = Iterators.partition(this.changedIssues.iterator(), (int)maxDeltaSize);
                while (iter.hasNext()) {
                    result.add(new Delta(Collections.emptySet(), new HashSet<TeamscaleIssueId>((Collection)iter.next())));
                }
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IIndexDelta combine(Collection<? extends IIndexDelta> deltas) {
            HashSet<String> changedPaths = new HashSet<String>(this.changedPaths);
            HashSet<TeamscaleIssueId> changedIssues = new HashSet<TeamscaleIssueId>(this.changedIssues);
            Iterator<? extends IIndexDelta> iterator = deltas.iterator();
            while (iterator.hasNext()) {
                Set<String> issues;
                Set<String> paths;
                IIndexDelta iIndexDelta = iterator.next();
                if (!(iIndexDelta instanceof Delta)) {
                    throw new IllegalArgumentException("Unexpected delta type: " + String.valueOf(iIndexDelta.getClass()));
                }
                Delta delta2 = (Delta)iIndexDelta;
                try {
                    Set<String> set;
                    paths = set = delta2.changedPaths();
                    issues = set = delta2.changedIssues();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                changedPaths.addAll(paths);
                changedIssues.addAll(issues);
            }
            return new Delta(changedPaths, changedIssues);
        }

        public IndexDelta<String> asLogDelta() {
            return new IndexDelta(Stream.concat(this.changedPaths.stream(), this.changedIssues.stream().map(TeamscaleIssueId::getInternalId)).toList(), Collections.emptyList());
        }
    }

    public record PathToIssuesMapping(String uniformPath, @NonNull List<TeamscaleIssueId> referencedIssues) {
    }

    public record PathMove(String oldPath, String newPath, @Nullable List<TeamscaleIssueId> addedIssues) {
    }
}

