/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.jira.client.IJiraCommonApi;
import com.teamscale.index.issues.jira.client.JiraCloudClient;
import com.teamscale.index.issues.jira.client.JiraDataCenterClient;
import com.teamscale.index.issues.jira.client.JiraInstanceAwareClient;
import com.teamscale.index.issues.jira.model.FieldDetails;
import com.teamscale.index.issues.jira.model.JiraPermission;
import com.teamscale.index.issues.jira.model.JiraServerInfo;
import com.teamscale.index.issues.jira.synchronization.EJiraInstanceType;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.http.NameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class JiraClient {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String HTTP_RESPONSE_USERNAME_HEADER = "X-AUSERNAME";
    private static final List<String> REQUIRED_PERMISSIONS = Arrays.asList("ADMINISTER", "ADMINISTER_PROJECTS");
    private static final String PERMISSIONS_ATTRIBUTE_NAME = "permissions";
    private final IJiraCommonApi jira;
    private final String baseUrl;
    private final @Nullable String username;
    private final String password;
    private final List<String> cookies;

    public JiraClient(String baseUrl, @Nullable String username, String password, List<String> cookies) {
        this.username = username;
        this.password = password;
        this.cookies = cookies;
        LOGGER.debug("Configuring client for JiraApi with Cookies: {}", cookies);
        this.baseUrl = baseUrl;
        this.jira = (IJiraCommonApi)JiraClient.configureAuthenticationMode(Retrofit.builder((String)this.baseUrl), username, password).withInteractionLogger(LOGGER).withCookies(cookies).create(IJiraCommonApi.class);
    }

    static Retrofit.Builder configureAuthenticationMode(Retrofit.Builder builder, @Nullable String username, String password) {
        if (StringUtils.isEmpty((String)username)) {
            LOGGER.debug("Configuring client for JiraApi with Bearer Authentication");
            return builder.withBearerAuthentication(password);
        }
        LOGGER.debug("Configuring client for JiraApi with Basic NTLM Authentication");
        return builder.withBasicNTLMAuthentication(username, password).withInterceptors(new Interceptor[]{JiraClient.createUsernameValidationHandler(username)});
    }

    public Map<String, EKeyedObjectType> getFieldTypes(Set<String> fieldIds) throws ServiceCallException {
        FieldDetails[] allFieldDetails = (FieldDetails[])Retrofit.executeServiceCall(this.jira.getFieldDetails()).orElseThrow(JiraClient::createEmptyResponseException);
        HashMap<String, EKeyedObjectType> mapping = new HashMap<String, EKeyedObjectType>();
        for (FieldDetails fieldDetails : allFieldDetails) {
            String fieldId = fieldDetails.getId();
            if (!fieldIds.contains(fieldId) || !fieldDetails.hasSchema()) continue;
            String fieldName = fieldDetails.getName();
            if (fieldName.contains("/")) {
                fieldName = fieldName.substring(0, fieldName.indexOf("/"));
            }
            String fieldType = fieldDetails.getType();
            EKeyedObjectType keyedFieldType = JiraClient.getEKeyedObjectType(fieldType);
            mapping.put(fieldName, keyedFieldType);
        }
        return mapping;
    }

    public boolean hasProjectAdminPermission(String projectKey) throws ServiceCallException {
        Map permissions = (Map)Retrofit.executeServiceCall(this.jira.getPermissions(projectKey, String.join((CharSequence)",", REQUIRED_PERMISSIONS))).orElseThrow(JiraClient::createEmptyResponseException);
        if (!permissions.containsKey(PERMISSIONS_ATTRIBUTE_NAME)) {
            LOGGER.debug("Missing permissions attribute '{}' as key when fetching permissions from Jira.", (Object)PERMISSIONS_ATTRIBUTE_NAME);
            return false;
        }
        Map jiraPermissions = (Map)permissions.get(PERMISSIONS_ATTRIBUTE_NAME);
        for (String permission : REQUIRED_PERMISSIONS) {
            if (!jiraPermissions.containsKey(permission) || !((JiraPermission)jiraPermissions.get(permission)).isHavePermission()) continue;
            return true;
        }
        return false;
    }

    public Map<String, List<String>> fetchAndValidateCustomFieldMapping(Set<String> destinationConfig) throws BugTrackerException, ServiceCallException {
        Set<String> destinations = new HashSet<String>(destinationConfig);
        destinations.remove("description");
        destinations = destinations.stream().map(destination -> destination.replace("customfield_", "")).collect(Collectors.toSet());
        Map<String, List<String>> customFieldMapping = this.fetchCustomFieldMappings();
        JiraClient.validateDestinations(destinations, customFieldMapping);
        return customFieldMapping;
    }

    public Map<String, List<String>> getCustomFieldMappings() throws BugTrackerException, ServiceCallException {
        FieldDetails[] allFieldDetails = (FieldDetails[])Retrofit.executeServiceCall(this.jira.getFieldDetails()).orElseThrow(JiraClient::createEmptyResponseException);
        return Arrays.stream(allFieldDetails).collect(Collectors.groupingBy(FieldDetails::getName, Collectors.mapping(FieldDetails::getId, Collectors.toList())));
    }

    @VisibleForTesting
    static Response validateJiraResponseUsername(String expectedUsername, Response response) {
        String responseUsername = response.headers().get(HTTP_RESPONSE_USERNAME_HEADER);
        if (!expectedUsername.isEmpty() && responseUsername != null && !expectedUsername.equalsIgnoreCase(URLDecoder.decode(responseUsername, StandardCharsets.UTF_8))) {
            return response.newBuilder().message("Jira response contains " + responseUsername + " instead of request username " + expectedUsername + ". Maybe credentials are wrong or HTTP basic auth did not reach the jira server.").code(401).build();
        }
        return response;
    }

    public void putIssue(String issueId, String issueJson, List<NameValuePair> parameters) throws ServiceCallException {
        Retrofit.executeServiceCall(this.jira.putIssue(issueId, parameters.stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue)), RequestBody.create((String)issueJson, (MediaType)MediaType.parse((String)"application/json"))));
    }

    public String getIssueAsJson(String issueId) throws ServiceCallException {
        String string;
        block8: {
            ResponseBody responseBody = (ResponseBody)Retrofit.executeServiceCall(this.jira.getIssueJson(issueId)).orElseThrow(JiraClient::createEmptyResponseException);
            try {
                string = Objects.requireNonNull(responseBody.string());
                if (responseBody == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (responseBody != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceCallException((Throwable)e);
                }
            }
            responseBody.close();
        }
        return string;
    }

    private Map<String, List<String>> fetchCustomFieldMappings() throws ServiceCallException {
        FieldDetails[] allFieldDetails = (FieldDetails[])Retrofit.executeServiceCall(this.jira.getFieldDetails()).orElseThrow(JiraClient::createEmptyResponseException);
        HashMap<String, List<String>> customFieldMapping = new HashMap<String, List<String>>();
        for (FieldDetails fieldDetails : allFieldDetails) {
            if (!fieldDetails.isCustom() || !fieldDetails.hasSchema() || !fieldDetails.getType().equals("string") || !fieldDetails.getCustomUri().contains("textarea")) continue;
            customFieldMapping.computeIfAbsent(fieldDetails.getName(), key -> new ArrayList()).add(fieldDetails.getId());
        }
        return customFieldMapping;
    }

    private static Interceptor createUsernameValidationHandler(String expectedUsername) {
        return chain -> {
            Response response = chain.proceed(chain.request());
            return JiraClient.validateJiraResponseUsername(expectedUsername, response);
        };
    }

    private static void validateDestinations(Set<String> destinations, Map<String, List<String>> customFieldMapping) throws BugTrackerException {
        List<String> missingDestinations = destinations.stream().filter(destination -> customFieldMapping.get(destination) == null).toList();
        if (!missingDestinations.isEmpty()) {
            throw new BugTrackerException("Could not find requested custom field [" + missingDestinations.stream().map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")) + "] in Jira server, or provided custom field is not a textarea. Please check provided custom field names.");
        }
    }

    private static EKeyedObjectType getEKeyedObjectType(String fieldType) {
        return switch (fieldType) {
            case "array" -> EKeyedObjectType.STRING_LIST;
            case "datetime" -> EKeyedObjectType.DATE;
            default -> EKeyedObjectType.STRING;
        };
    }

    static ServiceCallException createEmptyResponseException() {
        return new ServiceCallException("Response was empty.");
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public EJiraInstanceType getInstanceType() throws ServiceCallException {
        JiraServerInfo serverInfo = (JiraServerInfo)Retrofit.executeServiceCall(this.jira.getServerInfo()).orElseThrow(JiraClient::createEmptyResponseException);
        return serverInfo.getDeploymentType();
    }

    public JiraInstanceAwareClient toInstanceAwareClient(EJiraInstanceType jiraInstanceType) {
        return switch (jiraInstanceType) {
            default -> throw new MatchException(null, null);
            case EJiraInstanceType.CLOUD -> new JiraCloudClient(this.baseUrl, this.username, this.password, this.cookies);
            case EJiraInstanceType.DATA_CENTER -> new JiraDataCenterClient(this.baseUrl, this.username, this.password, this.cookies);
        };
    }

    @TestOnly
    protected IJiraCommonApi getJiraApi() {
        return this.jira;
    }
}

