/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class JiraJsonIssue
implements Serializable {
    public static final String PROJECT_KEY = "project";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="key")
    public String key;
    @JsonProperty(value="fields")
    public Fields fields;
    @JsonProperty(value="renderedFields")
    public RenderedFields renderedFields;
    @JsonProperty(value="changelog")
    public ChangeLog changeLog;

    public static void addAdditionalFields(Fields jiraIssueFields, String key, List<String> customFieldNames, List<String> customFieldValues, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (jiraIssueFields == null) {
            jiraIssueFields = new Fields();
        }
        JiraJsonIssue.addProjectKey(key, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addIssueTypeField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addPriorityField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addResolutionField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addFixVersionField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addComponentField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addLabelsField(jiraIssueFields, additionalFieldNames, additionalFieldValues);
        JiraJsonIssue.addCustomFields(customFieldNames, customFieldValues, additionalFieldNames, additionalFieldValues);
    }

    public static TeamscaleIssue createTeamscaleIssue(String key, String connectorId, String url, Fields jiraIssueFields, String description, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (jiraIssueFields == null) {
            jiraIssueFields = new Fields();
        }
        return new TeamscaleIssue(new TeamscaleIssueId(connectorId, key), StringUtils.emptyIfNull((String)jiraIssueFields.summary), JiraJsonIssue.getUserNameOrEmpty(jiraIssueFields.assignee), JiraJsonIssue.getUserNameOrEmpty(jiraIssueFields.reporter), StringUtils.emptyIfNull((String)description), JiraJsonIssue.getTimeOrZero(jiraIssueFields.created), JiraJsonIssue.getTimeOrZero(jiraIssueFields.updated), JiraJsonIssue.getNameOrEmpty(jiraIssueFields.status), !jiraIssueFields.resolution.name.equals("Unresolved"), url, additionalFieldNames, additionalFieldValues, JiraJsonIssue.getParentIdOrNull(jiraIssueFields.issueLinks));
    }

    private static void addProjectKey(String key, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        additionalFieldNames.add(PROJECT_KEY);
        additionalFieldValues.add(key.split("-")[0]);
    }

    private static void addCustomFields(List<String> customFieldNames, List<String> customFieldValues, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        additionalFieldNames.addAll(customFieldNames);
        additionalFieldValues.addAll(customFieldValues);
    }

    private static void addLabelsField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (!CollectionUtils.isNullOrEmpty(jiraIssueFields.labels)) {
            additionalFieldNames.add("Labels");
            jiraIssueFields.labels.replaceAll(String::trim);
            additionalFieldValues.add(StringUtils.concat(jiraIssueFields.labels, (String)","));
        }
    }

    private static void addComponentField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (!CollectionUtils.isNullOrEmpty(jiraIssueFields.components)) {
            additionalFieldNames.add("Components");
            additionalFieldValues.add(StringUtils.concat((Iterable)CollectionUtils.map(jiraIssueFields.components, component -> component.name.trim()), (String)","));
        }
    }

    private static void addFixVersionField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (!CollectionUtils.isNullOrEmpty(jiraIssueFields.fixVersions)) {
            additionalFieldNames.add("Fix Versions");
            additionalFieldValues.add(StringUtils.concat((Iterable)CollectionUtils.map(jiraIssueFields.fixVersions, fixVersion -> fixVersion.name.trim()), (String)","));
        }
    }

    private static void addResolutionField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (jiraIssueFields.resolution == null) {
            jiraIssueFields.resolution = new Resolution();
            jiraIssueFields.resolution.name = "Unresolved";
        }
        additionalFieldNames.add("Resolution");
        additionalFieldValues.add(jiraIssueFields.resolution.name);
    }

    private static void addPriorityField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (jiraIssueFields.priority != null) {
            additionalFieldNames.add("Priority");
            additionalFieldValues.add(jiraIssueFields.priority.name);
        }
    }

    private static void addIssueTypeField(Fields jiraIssueFields, List<String> additionalFieldNames, List<String> additionalFieldValues) {
        if (jiraIssueFields.issueType != null) {
            additionalFieldNames.add("Type");
            additionalFieldValues.add(jiraIssueFields.issueType.name);
        }
    }

    private static String getParentIdOrNull(List<IssueLink> issueLinks) {
        if (issueLinks == null) {
            return null;
        }
        for (IssueLink issueLink : issueLinks) {
            if (!issueLink.type.name.equals("Parent") || issueLink.inwardIssue == null) continue;
            return issueLink.inwardIssue.key;
        }
        return null;
    }

    private static String getUserNameOrEmpty(User user) {
        if (user == null) {
            return "";
        }
        return StringUtils.isEmptyOrElse((String)user.name, (String)StringUtils.emptyIfNull((String)user.displayName));
    }

    private static String getNameOrEmpty(FieldWithName field) {
        if (field == null) {
            return "";
        }
        return StringUtils.emptyIfNull((String)field.name);
    }

    private static long getTimeOrZero(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public static class Fields {
        @JsonProperty(value="summary")
        public String summary;
        @JsonProperty(value="assignee")
        public User assignee;
        @JsonProperty(value="reporter")
        public User reporter;
        @JsonProperty(value="description")
        public String description;
        @JsonProperty(value="created")
        public Date created;
        @JsonProperty(value="updated")
        public Date updated;
        @JsonProperty(value="issuetype")
        public IssueType issueType;
        @JsonProperty(value="issuelinks")
        public List<IssueLink> issueLinks;
        @JsonProperty(value="priority")
        public Priority priority;
        @JsonProperty(value="status")
        public Status status;
        @JsonProperty(value="resolution")
        public Resolution resolution;
        @JsonProperty(value="fixVersions")
        public List<FixVersion> fixVersions;
        @JsonProperty(value="components")
        public List<Component> components;
        @JsonProperty(value="labels")
        public List<String> labels;
        public static final String LABELS_FIELD_NAME = "Labels";
    }

    public static class User
    extends FieldWithName {
        @JsonProperty(value="displayName")
        public String displayName;
        @JsonProperty(value="active")
        public boolean active;
    }

    public static class Status
    extends FieldWithName {
        @JsonProperty(value="description")
        public String description;
    }

    public static abstract class FieldWithName {
        @JsonProperty(value="name")
        public String name;
    }

    public static class Resolution
    extends FieldWithName {
        public static final String FIELD_NAME = "Resolution";
        public static final String UNRESOLVED = "Unresolved";
    }

    public static class Component
    extends FieldWithName {
        public static final String FIELD_NAME = "Components";
    }

    public static class FixVersion
    extends FieldWithName {
        public static final String FIELD_NAME = "Fix Versions";
    }

    public static class Priority
    extends FieldWithName {
        public static final String FIELD_NAME = "Priority";
        @JsonProperty(value="id")
        public String id;
    }

    public static class IssueType
    extends FieldWithName {
        public static final String FIELD_NAME = "Type";
        @JsonProperty(value="description")
        public String description;
        @JsonProperty(value="id")
        public String id;
    }

    public static class IssueLink
    extends FieldWithName {
        @JsonProperty(value="id")
        public String id;
        @JsonProperty(value="type")
        public IssueLinkType type;
        @JsonProperty(value="inwardIssue")
        public JiraJsonIssue inwardIssue;
    }

    public static class IssueLinkType
    extends FieldWithName {
        @JsonProperty(value="inward")
        public String inward;
    }

    public static class HistoryChangeItem {
        @JsonProperty(value="field")
        public String field;
        @JsonProperty(value="fieldtype")
        public String fieldType;
        @JsonProperty(value="from")
        public String from;
        @JsonProperty(value="fromString")
        public String fromString;

        public String toString() {
            return "HistoryChangeItem [field=" + this.field + ", fieldtype=" + this.fieldType + ", from=" + this.from + ", fromString=" + this.fromString + "]";
        }
    }

    public static class HistoryEntry {
        @JsonProperty(value="created")
        public Date created;
        @JsonProperty(value="items")
        public HistoryChangeItem[] items;

        public String toString() {
            return "HistoryEntry [created=" + String.valueOf(this.created) + ", items=" + Arrays.toString(this.items) + "]";
        }

        public void mergeIn(HistoryEntry history) {
            int oldItemsSize = this.items.length;
            this.items = Arrays.copyOf(this.items, oldItemsSize + history.items.length);
            System.arraycopy(history.items, 0, this.items, oldItemsSize, history.items.length);
        }
    }

    public static class ChangeLog {
        @JsonProperty(value="histories")
        public HistoryEntry[] histories;
    }

    public static class RenderedFields {
        @JsonProperty(value="description")
        public String description;
    }
}

