/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.radar.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.index.issues.radar.client.RadarComponentQuery;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;

public record RadarComponent(@JsonProperty int id, @JsonProperty String name, @JsonProperty String version) {
    public static RadarComponentQuery createQueryFromComponentName(String componentName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)componentName) ? 1 : 0) != 0);
        List substrings = StringUtils.splitToList((String)componentName, (String)"\\|");
        Preconditions.checkState((substrings.size() <= 2 ? 1 : 0) != 0, (Object)"Component name can contain at most one version separator (\"|\")");
        String version = null;
        if (substrings.size() == 2) {
            version = (String)substrings.get(1);
        }
        return new RadarComponentQuery((String)substrings.getFirst(), version);
    }

    public String fullName() {
        return "%s | %s".formatted(this.name, this.version);
    }
}

