/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class MergeRequestProcessor<PROVIDER extends MergeRequestProvider<PLATFORM_SPECIFIC_MERGE_REQUEST, ?>, PLATFORM_SPECIFIC_MERGE_REQUEST> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PROVIDER provider;
    private final MergeRequestIndex mergeRequestIndex;
    private final CrossRepositoryMergeRequestSourceBranchesIndex crossRepositoryMergeRequestSourceBranchesIndex;

    public MergeRequestProcessor(PROVIDER provider, MergeRequestIndex mergeRequestIndex, CrossRepositoryMergeRequestSourceBranchesIndex crossRepositoryMergeRequestSourceBranchesIndex) {
        this.provider = provider;
        this.mergeRequestIndex = mergeRequestIndex;
        this.crossRepositoryMergeRequestSourceBranchesIndex = crossRepositoryMergeRequestSourceBranchesIndex;
    }

    public MergeRequestSyncResult synchronizeMergeRequests(RepositoryRevisionIndex repositoryRevisionIndex, BranchAnalysisStateIndex branchAnalysisStateIndex) throws StorageException, ServiceCallException {
        ArrayList<CommitDescriptor> reschedulePostRevisionTriggerCommits = new ArrayList<CommitDescriptor>();
        List openPlatformMergeRequests = ((MergeRequestProvider)this.provider).getAllOpenPlatformMergeRequests();
        List<MergeRequest> openMergeRequests = ((MergeRequestProvider)this.provider).convertToMergeRequests(openPlatformMergeRequests);
        boolean hadCrossRepositoryMergeRequestUpdates = this.processOpenMergeRequests(openMergeRequests, openPlatformMergeRequests, reschedulePostRevisionTriggerCommits, repositoryRevisionIndex, branchAnalysisStateIndex);
        this.updateCrossRepositorySourceBranchesIndexForInactiveMergeRequests(openPlatformMergeRequests, openMergeRequests);
        this.updateMergeRequestIndexForInactiveMergeRequests(this.provider, openMergeRequests);
        return new MergeRequestSyncResult(hadCrossRepositoryMergeRequestUpdates, reschedulePostRevisionTriggerCommits);
    }

    public ProcessMergeRequestResult processMergeRequest(MergeRequestIdentifier mergeRequestIdentifier) throws ServiceCallException, StorageException {
        Object platformMergeRequest = ((MergeRequestProvider)this.provider).getPlatformMergeRequest(mergeRequestIdentifier.id);
        MergeRequest convertedMergeRequest = ((MergeRequestProvider)this.provider).convertToMergeRequest(platformMergeRequest);
        return this.processMergeRequest(mergeRequestIdentifier, platformMergeRequest, convertedMergeRequest);
    }

    public ProcessMergeRequestResult processMergeRequestWithCachedPlatformMergeRequest(MergeRequestIdentifier mergeRequestIdentifier, @Nullable PLATFORM_SPECIFIC_MERGE_REQUEST platformMergeRequest) throws ServiceCallException, StorageException {
        MergeRequest convertedMergeRequest = ((MergeRequestProvider)this.provider).convertToMergeRequest(platformMergeRequest);
        return this.processMergeRequest(mergeRequestIdentifier, platformMergeRequest, convertedMergeRequest);
    }

    private ProcessMergeRequestResult processMergeRequest(@NonNull MergeRequestIdentifier mergeRequestIdentifier, @Nullable PLATFORM_SPECIFIC_MERGE_REQUEST platformSpecificMergeRequest, @Nullable MergeRequest convertedMergeRequest) throws StorageException, ServiceCallException {
        if (platformSpecificMergeRequest == null || convertedMergeRequest == null || !((MergeRequestProvider)this.provider).isMergeRequestSupported(platformSpecificMergeRequest) || convertedMergeRequest.shouldBeRemovedFromIndex()) {
            LOGGER.debug("Platform merge request {} is inactive", (Object)mergeRequestIdentifier);
            this.deleteMergeRequest(mergeRequestIdentifier, platformSpecificMergeRequest);
            return new ProcessMergeRequestResult(false, convertedMergeRequest, false, null);
        }
        LOGGER.debug("Converted platform merge request payload to MergeRequest object: {}", (Object)JsonUtils.serializeToJSON((Object)convertedMergeRequest));
        ProcessMergeRequestResult processMergeRequestResult = this.updateMergeRequestIndices(convertedMergeRequest, platformSpecificMergeRequest);
        LOGGER.debug("Processed merge request {} with result {}", (Object)mergeRequestIdentifier, (Object)processMergeRequestResult);
        return processMergeRequestResult;
    }

    private boolean processOpenMergeRequests(List<MergeRequest> mergeRequests, List<PLATFORM_SPECIFIC_MERGE_REQUEST> platformMergeRequests, List<CommitDescriptor> reschedulePostRevisionTriggerCommits, RepositoryRevisionIndex repositoryRevisionIndex, BranchAnalysisStateIndex branchAnalysisStateIndex) throws StorageException, ServiceCallException {
        boolean hadCrossRepoMergeRequestUpdates = false;
        for (int i = 0; i < mergeRequests.size(); ++i) {
            MergeRequest mergeRequest = mergeRequests.get(i);
            PLATFORM_SPECIFIC_MERGE_REQUEST platformMergeRequest = platformMergeRequests.get(i);
            ProcessMergeRequestResult result = this.processMergeRequest(mergeRequest.identifier, platformMergeRequest, mergeRequest);
            hadCrossRepoMergeRequestUpdates |= result.crossRepositorySourceBranchWasUpdated();
            if (!result.mergeRequestNeedsUpdate()) continue;
            Optional<CommitDescriptor> commit = MergeRequestUtils.retrieveMergeRequestHeadCommitIfLive(mergeRequest, repositoryRevisionIndex, branchAnalysisStateIndex, ((MergeRequestProvider)this.provider).getCrossRepositorySourceBranch(platformMergeRequest).orElse(null));
            commit.ifPresent(reschedulePostRevisionTriggerCommits::add);
        }
        return hadCrossRepoMergeRequestUpdates;
    }

    private void updateCrossRepositorySourceBranchesIndexForInactiveMergeRequests(@NonNull List<PLATFORM_SPECIFIC_MERGE_REQUEST> platformMergeRequests, List<MergeRequest> convertedMergeRequests) throws StorageException, ServiceCallException {
        UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> oldActiveBranches = this.crossRepositoryMergeRequestSourceBranchesIndex.readAllActiveBranches();
        PairList mergeRequests = PairList.zip(platformMergeRequests, convertedMergeRequests);
        List openPlatformMergeRequests = (List)IStreamWithException.wrap((Stream)mergeRequests.stream(), ServiceCallException.class).filter(mr -> ((MergeRequest)mr.getSecond()).status == EMergeRequestStatus.OPEN).map(ImmutablePair::getFirst).collect(Collectors.toList());
        List newActiveBranches = CollectionUtils.mapWithException((Collection)openPlatformMergeRequests, arg_0 -> this.provider.getCrossRepositorySourceBranch(arg_0)).stream().flatMap(Optional::stream).toList();
        List<CrossRepositoryMergeRequestSourceBranch> inactiveBranches = CollectionUtils.differenceSet(oldActiveBranches, (Collection[])new Collection[]{newActiveBranches}).stream().toList();
        this.crossRepositoryMergeRequestSourceBranchesIndex.storeInactive(inactiveBranches);
    }

    private void updateMergeRequestIndexForInactiveMergeRequests(PROVIDER provider, List<MergeRequest> openMergeRequests) throws StorageException, ServiceCallException {
        List<MergeRequest> inactiveStoredMergeRequests = this.mergeRequestIndex.getAllMergeRequests();
        inactiveStoredMergeRequests.removeAll(openMergeRequests);
        LOGGER.info("Found {} MRs, which are stored, but not listed as open on the code collaboration platform with ids {}", (Object)inactiveStoredMergeRequests.size(), (Object)inactiveStoredMergeRequests.stream().map(storedMergeRequest -> storedMergeRequest.identifier.toString()).collect(Collectors.joining(",")));
        for (MergeRequest inactiveStoredMergeRequest : inactiveStoredMergeRequests) {
            if (!((MergeRequestProvider)provider).getRepositoryName().equals(inactiveStoredMergeRequest.getRepositoryName())) continue;
            this.processMergeRequest(inactiveStoredMergeRequest.identifier);
        }
    }

    private void deleteMergeRequest(@NonNull MergeRequestIdentifier mergeRequestIdentifier, @Nullable PLATFORM_SPECIFIC_MERGE_REQUEST platformMergeRequest) throws StorageException {
        this.mergeRequestIndex.removeMergeRequest(mergeRequestIdentifier);
        Optional<CrossRepositoryMergeRequestSourceBranch> crossRepositorySourceBranch = ((MergeRequestProvider)this.provider).getCrossRepositorySourceBranch(platformMergeRequest);
        if (crossRepositorySourceBranch.isPresent()) {
            this.crossRepositoryMergeRequestSourceBranchesIndex.storeInactive(crossRepositorySourceBranch.get());
        }
    }

    private @NonNull ProcessMergeRequestResult updateMergeRequestIndices(@NonNull MergeRequest mergeRequest, @Nullable PLATFORM_SPECIFIC_MERGE_REQUEST platformMergeRequest) throws StorageException {
        boolean mergeRequestNeedsUpdate = this.mergeRequestIndex.reAssociateMergeRequest(mergeRequest);
        boolean crossRepositorySourceBranchWasUpdated = false;
        Optional<CrossRepositoryMergeRequestSourceBranch> sourceBranch = ((MergeRequestProvider)this.provider).getCrossRepositorySourceBranch(platformMergeRequest);
        if (sourceBranch.isPresent()) {
            if (mergeRequest.status == EMergeRequestStatus.OPEN) {
                crossRepositorySourceBranchWasUpdated = this.crossRepositoryMergeRequestSourceBranchesIndex.updateActive(sourceBranch.get());
            } else {
                this.crossRepositoryMergeRequestSourceBranchesIndex.storeInactive(sourceBranch.get());
            }
        }
        return new ProcessMergeRequestResult(mergeRequestNeedsUpdate, mergeRequest, crossRepositorySourceBranchWasUpdated, sourceBranch.orElse(null));
    }

    public record MergeRequestSyncResult(boolean hadCrossRepositoryMergeRequestUpdates, List<CommitDescriptor> reschedulePostRevisionTriggerCommits) {
    }

    public record ProcessMergeRequestResult(boolean mergeRequestNeedsUpdate, @Nullable MergeRequest updatedMergeRequest, boolean crossRepositorySourceBranchWasUpdated, @Nullable CrossRepositoryMergeRequestSourceBranch crossRepositorySourceBranch) {
    }
}

