/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.comments;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.merge_request.comments.comments.FindingsForReviewComment;
import com.teamscale.index.merge_request.comments.comments.SingleFindingReviewComment;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;

public abstract class MultiFindingReviewCommentBase
extends SingleFindingReviewComment {
    protected final FindingsForReviewComment findingsForReviewComment;
    private final List<String> findingIdsForLinks = new ArrayList<String>();

    protected MultiFindingReviewCommentBase(FindingsForReviewComment findingsForReviewComment, CommitDescriptor commentedCommit, TeamscaleCommitLinkProvider linkProvider) {
        super(findingsForReviewComment.getMainFinding(commentedCommit), commentedCommit, linkProvider);
        this.findingsForReviewComment = findingsForReviewComment;
    }

    protected String generateLink(String linkText, String findingId, boolean isMarkdown) {
        if (isMarkdown) {
            return String.format("[%s](%s)", linkText, this.linkProvider.createFindingsDetailLink(findingId));
        }
        this.findingIdsForLinks.add(findingId);
        return String.format("%s [%s]", linkText, this.findingIdsForLinks.size() - 1);
    }

    protected List<Integer> addFindingsToFootnoteLinks(List<TrackedFinding> findings) {
        ArrayList<Integer> footnoteIds = new ArrayList<Integer>();
        for (TrackedFinding finding : findings) {
            this.findingIdsForLinks.add(finding.getId());
            footnoteIds.add(this.findingIdsForLinks.size() - 1);
        }
        return footnoteIds;
    }

    protected String generateFootnoteLinks() {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (String findingId : this.findingIdsForLinks) {
            sb.append(String.format("%n[%d] %s", index++, this.linkProvider.createFindingsDetailLink(findingId)));
        }
        return sb.toString();
    }

    @Override
    public String getTeamscaleCommitDetailUrl() {
        return this.linkProvider.createFindingsDetailLink(this.findingIdsForLinks.get(0));
    }
}

