/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.option.PairListOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.StringValuePairListOptionDescriptor;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class ProjectVersion33IstanbulReportMappingMigration {
    private static final String ANALYSIS_REPORT_MAPPING_OPTION = "Analysis report mapping";
    private static final String ISTANBUL_REPORT_FORMAT = "ISTANBUL";

    public static String migrate(String json) throws JsonSerializationException, ProjectConfigurationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        for (ConnectorConfiguration connector : holder.connectors) {
            ProjectVersion33IstanbulReportMappingMigration.migrateAnalysisReportMapping(connector);
        }
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static void migrateAnalysisReportMapping(ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException {
        String optionValue = connectorConfiguration.getOptionValue(ANALYSIS_REPORT_MAPPING_OPTION);
        if (StringUtils.isEmpty((String)optionValue)) {
            return;
        }
        PairList pairs = StringValuePairListOptionDescriptor.parseFromString((String)optionValue);
        for (int i = 0; i < pairs.size(); ++i) {
            String format = (String)pairs.getSecond(i);
            if (!ISTANBUL_REPORT_FORMAT.equals(format)) continue;
            pairs.remove(i);
            --i;
        }
        connectorConfiguration.setOptionValue(ANALYSIS_REPORT_MAPPING_OPTION, PairListOptionDescriptorBase.getValueAsString((Object)pairs));
    }
}

