/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.MetricTrendChartSlide;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class AssessmentTrendChartSlide
extends ReportSlideBase<AssessmentTrendChartSlideParameters, MetricTrendChartSlide.TrendChartSlideResult> {
    private static final long serialVersionUID = 1L;

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.ASSESSMENT_TREND;
    }

    @IndexValueClass(containedInBackup=true)
    public static class AssessmentTrendChartSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @SlideParameter(formattedName="Project, Branch & Path", type=ESlideOptionType.PROJECT_BRANCH_PATH)
        @JsonProperty(value="projectBranchPath")
        private ProjectBranchPath projectBranchPath;
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        @JsonProperty(value="slideTitle")
        private String slideTitle;
        @SlideParameter(formattedName="Metric", type=ESlideOptionType.ASSESSMENT_METRIC)
        @JsonProperty(value="assessmentName")
        private String assessmentName;
        @SlideParameter(formattedName="Show ratios", type=ESlideOptionType.BOOLEAN)
        @JsonProperty(value="showRatios")
        private boolean showRatios;
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        @JsonProperty(value="comments")
        private List<ISlideComment> comments;

        @JsonCreator
        AssessmentTrendChartSlideParameters() {
        }

        public AssessmentTrendChartSlideParameters(ProjectBranchPath projectBranchPath, String slideTitle, String assessmentName, boolean showRatios, List<ISlideComment> comments) {
            this.projectBranchPath = projectBranchPath;
            this.slideTitle = slideTitle;
            this.assessmentName = assessmentName;
            this.showRatios = showRatios;
            this.comments = comments;
        }

        public ProjectBranchPath getProjectBranchPath() {
            return this.projectBranchPath;
        }

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            if (this.projectBranchPath == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.projectBranchPath.getProjectId());
        }

        public String getAssessmentName() {
            return this.assessmentName;
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }
    }
}

