/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage;

import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.SimpleValidLinesFilter;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;

public class CoverageReportPathMatchingPlausibilityCheck
implements IPathMatchingPlausibilityCheck {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CoverageInfoRetriever coverageInfoRetriever;
    private final String pathPrefix;
    private final Set<String> allPaths;
    private final boolean disablePlausibilityCheckForPathMapping;
    private final TokenElementLineInfoIndex tokenElementLineInfoIndex;

    public CoverageReportPathMatchingPlausibilityCheck(TokenElementLineInfoIndex tokenElementLineInfoIndex, CoverageInfoRetriever coverageInfoRetriever, String pathPrefix, boolean disablePlausibilityCheckForPathMapping) {
        this.tokenElementLineInfoIndex = tokenElementLineInfoIndex;
        this.coverageInfoRetriever = coverageInfoRetriever;
        this.pathPrefix = pathPrefix;
        this.allPaths = coverageInfoRetriever.getAllPaths();
        this.disablePlausibilityCheckForPathMapping = disablePlausibilityCheckForPathMapping;
    }

    @Override
    public boolean check(String pathMatchingCandidate, String pathFromReport) {
        TokenElementLineInfo tokenElementLineInfo;
        if (this.pathPrefix != null && !pathMatchingCandidate.startsWith(this.pathPrefix)) {
            LOGGER.warn("pathMatchingCandidate: " + pathMatchingCandidate + " pathFromReport: " + pathFromReport + " pathPrefix: " + this.pathPrefix);
            return false;
        }
        if (!this.allPaths.contains(pathFromReport)) {
            LOGGER.error("No coverage info found for report path " + pathFromReport);
            return false;
        }
        if (this.disablePlausibilityCheckForPathMapping) {
            return true;
        }
        LineCoverageInfo lineCoverageInfo = (LineCoverageInfo)this.coverageInfoRetriever.getAllLineCoverage().get(pathFromReport);
        if (lineCoverageInfo == null) {
            return true;
        }
        int highestLineNumber = lineCoverageInfo.getHighestLineNumber();
        if (highestLineNumber == 0) {
            return true;
        }
        try {
            tokenElementLineInfo = this.tokenElementLineInfoIndex.getLineInfo(pathMatchingCandidate);
            if (tokenElementLineInfo == null) {
                LOGGER.warn("Could not find line info for path " + pathMatchingCandidate);
                return false;
            }
        }
        catch (StorageException e) {
            LOGGER.warn("Could not open token element index for path " + pathMatchingCandidate);
            return false;
        }
        SimpleValidLinesFilter validLinesFilter = new SimpleValidLinesFilter(tokenElementLineInfo.getLineCount());
        boolean isValidLine = validLinesFilter.isValidLine(highestLineNumber);
        if (!isValidLine) {
            LOGGER.warn("Path {} has implausible covered line: {}", (Object)pathMatchingCandidate, (Object)highestLineNumber);
        }
        return isValidLine;
    }
}

