/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage.testwise_coverage;

import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.SimpleValidLinesFilter;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CompactLines;

public class TestWiseCoveragePathMatchingPlausibilityCheck
implements IPathMatchingPlausibilityCheck {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CompactLines coveredLines;
    private final TokenElementLineInfoIndex tokenElementLineInfoIndex;

    public TestWiseCoveragePathMatchingPlausibilityCheck(TokenElementLineInfoIndex tokenElementLineInfoIndex, CompactLines coveredLines) {
        this.tokenElementLineInfoIndex = tokenElementLineInfoIndex;
        this.coveredLines = coveredLines;
    }

    @Override
    public boolean check(String patchMatchingCandidate, String unused) {
        TokenElementLineInfo tokenElementLineInfo;
        if (this.coveredLines.isEmpty()) {
            return true;
        }
        try {
            tokenElementLineInfo = this.tokenElementLineInfoIndex.getLineInfo(patchMatchingCandidate);
        }
        catch (StorageException e) {
            LOGGER.warn("Could not open token element line info index for path " + patchMatchingCandidate);
            return false;
        }
        SimpleValidLinesFilter validLinesFilter = new SimpleValidLinesFilter(tokenElementLineInfo.getLineCount());
        Iterator iterator = this.coveredLines.iterator();
        while (iterator.hasNext()) {
            int coveredLine = (Integer)iterator.next();
            if (validLinesFilter.isValidLine(coveredLine)) continue;
            return false;
        }
        return true;
    }
}

