/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser.sap_code_inspector;

import com.teamscale.index.gitbridge.abap.code_inspector.CodeInspectorData;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class CodePalFindings {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Set<String> KNOWN_CODE_PAL_FINDING_IDS = Set.of("Y_CHECK_BOOLEAN_INPUT_PARAM", "Y_CHECK_BRANCH_COVERAGE", "Y_CHECK_CALL_METHOD_USAGE", "Y_CHECK_CHAIN_DECL_USAGE", "Y_CHECK_CHECK_IN_LOOP", "Y_CHECK_CHECK_STMNT_POSITION", "Y_CHECK_COLLECT", "Y_CHECK_COMMENT_POSITION", "Y_CHECK_COMMENT_TYPE", "Y_CHECK_COMMENT_USAGE", "Y_CHECK_CONSTANTS_INTERFACE", "Y_CHECK_CX_ROOT_USAGE", "Y_CHECK_CYCLOMATIC_COMPLEXITY", "Y_CHECK_DB_ACCESS_IN_UT", "Y_CHECK_DEFAULT_KEY", "Y_CHECK_DEPRECATED_CLASSES", "Y_CHECK_DEPRECATED_KEY_WORDS", "Y_CHECK_EMPTY_CATCHES", "Y_CHECK_EMPTY_IF_BRANCHES", "Y_CHECK_EMPTY_PROCEDURES", "Y_CHECK_EQUALS_SIGN_CHAINING", "Y_CHECK_EXTERNAL_CALL_IN_UT", "Y_CHECK_FORM", "Y_CHECK_FUNCTION", "Y_CHECK_IS_INTERFACE_IN_CLASS", "Y_CHECK_MAGIC_NUMBER", "Y_CHECK_MAX_NESTING_DEPTH", "Y_CHECK_MESSAGE_EASY_TO_FIND", "Y_CHECK_MESSAGE_TRANSLATION", "Y_CHECK_METHOD_OUTPUT_PARAM", "Y_CHECK_METHOD_RETURN_BOOL", "Y_CHECK_NON_CLASS_EXCEPTION", "Y_CHECK_NUMBER_ATTRIBUTES", "Y_CHECK_NUMBER_EVENTS", "Y_CHECK_NUMBER_INTERFACES", "Y_CHECK_NUMBER_METHODS", "Y_CHECK_NUM_EXEC_STATEMENTS", "Y_CHECK_NUM_OUTPUT_PARAMETER", "Y_CHECK_NUM_PUBLIC_ATTRIBUTES", "Y_CHECK_OMIT_OPTIONAL_EXP", "Y_CHECK_OPTIONAL_PARAMETERS", "Y_CHECK_PREFER_CASE_TO_ELSEIF", "Y_CHECK_PREFER_IS_NOT", "Y_CHECK_PREFER_LINE_EXISTS", "Y_CHECK_PREFER_NEW_TO_CRT_OBJ", "Y_CHECK_PREFER_PRAGMAS", "Y_CHECK_PREFER_RETURNING", "Y_CHECK_PROCEDURE_COVERAGE", "Y_CHECK_PSEUDO_COMMENT_USAGE", "Y_CHECK_RECEIVING_USAGE", "Y_CHECK_RETURNING_NAME", "Y_CHECK_SCOPE_OF_VARIABLE", "Y_CHECK_SELF_REFERENCE", "Y_CHECK_STATEMENT_COVERAGE", "Y_CHECK_SUB_ASSIGN_READ_TABLE", "Y_CHECK_TEST_SEAM_USAGE", "Y_CHECK_TEXT_ASSEMBLY", "Y_CHECK_UNIT_TEST_ASSERT");
    private static final String PROFILE_MESSAGE_CHECK_ID = "Y_CHECK_PROFILE_MESSAGE";
    private static final String SCI_ERROR_MESSAGE_TYPE = "E";
    private static final String CODE_PAL_ID_FINDING_PROPERTY_NAME = "Code Pal Id";

    static boolean canHandleCodeInspectorCheckId(String id) {
        if (id.equals(PROFILE_MESSAGE_CHECK_ID)) {
            return true;
        }
        return KNOWN_CODE_PAL_FINDING_IDS.contains(id);
    }

    public static @Nullable DetachedFinding createFindingForCodePalSciEntry(String uniformPath, CodeInspectorData dataEntry) {
        String codePalCheckId = dataEntry.getObjectTypeName();
        CCSMAssert.isTrue((boolean)CodePalFindings.canHandleCodeInspectorCheckId(codePalCheckId), (String)("SCI check id " + dataEntry.getObjectTypeName() + " is not known as code pal check id."));
        String message = dataEntry.getMessage();
        if (codePalCheckId.equals(PROFILE_MESSAGE_CHECK_ID)) {
            LOGGER.info("Ignoring code pal check Y_CHECK_PROFILE_MESSAGE. Message: " + message);
            return null;
        }
        String messageType = dataEntry.getMessageType();
        ETrafficLightColor findingAssessment = messageType.equals(SCI_ERROR_MESSAGE_TYPE) ? ETrafficLightColor.RED : ETrafficLightColor.YELLOW;
        int startLine = dataEntry.getStartLine();
        DetachedFinding finding = FindingCollectingReportParserBase.createLineFinding(startLine, uniformPath, codePalCheckId, "Code Inspector", message);
        finding.setAssessment(findingAssessment);
        finding.setProperty(CODE_PAL_ID_FINDING_PROPERTY_NAME, (Object)codePalCheckId);
        return finding;
    }
}

