/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="repository-log-file", options={EStorageOption.COMMIT_ISOLATED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={RepositoryLogFileEntry.class})
public class RepositoryLogFileIndex
extends IndexBase
implements IRollbackableIndex,
IProjectIndex {
    public static final String INDEX_NAME = "repository-log-file";
    private static final byte IS_DELETED_BYTE = 1;
    private static final byte IS_NOT_DELETED_BYTE = 0;

    public RepositoryLogFileIndex(IStore store) {
        super(store);
    }

    public void insertEntries(Collection<RepositoryLogFileEntry> entries) throws StorageException {
        if (entries.isEmpty()) {
            return;
        }
        Map<CommitDescriptor, List<RepositoryLogFileEntry>> newEntriesGroupedByCommit = entries.stream().collect(Collectors.groupingBy(CommitAssociatedObjectBase::getCommit));
        ArrayList<CommitDescriptor> commits = new ArrayList<CommitDescriptor>(newEntriesGroupedByCommit.keySet());
        PairList insertions = new PairList();
        RunnableWithException insertionRunnable = () -> {
            ListMap<CommitDescriptor, RepositoryLogFileEntry> entriesForCommits = this.getEntriesForCommits(commits);
            for (Map.Entry newEntry : newEntriesGroupedByCommit.entrySet()) {
                TwoDimHashMap mergedResults = new TwoDimHashMap();
                List oldResults = (List)entriesForCommits.getCollection((Object)((CommitDescriptor)newEntry.getKey()));
                if (oldResults != null) {
                    for (RepositoryLogFileEntry oldResult : oldResults) {
                        mergedResults.putValue((Object)oldResult.getUniformPath(), (Object)oldResult.getCommitType(), (Object)oldResult);
                    }
                }
                for (RepositoryLogFileEntry newResult : (List)newEntry.getValue()) {
                    mergedResults.putValue((Object)newResult.getUniformPath(), (Object)newResult.getCommitType(), (Object)newResult);
                }
                if (mergedResults.isEmpty()) continue;
                insertions.add((Object)this.serializeKey((CommitDescriptor)newEntry.getKey()), (Object)this.serializeEntry(mergedResults.getValues()));
            }
            this.store.put(insertions);
        };
        this.store.performWithLock(insertionRunnable);
    }

    private static Set<Integer> extractAbbreviations(List<byte[]> results) {
        HashSet<Integer> abbreviations = new HashSet<Integer>();
        for (byte[] bytes : results) {
            if (bytes == null) continue;
            int numEntries = ByteArrayUtils.readIntFromStartOfArray((byte[])bytes);
            int offset = 4;
            for (int i = 0; i < numEntries; ++i) {
                abbreviations.add(ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)offset));
                offset += 13;
            }
        }
        return abbreviations;
    }

    @Contract(value="null, _, _ -> null; !null, _, _ -> !null")
    private static @Nullable List<RepositoryLogFileEntry> deserializeEntry(byte @Nullable [] bytes, CommitDescriptor commitDescriptor, Map<Integer, String> abbreviationMap) {
        if (bytes == null) {
            return null;
        }
        ArrayList<RepositoryLogFileEntry> entries = new ArrayList<RepositoryLogFileEntry>();
        int numEntries = ByteArrayUtils.readIntFromStartOfArray((byte[])bytes);
        int offset = 4;
        for (int i = 0; i < numEntries; ++i) {
            UniformPath path = UniformPath.parse((String)abbreviationMap.get(ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)offset)));
            int commitTypeOrdinal = ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)(offset += 4));
            int subTypeOrdinal = ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)(offset += 4));
            boolean isDeleted = bytes[offset += 4] == 1;
            ++offset;
            EExternalAnalysisResultType subType = subTypeOrdinal >= 0 ? EExternalAnalysisResultType.values()[subTypeOrdinal] : null;
            entries.add(new RepositoryLogFileEntry(commitDescriptor, path, ECommitType.values()[commitTypeOrdinal], subType, isDeleted));
        }
        return entries;
    }

    private byte[] serializeEntry(Collection<RepositoryLogFileEntry> values) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)values.size()));
        for (RepositoryLogFileEntry entry : values) {
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(entry.getUniformPath().toString())));
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)entry.commitType.ordinal()));
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)(entry.subType != null ? entry.subType.ordinal() : -1)));
            if (entry.isDeleted()) {
                outputStream.write(1);
                continue;
            }
            outputStream.write(0);
        }
        return outputStream.toByteArray();
    }

    private byte[] serializeKey(CommitDescriptor commit) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(commit.getBranchName())), ByteArrayUtils.longToByteArray((long)commit.getTimestamp())});
    }

    private ListMap<CommitDescriptor, RepositoryLogFileEntry> getEntriesForCommits(List<? extends CommitDescriptor> commits) throws StorageException {
        List serializedCommits = CollectionUtils.mapWithException(commits, this::serializeKey);
        List results = this.store.get(serializedCommits);
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        Map abbreviationMap = abbreviator.buildUnabbreviationMap(RepositoryLogFileIndex.extractAbbreviations(results));
        ListMap result = new ListMap();
        for (int i = 0; i < serializedCommits.size(); ++i) {
            List<RepositoryLogFileEntry> entries = RepositoryLogFileIndex.deserializeEntry((byte[])results.get(i), commits.get(i), abbreviationMap);
            if (entries == null) continue;
            result.addAll((Object)commits.get(i), entries);
        }
        return result;
    }

    public SetMap<CommitDescriptor, String> getCodePathsByCommits(List<? extends CommitDescriptor> commits, String path) throws StorageException {
        return this.getCodePathsByCommits(commits, UniformPathCompatibilityUtil.convert((String)path));
    }

    public SetMap<CommitDescriptor, String> getCodePathsByCommits(List<? extends CommitDescriptor> commits, UniformPath uniformPath) throws StorageException {
        ListMap<CommitDescriptor, RepositoryLogFileEntry> entriesForCommits = this.getEntriesForCommits(commits);
        SetMap result = new SetMap();
        for (Map.Entry entryForCommit : entriesForCommits) {
            for (RepositoryLogFileEntry entry : (List)entryForCommit.getValue()) {
                if (!RepositoryLogFileIndex.isRelevantEntry(uniformPath, entry)) continue;
                result.add((Object)((CommitDescriptor)entryForCommit.getKey()), (Object)entry.getUniformPath().toStringAsMigrationFrontier());
            }
        }
        return result;
    }

    private static boolean isRelevantEntry(UniformPath uniformPath, RepositoryLogFileEntry entry) {
        return uniformPath.hasDescendant(entry.getUniformPath()) && (entry.getCommitType() == ECommitType.CODE_COMMIT || entry.getUniformPath().isNonCodePath() && entry.getCommitType() == ECommitType.EXTERNAL_ANALYSIS);
    }

    public Set<CommitDescriptor> getCommitsWithEntriesAtPaths(List<CommitDescriptor> commits, List<String> pathPrefixes) throws StorageException {
        ListMap<CommitDescriptor, RepositoryLogFileEntry> entriesForCommits = this.getEntriesForCommits(commits);
        HashSet<CommitDescriptor> keysFromStore = new HashSet<CommitDescriptor>();
        for (Map.Entry entryForCommit : entriesForCommits) {
            block1: for (RepositoryLogFileEntry entry : (List)entryForCommit.getValue()) {
                for (String path : pathPrefixes) {
                    if (!entry.getUniformPath().toStringAsMigrationFrontier().startsWith(path)) continue;
                    keysFromStore.add(entry.getCommit());
                    continue block1;
                }
            }
        }
        return keysFromStore;
    }

    public List<RepositoryLogFileEntry> getEntriesByCommit(CommitDescriptor commit) throws StorageException {
        return this.getEntriesByCommits(List.of(commit));
    }

    public List<RepositoryLogFileEntry> getEntriesByDeltaKey(byte[] key, @Nullable CommitDescriptor schedulingCommit) throws StorageException {
        byte[] value = Objects.requireNonNull(this.store.get(key));
        Map abbreviationMap = this.store.getAbbreviator().buildUnabbreviationMap(RepositoryLogFileIndex.extractAbbreviations(List.of(value)));
        return new ArrayList<RepositoryLogFileEntry>(RepositoryLogFileIndex.deserializeEntry(value, schedulingCommit, abbreviationMap));
    }

    public List<RepositoryLogFileEntry> getEntriesByCommitAndEntryTypes(CommitDescriptor commit, EnumSet<UniformPath.EType> types) throws StorageException {
        List<RepositoryLogFileEntry> entries = this.getEntriesByCommit(commit);
        return CollectionUtils.filter(entries, entry -> {
            UniformPath uniformPath = entry.getUniformPath();
            return types.contains(uniformPath.getType());
        });
    }

    public List<RepositoryLogFileEntry> getEntriesByCommits(List<? extends CommitDescriptor> commits) throws StorageException {
        return (List)this.getEntriesForCommits(commits).getValues();
    }

    @VisibleForTesting
    public List<RepositoryLogFileEntry> getEntriesByCommitAndPath(CommitDescriptor commit, UniformPath pathPrefix) throws StorageException {
        ListMap<CommitDescriptor, RepositoryLogFileEntry> entriesForCommits = this.getEntriesForCommits(List.of(commit));
        ArrayList<RepositoryLogFileEntry> result = new ArrayList<RepositoryLogFileEntry>();
        for (Map.Entry entryForCommit : entriesForCommits) {
            for (RepositoryLogFileEntry entry : (List)entryForCommit.getValue()) {
                if (!entry.getUniformPath().hasAncestor(pathPrefix)) continue;
                result.add(entry);
            }
        }
        return result;
    }

    public CommitDescriptor getOldestCommitForPath(List<? extends CommitDescriptor> commits, String path) throws StorageException {
        return (CommitDescriptor)Collections.min(this.getCodePathsByCommits(commits, path).getKeys());
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        List deleteKeys = Collections.synchronizedList(new ArrayList());
        for (Map.Entry<String, Long> entry : timestampByBranch.entrySet()) {
            this.store.scanKeys(this.serializeKey(new CommitDescriptor(entry.getKey(), entry.getValue() + 1L)), this.serializeKey(new CommitDescriptor(entry.getKey(), Long.MAX_VALUE)), (key, value) -> deleteKeys.add(key));
        }
        this.store.remove(deleteKeys);
    }

    @TestOnly
    List<RepositoryLogFileEntry> getAllValues() throws StorageException {
        PairList allEntries = this.store.getEntriesStartingWith(ByteArrayUtils.EMPTY_ARRAY);
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        Map abbreviationMap = abbreviator.buildUnabbreviationMap(RepositoryLogFileIndex.extractAbbreviations(allEntries.extractSecondList()));
        ArrayList<RepositoryLogFileEntry> result = new ArrayList<RepositoryLogFileEntry>();
        for (Pair entry : allEntries) {
            CommitDescriptor commit;
            byte[] key = (byte[])entry.getFirst();
            byte[] value = (byte[])entry.getSecond();
            List<RepositoryLogFileEntry> logEntry = RepositoryLogFileIndex.deserializeEntry(value, commit = new CommitDescriptor(abbreviator.unabbreviate(ByteArrayUtils.readIntFromStartOfArray((byte[])key)), ByteArrayUtils.getLongFromByteArray((byte[])key, (int)4)), abbreviationMap);
            if (logEntry == null) continue;
            result.addAll(logEntry);
        }
        return result;
    }
}

