/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.index.repository.artifact_store.ArchiveIndexBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectionBase;
import com.teamscale.index.repository.artifact_store.EArtifactStoreScanType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ArtifactStoreCommitTreeUpdater<T extends ArchiveIndexBase> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ICommitTree commitTree;
    private final CommitTreeLookup commitTreeLookup;
    private final T externalDataArchiveIndex;
    private final BranchAnalysisStateIndex branchAnalysisStateIndex;
    private final long lowerTimestampBoundaryForChanges;

    public ArtifactStoreCommitTreeUpdater(ICommitTree commitTree, T externalDataArchiveIndex, BranchAnalysisStateIndex branchAnalysisStateIndex, long lowerTimestampBoundaryForChanges) {
        this.externalDataArchiveIndex = externalDataArchiveIndex;
        this.branchAnalysisStateIndex = branchAnalysisStateIndex;
        this.lowerTimestampBoundaryForChanges = lowerTimestampBoundaryForChanges;
        this.commitTree = commitTree;
        this.commitTreeLookup = new CommitTreeLookup(commitTree);
    }

    public Set<ICommitTreeNode> updateCommitTree(ArtifactStoreRepositoryConnectionBase.RemoteExternalDataRevisions remoteRevisions, EArtifactStoreScanType scanType) throws RepositoryException, StorageException {
        HashMap<String, Long> rollbackTimestampByBranch = new HashMap<String, Long>();
        ArrayList<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> revisionsToAdd = new ArrayList<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision>();
        Set<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> revisions = remoteRevisions.getRevisions();
        this.rollbackRemovedRevisionsIfFullScan(scanType, rollbackTimestampByBranch, revisions);
        try {
            for (ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision : ArtifactStoreCommitTreeUpdater.sortByTimestampAscending(revisions)) {
                this.collectUpdatesForRevision(revision, remoteRevisions.getArchivePathsForRevision(revision), scanType, rollbackTimestampByBranch, revisionsToAdd);
            }
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
        if (!rollbackTimestampByBranch.isEmpty()) {
            LOGGER.debug("Requesting rollback to: {}", rollbackTimestampByBranch);
            throw new RepositoryNeedsRollbackException("Revisions have been updated or deleted.", rollbackTimestampByBranch);
        }
        if (revisionsToAdd.isEmpty()) {
            LOGGER.debug("No new revisions to add.");
            return CollectionUtils.emptySet();
        }
        LOGGER.debug("Inserting revisions into commit tree: {}", revisionsToAdd);
        HashSet<ICommitTreeNode> addedNodes = new HashSet<ICommitTreeNode>();
        for (ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision : revisionsToAdd) {
            addedNodes.add(this.addRevisionToCommitTree(revision));
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((ICommitTree)this.commitTree).getCommitTreeDump();
        LOGGER.debug("Commit tree after update:\n{}", supplierArray);
        return addedNodes;
    }

    private void rollbackRemovedRevisionsIfFullScan(EArtifactStoreScanType scanType, Map<String, Long> rollbackTimestampByBranch, Set<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> revisions) throws RepositoryException, StorageException {
        if (scanType == EArtifactStoreScanType.FULL_SCAN) {
            this.rollbackRemovedRevisions(rollbackTimestampByBranch, CollectionUtils.differenceSet(this.commitTreeLookup.getAllRevisions(), (Collection[])new Collection[]{revisions}));
        }
    }

    private static @NonNull ArrayList<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> sortByTimestampAscending(Set<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> revisions) {
        return CollectionUtils.sort(revisions);
    }

    private ICommitTreeNode addRevisionToCommitTree(ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision) {
        return this.commitTree.addNode((CommitTreeRevision)revision, revision.getTimestamp(), ArtifactStoreCommitTreeUpdater.determineParentRevisions(revision, this.commitTree));
    }

    private static ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision createExternalDataRevisionFromNode(ICommitTreeNode node) {
        CommitTreeRevision containedRevision = node.getRevision();
        return new ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision(containedRevision.getRevision(), containedRevision.getBranchName(), node.getOriginalTimestamp());
    }

    private void collectUpdatesForRevision(ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision, Set<String> archivePathsForRevision, EArtifactStoreScanType scanType, Map<String, Long> rollbackTimestampByBranch, List<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> revisionsToAdd) throws RepositoryException, StorageException {
        if (!this.isRevisionIncluded(revision)) {
            return;
        }
        if (this.isKnown(revision)) {
            this.updateExistingRevisionAndAddRollbackIfNeeded(revision, archivePathsForRevision, scanType, rollbackTimestampByBranch);
            return;
        }
        ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision latestNode = this.commitTreeLookup.getLatestNode(revision.getBranchName());
        if (latestNode != null && latestNode.getTimestamp() > revision.getTimestamp()) {
            LOGGER.info("Requesting rollback for revision {} to insert it because later commit tree node {} is present", (Object)revision, (Object)latestNode);
            ArtifactStoreCommitTreeUpdater.insertRollback(rollbackTimestampByBranch, revision);
            return;
        }
        ((ArchiveIndexBase)((Object)this.externalDataArchiveIndex)).updateArchivesForRevision(revision, archivePathsForRevision, scanType);
        revisionsToAdd.add(revision);
    }

    private boolean isKnown(ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision) {
        return this.commitTreeLookup.contains(revision);
    }

    private void updateExistingRevisionAndAddRollbackIfNeeded(ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision, Set<String> archivePathsForRevision, EArtifactStoreScanType scanType, Map<String, Long> rollbackTimestampByBranch) throws StorageException {
        boolean newDataWasAdded = ((ArchiveIndexBase)((Object)this.externalDataArchiveIndex)).updateArchivesForRevision(revision, archivePathsForRevision, scanType);
        if (!newDataWasAdded) {
            return;
        }
        LOGGER.info("Requesting rollback for revision {} because archives changed", (Object)revision);
        ((ArchiveIndexBase)((Object)this.externalDataArchiveIndex)).removeDataForRevision(revision);
        if (ECommitTreeNodeState.isProcessedState((ECommitTreeNodeState)Objects.requireNonNull(this.commitTree.getNodeByRevision((CommitTreeRevision)revision)).getState())) {
            ArtifactStoreCommitTreeUpdater.insertRollback(rollbackTimestampByBranch, revision);
        }
    }

    private void rollbackRemovedRevisions(Map<String, Long> rollbackTimestampByBranch, Set<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> removedRevisions) throws RepositoryException, StorageException {
        ArrayList<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> revisionToRemove = new ArrayList<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision>();
        for (ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision removedRevision : removedRevisions) {
            if (!this.isRevisionIncluded(removedRevision)) continue;
            revisionToRemove.add(removedRevision);
            ((ArchiveIndexBase)((Object)this.externalDataArchiveIndex)).removeDataForRevision(removedRevision);
            ((ArchiveIndexBase)((Object)this.externalDataArchiveIndex)).removeArchivesForRevision(removedRevision);
            ArtifactStoreCommitTreeUpdater.insertRollback(rollbackTimestampByBranch, removedRevision);
        }
        LOGGER.info("Rolling back for removed revisions: {}", revisionToRemove);
    }

    private static void insertRollback(Map<String, Long> rollbackTimestampByBranch, ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision) {
        long knownTimestamp = rollbackTimestampByBranch.getOrDefault(revision.getBranchName(), Long.MAX_VALUE);
        rollbackTimestampByBranch.put(revision.getBranchName(), Math.min(knownTimestamp, revision.getTimestamp() - 1L));
    }

    private static List<CommitTreeRevision> determineParentRevisions(ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision, ICommitTree commitTree) {
        List parentRevisions = Collections.emptyList();
        Optional parentRevision = commitTree.getLatestContainedRevisionForBranch(revision.getBranchName());
        return parentRevision.map(parentRev -> Collections.singletonList(new CommitTreeRevision(parentRev, revision.getBranchName()))).orElse(parentRevisions);
    }

    private boolean isRevisionIncluded(ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision artifactStoreRevision) throws RepositoryException {
        try {
            String branchName = artifactStoreRevision.getBranchName();
            long timestamp = artifactStoreRevision.getTimestamp();
            if (timestamp >= this.lowerTimestampBoundaryForChanges) {
                return true;
            }
            AnalysisState analysisState = this.branchAnalysisStateIndex.getAnalysisState(branchName);
            if (analysisState == null) {
                return true;
            }
            if (analysisState.getTimestamp() > timestamp) {
                LOGGER.debug("Excluding revision {} from update because analysis state at {} has passed revision timestamp", (Object)artifactStoreRevision, (Object)analysisState.getTimestamp());
                return false;
            }
            ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision commitTreeNode = this.commitTreeLookup.getLatestProcessedNode(branchName);
            if (commitTreeNode == null || commitTreeNode.getTimestamp() < timestamp) {
                return true;
            }
            LOGGER.debug("Excluding revision {} from update because later commit tree node {} is already processed", (Object)artifactStoreRevision, (Object)commitTreeNode);
            return false;
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static class CommitTreeLookup {
        private final Set<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> allRevisions;
        private final Map<String, ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> latestRevisionByBranch = new HashMap<String, ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision>();
        private final Map<String, ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> latestProcessedRevisionByBranch = new HashMap<String, ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision>();

        private CommitTreeLookup(ICommitTree commitTree) {
            List allNodes = commitTree.getAllNodes();
            this.allRevisions = new HashSet<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision>(allNodes.size());
            for (ICommitTreeNode node : allNodes) {
                ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision = ArtifactStoreCommitTreeUpdater.createExternalDataRevisionFromNode(node);
                this.allRevisions.add(revision);
                CommitTreeLookup.updateLatestNode(revision, this.latestRevisionByBranch);
                if (!ECommitTreeNodeState.isProcessedState((ECommitTreeNodeState)node.getState())) continue;
                CommitTreeLookup.updateLatestNode(revision, this.latestProcessedRevisionByBranch);
            }
        }

        private static void updateLatestNode(ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision revision, Map<String, ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> latestNodeByBranch) {
            latestNodeByBranch.compute(revision.getBranchName(), (branch, currentLatestNode) -> {
                long originalTimestamp;
                if (currentLatestNode == null) {
                    return revision;
                }
                long currentOriginalTimestamp = currentLatestNode.getTimestamp();
                CCSMAssert.isTrue((currentOriginalTimestamp != (originalTimestamp = revision.getTimestamp()) ? 1 : 0) != 0, (String)"Unexpectedly encountered two commit tree nodes on the same branch with the same timestamp.");
                if (currentOriginalTimestamp > originalTimestamp) {
                    return currentLatestNode;
                }
                return revision;
            });
        }

        private boolean contains(ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision commitTreeRevision) {
            return this.allRevisions.contains(commitTreeRevision);
        }

        private Set<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> getAllRevisions() {
            return CollectionUtils.asUnmodifiable(this.allRevisions);
        }

        private ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision getLatestNode(String branch) {
            return this.latestRevisionByBranch.get(branch);
        }

        private ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision getLatestProcessedNode(String branch) {
            return this.latestProcessedRevisionByBranch.get(branch);
        }
    }
}

