/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.google.common.base.Preconditions;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.artifact_store.ArchiveIndexBase;
import com.teamscale.index.repository.artifact_store.ArtifactIncludeExcludePatterns;
import com.teamscale.index.repository.artifact_store.ArtifactStoreCommitResolutionCacheIndexBase;
import com.teamscale.index.repository.artifact_store.ExtractionFailedException;
import com.teamscale.index.repository.artifact_store.GlobalArchiveContentIndexBase;
import com.teamscale.index.repository.artifact_store.IArtifactStoreTimestampResolver;
import com.teamscale.index.repository.artifact_store.ItemPathInterpretingTimestampResolver;
import com.teamscale.index.repository.artifact_store.PatternBasedItemPathExtractor;
import com.teamscale.index.repository.artifact_store.RevisionFromItemCreationTimestampResolver;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionInterpretationFactory;
import com.teamscale.index.repository.artifact_store.revision_interpretation.IRevisionInterpretation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ArtifactStoreRepositoryInfoBase {
    public static final String FOREIGN_REPOSITORY_IDENTIFIER = "foreign-repository-identifier";
    public static final String FOREIGN_COMMIT_TREE_INDEX_NAME = "foreign-commit-tree";
    public static final String BRANCH_EXTRACTION_PATTERN_PARAMETER = "branch-extraction-pattern";
    public static final String REPOSITORY_EXTRACTION_PATTERN_PARAMETER = "repository-extraction-pattern";
    public static final String TIMESTAMP_EXTRACTION_PATTERN_PARAMETER = "timestamp-extraction-pattern";
    public static final String TIMESTAMP_INTERPRETATION_PARAMETER = "timestamp-interpretation";
    public static final String PREFIX_EXTRACTION_PATTERN_PARAMETER = "prefix-extraction-pattern";
    public static final String IGNORE_EXTRACTION_FAILURES_PARAMETER = "ignore-extraction-failures";
    public static final String IGNORE_CHANGES_OLDER_THAN_DAYS_PARAMETER = "ignore-changes-older-than-days";
    public static final String FILTER_DUPLICATE_ARCHIVES_PER_REVISION = "filter-duplicate-archives-per-revision";
    public static final String REQUIRED_ZIP_FILE_PATTERN = "required-zip-file-pattern";
    @StepParameter(value="branch-extraction-pattern", optional=true)
    private String branchExtractionPattern;
    private PatternBasedItemPathExtractor branchExtractor;
    @StepParameter(value="repository-extraction-pattern", optional=true)
    private String repositoryExtractionPattern;
    private PatternBasedItemPathExtractor repositoryExtractor;
    @StepParameter(value="timestamp-extraction-pattern", optional=true)
    private String timestampExtractionPattern;
    @StepParameter(value="timestamp-interpretation", optional=true)
    private String timestampInterpretation;
    @StepParameter(value="prefix-extraction-pattern", optional=true)
    private String prefixExtractionPattern;
    private PatternBasedItemPathExtractor prefixExtractor;
    @StepParameter(value="ignore-extraction-failures", optional=true)
    private boolean ignoreExtractionFailures;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BranchAnalysisStateIndex branchAnalysisStateIndex;
    @StepParameter(value="filter-duplicate-archives-per-revision", optional=true)
    private boolean filterDuplicateArchivesPerRevision = false;
    @StepParameter(value="required-zip-file-pattern", optional=true)
    private final List<String> requiredZipFilePatterns = new ArrayList<String>();
    @StepParameter(value="ignore-changes-older-than-days", optional=true)
    private Integer ignoreChangesOlderThanDays = null;
    private ExternalCredentials externalCredentials;
    private String pathSuffix;
    private ExternalCredentialsIndex externalCredentialsIndex;
    private ProjectConfiguration projectConfiguration;
    @StepParameter(value="foreign-repository-identifier", optional=true)
    private String foreignRepositoryIdentifier;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="foreign-commit-tree")
    private CommitTreeIndex foreignCommitTreeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private RepositoryRevisionIndex repositoryRevisionIndex;
    private ICommitTree loadedTree;

    protected String getForeignRepositoryIdentifier() {
        return this.foreignRepositoryIdentifier;
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    public void completeInfo(ExternalCredentials externalCredentials, String pathSuffix, ExternalCredentialsIndex externalCredentialsIndex) throws StorageException, ProjectConfigurationException {
        this.externalCredentials = externalCredentials;
        this.externalCredentialsIndex = externalCredentialsIndex;
        this.pathSuffix = StringUtils.nullIfEmpty((String)pathSuffix);
        this.branchExtractionPattern = StringUtils.nullIfEmpty((String)this.branchExtractionPattern);
        this.timestampExtractionPattern = StringUtils.nullIfEmpty((String)this.timestampExtractionPattern);
        this.prefixExtractionPattern = StringUtils.nullIfEmpty((String)this.prefixExtractionPattern);
        this.repositoryExtractionPattern = StringUtils.nullIfEmpty((String)this.repositoryExtractionPattern);
    }

    public ExternalCredentials getExternalCredentials() {
        return this.externalCredentials;
    }

    public boolean hasPathSuffix() {
        return this.pathSuffix != null;
    }

    public String getPathSuffix() {
        return this.pathSuffix;
    }

    public abstract void initializeInMemoryIndexes();

    public String determineBranchName(String fullPath, String defaultBranchName) throws RepositoryException, ExtractionFailedException {
        if (this.branchExtractionPattern == null) {
            return defaultBranchName;
        }
        if (this.branchExtractor == null) {
            this.branchExtractor = PatternBasedItemPathExtractor.create(this.branchExtractionPattern, "branch name");
        }
        return this.branchExtractor.extractFrom(fullPath);
    }

    public Optional<String> determineRepository(String fullPath) throws RepositoryException {
        if (this.repositoryExtractionPattern == null) {
            return Optional.empty();
        }
        if (this.repositoryExtractor == null) {
            this.repositoryExtractor = PatternBasedItemPathExtractor.create(this.repositoryExtractionPattern, "repository name");
        }
        try {
            return Optional.of(this.repositoryExtractor.extractFrom(fullPath));
        }
        catch (ExtractionFailedException e) {
            return Optional.empty();
        }
    }

    public IArtifactStoreTimestampResolver createTimestampResolver() throws RepositoryException {
        if (this.timestampExtractionPattern == null) {
            return new RevisionFromItemCreationTimestampResolver();
        }
        PatternBasedItemPathExtractor revisionExtractor = PatternBasedItemPathExtractor.create(this.timestampExtractionPattern, "timestamp");
        return new ItemPathInterpretingTimestampResolver(revisionExtractor, this.compileRevisionInterpretation(), this.ignoreExtractionFailures);
    }

    public Optional<String> determineFilePrefix(String fullPath) throws RepositoryException {
        if (this.prefixExtractionPattern == null) {
            return Optional.empty();
        }
        if (this.prefixExtractor == null) {
            this.prefixExtractor = PatternBasedItemPathExtractor.create(this.prefixExtractionPattern, "prefix");
        }
        try {
            return Optional.of(this.prefixExtractor.extractFrom(fullPath));
        }
        catch (ExtractionFailedException e) {
            return Optional.empty();
        }
    }

    private IRevisionInterpretation compileRevisionInterpretation() throws RepositoryException {
        Preconditions.checkNotNull((Object)this.timestampExtractionPattern);
        try {
            if (this.loadedTree == null) {
                this.loadForeignCommitTree();
            }
            List<ConnectorConfiguration> connectors = this.getConnectorConfigurations();
            ERepositoryConnector foreignRepositoryConnectorType = null;
            if (this.foreignRepositoryIdentifier != null) {
                foreignRepositoryConnectorType = (ERepositoryConnector)ConnectorUtils.getRepositoryConnectorType(connectors, (String)this.foreignRepositoryIdentifier).orElseThrow(() -> new RepositoryException("Connector with repository identifier " + this.foreignRepositoryIdentifier + " must be a repository connector."));
            }
            ERevisionInterpretationFactory.RevisionInterpretationContext revisionInterpretationContext = new ERevisionInterpretationFactory.RevisionInterpretationContext((IExternalCredentialsProvider)this.externalCredentialsIndex, foreignRepositoryConnectorType, this.foreignRepositoryIdentifier, this.loadedTree, this.getArtifactStoreCommitResolutionCacheIndex(), this.getRepositoryRevisionIndex());
            return ERevisionInterpretationFactory.createFromDescriptor(this.timestampInterpretation, revisionInterpretationContext);
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void loadForeignCommitTree() throws StorageException {
        this.loadedTree = this.foreignCommitTreeIndex.loadTree();
    }

    protected abstract ArtifactStoreCommitResolutionCacheIndexBase getArtifactStoreCommitResolutionCacheIndex();

    protected RepositoryRevisionIndex getRepositoryRevisionIndex() {
        return this.repositoryRevisionIndex;
    }

    protected abstract <T extends ArchiveIndexBase> T getArchiveIndex();

    protected abstract GlobalArchiveContentIndexBase getGlobalArchiveContentIndex();

    private List<ConnectorConfiguration> getConnectorConfigurations() {
        if (this.projectConfiguration == null) {
            return Collections.emptyList();
        }
        return this.projectConfiguration.getConnectors();
    }

    public Optional<Integer> getIgnoreChangesOlderThanDays() {
        return Optional.ofNullable(this.ignoreChangesOlderThanDays);
    }

    public void setBranchExtractionPattern(String branchExtractionPattern) {
        this.branchExtractionPattern = branchExtractionPattern;
    }

    @VisibleForTesting
    public void setRepositoryExtractionPattern(String repositoryExtractionPattern) {
        this.repositoryExtractionPattern = repositoryExtractionPattern;
    }

    public void setTimestampExtractionPattern(String timestampExtractionPattern) {
        this.timestampExtractionPattern = timestampExtractionPattern;
    }

    public void setTimestampInterpretation(String timestampInterpretation) {
        this.timestampInterpretation = timestampInterpretation;
    }

    public String getTimestampInterpretation() {
        return this.timestampInterpretation;
    }

    public String getTimestampExtractionPattern() {
        return this.timestampExtractionPattern;
    }

    public void setPrefixExtractionPattern(String prefixExtractionPattern) {
        this.prefixExtractionPattern = prefixExtractionPattern;
    }

    public void setIgnoreExtractionFailures(boolean ignoreExtractionFailures) {
        this.ignoreExtractionFailures = ignoreExtractionFailures;
    }

    public boolean isFilterDuplicateArchivesPerRevision() {
        return this.filterDuplicateArchivesPerRevision;
    }

    public BranchAnalysisStateIndex getBranchAnalysisStateIndex() {
        return this.branchAnalysisStateIndex;
    }

    public CommitTreeIndex getForeignCommitTreeIndex() {
        return this.foreignCommitTreeIndex;
    }

    public void setForeignCommitTreeIndex(CommitTreeIndex foreignCommitTreeIndex) {
        this.foreignCommitTreeIndex = foreignCommitTreeIndex;
    }

    public String getBranchExtractionPattern() {
        return this.branchExtractionPattern;
    }

    public List<Pattern> getRequiredZipFilePatterns() {
        return CollectionUtils.map(this.requiredZipFilePatterns, Pattern::compile);
    }

    public abstract String getRepositoryOrBucketName();

    public abstract ArtifactIncludeExcludePatterns getKeyIncludeExcludePatterns();

    public abstract void setRepositoryOrBucketName(ConnectorConfiguration var1);

    public abstract void setRepositoryOrBucketName(String var1);

    public abstract void setIncludeAndExcludePatterns(ConnectorConfiguration var1);
}

