/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.index.repository.artifact_store.ExtractionFailedException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.index.shared.RepositoryException;

public class PatternBasedItemPathExtractor {
    private final Pattern extractionPattern;
    private final String extractedItemDescription;

    private PatternBasedItemPathExtractor(Pattern extractionPattern, String extractedItemDescription) {
        this.extractionPattern = extractionPattern;
        this.extractedItemDescription = extractedItemDescription;
    }

    public String extractFrom(String fullPath) throws ExtractionFailedException {
        Matcher matcher = this.extractionPattern.matcher(fullPath);
        if (!matcher.find()) {
            throw new ExtractionFailedException(this.extractedItemDescription, this.extractionPattern, fullPath);
        }
        if (matcher.groupCount() < 1) {
            return matcher.group();
        }
        return matcher.group(1);
    }

    public static PatternBasedItemPathExtractor create(String pattern, String extractedItemDescription) throws RepositoryException {
        try {
            return new PatternBasedItemPathExtractor(Pattern.compile(pattern), extractedItemDescription);
        }
        catch (PatternSyntaxException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

