/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.index.repository.artifact_store.ArchiveIndexBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectionBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.ExtractionFailedException;
import com.teamscale.index.repository.artifact_store.IArtifactStoreTimestampResolver;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import java.io.PrintWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;

class RemoteArtifactStoreRevisionCollector<T extends ArtifactStoreRepositoryInfoBase> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<Duration> UNMATCHED_PATH_RETRY_DELAYS = List.of(Duration.ofSeconds(10L), Duration.ofSeconds(30L), Duration.ofMinutes(2L), Duration.ofMinutes(5L), Duration.ofMinutes(10L), Duration.ofMinutes(30L), Duration.ofHours(1L), Duration.ofHours(2L));
    private final SetMap<CommitDescriptor, String> knownSimpleNamesByCommit = new SetMap();
    private final ArtifactStoreRepositoryConnectionBase.RemoteExternalDataRevisions remoteRevisions = new ArtifactStoreRepositoryConnectionBase.RemoteExternalDataRevisions();
    private final PrintWriter debugWriter;
    private final T repositoryInfo;
    private final IArtifactStoreTimestampResolver timestampResolver;
    private final List<SimpleArtifactStoreClientBase.ItemData> items;
    private final String defaultBranchName;
    private final Predicate<String> isBranchIncluded;

    private RemoteArtifactStoreRevisionCollector(PrintWriter debugWriter, T repositoryInfo, IArtifactStoreTimestampResolver timestampResolver, List<SimpleArtifactStoreClientBase.ItemData> items, String defaultBranchName, Predicate<String> isBranchIncluded) {
        this.debugWriter = debugWriter;
        this.repositoryInfo = repositoryInfo;
        this.timestampResolver = timestampResolver;
        this.items = items;
        this.defaultBranchName = defaultBranchName;
        this.isBranchIncluded = isBranchIncluded;
    }

    public static <T extends ArtifactStoreRepositoryInfoBase> ArtifactStoreRepositoryConnectionBase.RemoteExternalDataRevisions collectRevisions(PrintWriter debugWriter, T repositoryInfo, IArtifactStoreTimestampResolver timestampResolver, List<SimpleArtifactStoreClientBase.ItemData> items, String defaultBranchName, Predicate<String> isBranchIncluded) throws RepositoryException, RescheduleRequestedException {
        return new RemoteArtifactStoreRevisionCollector<T>(debugWriter, repositoryInfo, timestampResolver, items, defaultBranchName, isBranchIncluded).collect();
    }

    private ArtifactStoreRepositoryConnectionBase.RemoteExternalDataRevisions collect() throws RepositoryException, RescheduleRequestedException {
        List itemsNewestFirst = CollectionUtils.sort(this.items, Comparator.comparingLong(SimpleArtifactStoreClientBase.ItemData::getCreationTimestamp).reversed());
        ArrayList<String> unmatchedPaths = new ArrayList<String>();
        for (SimpleArtifactStoreClientBase.ItemData item : itemsNewestFirst) {
            this.resolveRevision(item).ifPresentOrElse(revision -> this.insertRevision(item.getFullPath(), (ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision)revision, item.getContentLength()), () -> unmatchedPaths.add(item.getFullPath()));
        }
        if (!unmatchedPaths.isEmpty()) {
            this.handleUnmatchedPaths(this.items, this.remoteRevisions, unmatchedPaths);
        }
        return this.remoteRevisions;
    }

    private Optional<ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision> resolveRevision(SimpleArtifactStoreClientBase.ItemData item) throws RepositoryException {
        String fullPath = item.getFullPath();
        if (!this.pathSuffixMatches(fullPath)) {
            return Optional.empty();
        }
        if (!this.foreignRepositoryIdentifierMatches(fullPath)) {
            return Optional.empty();
        }
        Optional<Pair<String, CommitDescriptor>> revisionAndTimestamp = this.resolveTimestamp(fullPath, item, this.getBranchName(fullPath).orElse(null));
        if (revisionAndTimestamp.isEmpty()) {
            return Optional.empty();
        }
        CommitDescriptor commit = (CommitDescriptor)revisionAndTimestamp.get().getSecond();
        if (this.isDuplicateInRevision(fullPath, item, commit, this.knownSimpleNamesByCommit)) {
            return Optional.empty();
        }
        String revision = (String)revisionAndTimestamp.get().getFirst();
        return Optional.of(new ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision(revision, commit));
    }

    private void insertRevision(String fullPath, ArtifactStoreRepositoryConnectionBase.ArtifactStoreRevision artifactStoreRevision, long contentLength) {
        this.remoteRevisions.insertRevisionAndPath(artifactStoreRevision, fullPath, contentLength);
        LOGGER.debug("Full path '{}' was inserted as {}@{}/{}", (Object)fullPath, (Object)artifactStoreRevision.getTimestamp(), (Object)artifactStoreRevision.getBranchName(), (Object)artifactStoreRevision.getRevision());
        this.debugWriter.println(fullPath + " -> inserted as " + artifactStoreRevision.getTimestamp() + "@" + artifactStoreRevision.getBranchName() + "/" + artifactStoreRevision.getRevision());
    }

    private void handleUnmatchedPaths(List<SimpleArtifactStoreClientBase.ItemData> items, ArtifactStoreRepositoryConnectionBase.RemoteExternalDataRevisions remoteRevisions, List<String> unmatchedPaths) throws RescheduleRequestedException {
        Object archiveIndex = ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getArchiveIndex();
        LOGGER.info("Unable to match paths: {}", new Supplier[]{() -> StringUtils.truncateWithThreeDots((String)String.join((CharSequence)", ", unmatchedPaths), (int)2000)});
        try {
            if (this.timestampResolver.mayRequireReschedule() && !items.isEmpty() && remoteRevisions.getRevisions().isEmpty()) {
                int retryCount = ((ArchiveIndexBase)((Object)archiveIndex)).registerUnmatchedPaths(unmatchedPaths);
                if (retryCount > UNMATCHED_PATH_RETRY_DELAYS.size()) {
                    LOGGER.warn("Exceeded maximum number of retry attempts to match paths. The change retriever will no longer be re-scheduled proactively to pick these up. If the information required to match the paths should appear at a later point (e.g., by integrating additional code repository revisions), then the paths will still be matched at that time (potentially resulting in a rollback).");
                    return;
                }
                Instant earliestNextScheduleInstant = DateTimeUtils.now().plus(UNMATCHED_PATH_RETRY_DELAYS.get(retryCount - 1));
                throw new RescheduleRequestedException("Failed to resolve revisions. This may happen shortly after project import and should be resolved on the next run.", earliestNextScheduleInstant);
            }
        }
        catch (StorageException e) {
            LOGGER.warn("Failed to register unmatched paths", (Throwable)e);
        }
    }

    private boolean isDuplicateInRevision(String fullPath, SimpleArtifactStoreClientBase.ItemData item, CommitDescriptor commit, SetMap<CommitDescriptor, String> knownSimpleNamesByCommit) throws RepositoryException {
        if (((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).isFilterDuplicateArchivesPerRevision() && !knownSimpleNamesByCommit.add((Object)commit, (Object)this.determineNameForDuplicationFiltering(item))) {
            LOGGER.debug("Full path '{}' was discarded due to newer archive for {}/{}", (Object)fullPath, (Object)commit, (Object)this.determineNameForDuplicationFiltering(item));
            this.debugWriter.println(fullPath + " -> discarded due to newer archive for " + String.valueOf(commit) + "/" + this.determineNameForDuplicationFiltering(item));
            return true;
        }
        return false;
    }

    private Optional<Pair<String, CommitDescriptor>> resolveTimestamp(String fullPath, SimpleArtifactStoreClientBase.ItemData item, @Nullable String branchName) throws RepositoryException {
        Optional<Pair<String, CommitDescriptor>> revisionAndTimestamp = this.timestampResolver.resolveRevisionAndTimestamp(item, branchName);
        if (revisionAndTimestamp.isEmpty()) {
            LOGGER.debug("Full path '{}' -> failed to extract revision and timestamp using resolver '{}'.", (Object)fullPath, (Object)this.timestampResolver.getClass().getSimpleName());
            this.debugWriter.println(fullPath + " -> failed to extract revision and timestamp");
        }
        return revisionAndTimestamp;
    }

    private boolean foreignRepositoryIdentifierMatches(String fullPath) throws RepositoryException {
        Optional<String> repository = ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).determineRepository(fullPath);
        if (repository.isEmpty() || repository.get().equals(((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getForeignRepositoryIdentifier())) {
            return true;
        }
        LOGGER.debug("Full path '{}' -> repository identifier {} did not match repository identifier for revision interpretation {}.", (Object)fullPath, (Object)repository.get(), (Object)((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getForeignRepositoryIdentifier());
        this.debugWriter.println(fullPath + " -> repository identifier did not match, hence ignored");
        return false;
    }

    private boolean pathSuffixMatches(String fullPath) {
        if (!((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).hasPathSuffix() || fullPath.endsWith(((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getPathSuffix())) {
            return true;
        }
        LOGGER.debug("Full path '{}' did not match configured path suffix {}, hence ignored", (Object)fullPath, (Object)((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getPathSuffix());
        this.debugWriter.println(fullPath + " -> path suffix did not match, hence ignored");
        return false;
    }

    private String determineNameForDuplicationFiltering(SimpleArtifactStoreClientBase.ItemData item) throws RepositoryException {
        return ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).determineFilePrefix(item.getFullPath()).orElse("#NONE#") + ":" + item.name;
    }

    private Optional<String> getBranchName(String fullPath) throws RepositoryException {
        String branchName;
        try {
            branchName = ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).determineBranchName(fullPath, this.defaultBranchName);
        }
        catch (ExtractionFailedException e) {
            LOGGER.atDebug().withThrowable((Throwable)e).log("Failed to determine branch for {}. Continuing without branch.", (Object)fullPath);
            return Optional.empty();
        }
        if (!this.isBranchIncluded.test(branchName)) {
            LOGGER.debug("Failed to determine branch for {}: Branch name {} is not included.", (Object)fullPath, (Object)branchName);
            return Optional.empty();
        }
        return Optional.of(branchName);
    }
}

