/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.index.repository.artifact_store.revision_interpretation.BranchNameDependentRevisionInterpretationBase;
import com.teamscale.index.repository.git.GitUtils;
import java.net.URISyntaxException;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.EGitProtocol;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.net.UrlUtils;
import org.eclipse.jgit.lib.Repository;

public final class GitRevisionInterpretation
extends BranchNameDependentRevisionInterpretationBase {
    private final Repository repository;

    public GitRevisionInterpretation(ExternalCredentials credentials) throws RepositoryException {
        if (GitUtils.getProtocolFromUrl(credentials.uri) != EGitProtocol.FILE) {
            throw new RepositoryException("Only local (file url) git repositories supported for timestamp lookup!");
        }
        try {
            this.repository = GitUtils.getExistingLocalRepository(UrlUtils.parseUri((String)credentials.uri));
        }
        catch (URISyntaxException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    protected Optional<CommitDescriptor> interpretRevisionWithBranchName(String revision, @NonNull String branchName) {
        return GitUtils.getTimestampFromRevision(this.repository, revision).map(timestamp -> new CommitDescriptor(branchName, timestamp.longValue()));
    }

    @Override
    public void close() {
        this.repository.close();
    }
}

