/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.core.stream.IStreamSource;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public abstract class RepositoryConnectionBase
implements IRepositoryConnection {
    public static final String TEAMSCALE_COMMIT_AUTHOR = "Teamscale";
    protected final RepositoryConnectorBaseParameterStep baseParameters;

    protected RepositoryConnectionBase(RepositoryConnectorBaseParameterStep baseParameters) {
        this.baseParameters = baseParameters;
        CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)baseParameters.getConnectionIdentifier()), (String)"connection identifier must not be empty");
        CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)baseParameters.getDefaultBranchName()), (String)"default branch name must not be empty");
    }

    @Override
    public boolean isIncluded(String path) {
        return this.getCodePatternSupport().isIncluded(path);
    }

    @Override
    public boolean isTestCode(String path) {
        return !this.getTestCodePatternSupport().getIncludePatterns().isEmpty() && this.getTestCodePatternSupport().isIncluded(path);
    }

    @Override
    public final CommitTreeExpansionResult expandCommitTree(ICommitTree commitTree) throws RepositoryException, RescheduleRequestedException {
        CommitTreeExpansionResult expansionResult = this.expandCommitTreeNodes(commitTree);
        if (expansionResult.performedActualWork) {
            this.updateLiveBranches(commitTree);
        }
        return expansionResult;
    }

    protected boolean isCommitTreeExpansionNeeded() throws RepositoryException {
        return true;
    }

    protected abstract CommitTreeExpansionResult expandCommitTreeNodes(ICommitTree var1) throws RepositoryException, RescheduleRequestedException;

    protected void updateLiveBranches(ICommitTree commitTree) throws RepositoryException {
        commitTree.setLiveBranchNames((Collection)commitTree.getAllNodes().stream().map(node -> node.getRevision().getBranchName()).collect(Collectors.toSet()));
    }

    protected Instant getInstantForStartDateOrRevision(String dateOrRevision, long defaultValue) throws RepositoryException {
        return this.getInstant(dateOrRevision, defaultValue, ConnectorUtils::getTimestampForDate);
    }

    protected Instant getInstantForEndDateOrRevision(String dateOrRevision) throws RepositoryException {
        return this.getInstant(dateOrRevision, Long.MAX_VALUE, ConnectorUtils::getTimestampForEndDate);
    }

    private Instant getInstant(String dateOrRevision, long defaultValue, Function<String, Optional<Long>> dateToTimestampConverter) throws RepositoryException {
        if (StringUtils.isEmpty((String)dateOrRevision)) {
            return Instant.ofEpochMilli(defaultValue);
        }
        Optional<Long> optionalDate = dateToTimestampConverter.apply(dateOrRevision);
        if (optionalDate.isPresent()) {
            return Instant.ofEpochMilli(optionalDate.get());
        }
        return Instant.ofEpochMilli(this.convertRevisionToTimestamp(dateOrRevision).orElse(defaultValue));
    }

    protected Optional<Long> convertRevisionToTimestamp(String revision) throws RepositoryException {
        return Optional.empty();
    }

    @Override
    public String getConnectionIdentifier() {
        return this.baseParameters.getConnectionIdentifier();
    }

    @Override
    public void close() throws RepositoryException {
    }

    @Override
    public IStreamWithException<byte[], RepositoryException> getContent(List<String> paths, CommitTreeRevision revision) throws RepositoryException {
        return IStreamWithException.of((IStreamSource)IStreamSource.ofIterable(paths, RepositoryException.class)).map(path -> this.getContent((String)path, revision));
    }

    protected byte[] getContent(String path, CommitTreeRevision revision) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefaultBranchName() {
        return this.baseParameters.getDefaultBranchName();
    }

    public boolean isBranchNameIncludedOrDefaultBranch(String branchName) {
        boolean isDefaultBranch = Objects.equals(this.getDefaultBranchName(), branchName);
        if (!this.isBranchingEnabled()) {
            return isDefaultBranch;
        }
        if (isDefaultBranch) {
            return !this.getBranchPatternSupport().isExplicitlyExcluded(branchName);
        }
        return this.isBranchNameIncluded(branchName);
    }

    protected boolean isBranchNameIncluded(String branchName) {
        return this.getBranchPatternSupport().isIncluded(branchName);
    }

    @Override
    public boolean shouldInheritForkInformation() {
        return false;
    }

    public @Nullable String getStartDateOrRevision() throws RepositoryException {
        return this.baseParameters.getStartDateOrRevision();
    }

    public @Nullable String getEndDateOrRevision() throws RepositoryException {
        return this.baseParameters.getEndDateOrRevision();
    }

    public boolean isBranchingEnabled() {
        return this.baseParameters.isBranchingEnabled();
    }

    protected IncludeExcludeAntPatternSupport getCodePatternSupport() {
        return this.baseParameters.getCodePatternSupport();
    }

    protected IncludeExcludeAntPatternSupport getTestCodePatternSupport() {
        return this.baseParameters.getTestCodePatternSupport();
    }

    protected IncludeExcludeRegexSupport getBranchPatternSupport() {
        return this.baseParameters.getBranchPatternSupport();
    }

    @Override
    public int getPollingIntervalSeconds() {
        return this.baseParameters.pollingIntervalSeconds;
    }
}

