/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.repository.git.GitBranchRetriever;
import com.teamscale.index.repository.git.GitPreviewUtils;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import com.teamscale.index.repository.retrievers.ICommitMessagesRetriever;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.Pair;

public abstract class AppBasedGitRepositoryDataRetriever<Installation>
implements IFilesRetriever,
IBranchRetriever,
ICommitMessagesRetriever {
    private final @NonNull ServerOptionIndex serverOptionIndex;
    private final @NonNull AccessTokenIndex accessTokenIndex;
    private final @Nullable ProjectConfiguration projectConfiguration;
    private final @NonNull ConnectorConfiguration connectorConfiguration;
    private final @NonNull String username;
    private Installation installation;
    private URI repositoryUri;

    protected AppBasedGitRepositoryDataRetriever(@NonNull ServerOptionIndex serverOptionIndex, @NonNull AccessTokenIndex accessTokenIndex, @Nullable ProjectConfiguration projectConfiguration, @NonNull ConnectorConfiguration connectorConfiguration, @NonNull String username) {
        this.serverOptionIndex = serverOptionIndex;
        this.accessTokenIndex = accessTokenIndex;
        this.projectConfiguration = projectConfiguration;
        this.connectorConfiguration = connectorConfiguration;
        this.username = username;
    }

    protected @NonNull ServerOptionIndex getServerOptionIndex() {
        return this.serverOptionIndex;
    }

    protected @NonNull AccessTokenIndex getAccessTokenIndex() {
        return this.accessTokenIndex;
    }

    @Override
    public Set<String> fetchBranches(boolean projectExists, String username, @Nullable ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        this.initializeAndCheckAccessRights(projectExists, username, connectorConfiguration);
        Pair<String, String> usernameAndPassword = this.getConnectorUsernameAndPassword();
        return GitBranchRetriever.getGitBranches(this.repositoryUri, (String)usernameAndPassword.getFirst(), (String)usernameAndPassword.getSecond());
    }

    @Override
    public @NonNull Collection<@NonNull String> fetchFiles() throws RepositoryException, ProjectConfigurationException {
        this.initializeAndCheckAccessRights(this.projectConfiguration != null, this.username, this.connectorConfiguration);
        return GitPreviewUtils.retrieveFilesFromGit(this.repositoryUri, this.connectorConfiguration, this.serverOptionIndex, this.createExternalCredentials(this.repositoryUri), false);
    }

    @Override
    public List<String> fetchCommitMessages(String branchName, boolean projectExists, String username, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        this.initializeAndCheckAccessRights(projectExists, username, connectorConfiguration);
        return GitPreviewUtils.retrieveCommitMessagesFromGit(branchName, this.repositoryUri, connectorConfiguration, this.serverOptionIndex, this.createExternalCredentials(this.repositoryUri), false);
    }

    protected Installation getInstallation() {
        return this.installation;
    }

    private void initializeAndCheckAccessRights(boolean projectExists, String username, ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException, RepositoryException {
        String repositoryName = MergeRequestAnnotationTriggerBase.getRepositoryName(connectorConfiguration);
        this.installation = this.init(repositoryName, connectorConfiguration);
        if (!projectExists) {
            this.checkUserIsCollaborator(username, repositoryName);
        }
        this.repositoryUri = this.getRepositoryUri(repositoryName, connectorConfiguration);
    }

    protected abstract Installation init(String var1, ConnectorConfiguration var2) throws RepositoryException, ProjectConfigurationException;

    protected abstract void checkUserIsCollaborator(String var1, String var2) throws ProjectConfigurationException, RepositoryException;

    protected abstract URI getRepositoryUri(String var1, ConnectorConfiguration var2) throws ProjectConfigurationException, RepositoryException;

    protected abstract Pair<String, String> getConnectorUsernameAndPassword() throws RepositoryException;

    protected abstract ExternalCredentials createExternalCredentials(URI var1) throws RepositoryException;
}

