/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud;

import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.writer.JsonSmartJwtJsonBuilder;
import com.atlassian.jwt.core.writer.NimbusJwtWriterFactory;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.JWTAccessToken;
import com.teamscale.index.repository.git.bitbucket.cloud.client.IBitbucketCloudApi;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudRepository;
import java.time.Duration;
import java.util.Calendar;
import okhttp3.MultipartBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;

public class BitbucketCloudUtils {
    public static final String BITBUCKET_ADD_ON_KEY = "teamscale-bitbucket-app";
    public static final String WEBHOOK_API_ENDPOINT = "api/bitbucket-cloud/app";
    private static final String SEPARATOR = "#:#";
    private static final String ACCESS_TOKEN_KEY_PREFIX = "bitbucket-installation-access-token:";
    private static final String BITBUCKET_URL = "https://bitbucket.org";
    private static final Logger LOGGER = LogManager.getLogger();

    public static String getInstallationToken(AccessTokenIndex accessTokenIndex, BitbucketCloudInstallationIndex.BitbucketInstallation installation) throws ServiceCallException, StorageException {
        return accessTokenIndex.getOrCreateToken(ACCESS_TOKEN_KEY_PREFIX + installation.getInstallationUsername() + SEPARATOR + installation.getClientKey(), Duration.ofMinutes(30L), () -> BitbucketCloudUtils.requestAccessToken(installation));
    }

    public static void removeInstallationToken(AccessTokenIndex accessTokenIndex, String username, String installationClientKey) throws StorageException {
        accessTokenIndex.removeToken(ACCESS_TOKEN_KEY_PREFIX + username + SEPARATOR + installationClientKey);
    }

    private static AccessTokenIndex.AccessToken requestAccessToken(BitbucketCloudInstallationIndex.BitbucketInstallation installation) throws ServiceCallException {
        String jwtToken;
        try {
            jwtToken = BitbucketCloudUtils.generateJwtTokenFromInstallation(installation);
        }
        catch (RepositoryException e) {
            throw new ServiceCallException("Could not generate JWT token for access token request", (Throwable)e);
        }
        IBitbucketCloudApi bitbucketCloud = (IBitbucketCloudApi)Retrofit.builder((String)BITBUCKET_URL).withJWTAuthentication(jwtToken).withInteractionLogger(LOGGER).create(IBitbucketCloudApi.class);
        JWTAccessToken accessToken = bitbucketCloud.getJwtAccessToken(MultipartBody.Part.createFormData((String)"grant_type", (String)"urn:bitbucket:oauth2:jwt"));
        Calendar currentCalendar = Calendar.getInstance();
        currentCalendar.add(13, accessToken.getExpiresIn());
        return new AccessTokenIndex.AccessToken(accessToken.getAccessToken(), currentCalendar.getTime().toInstant());
    }

    private static String generateJwtTokenFromInstallation(BitbucketCloudInstallationIndex.BitbucketInstallation installation) throws RepositoryException {
        if (installation.getSharedSecret() == null) {
            throw new RepositoryException("Missing shared secret in this Bitbucket Cloud installation");
        }
        JwtJsonBuilder jwtBuilder = new JsonSmartJwtJsonBuilder().issuer(BITBUCKET_ADD_ON_KEY).subject(installation.getClientKey());
        NimbusJwtWriterFactory jwtWriterFactory = new NimbusJwtWriterFactory();
        return jwtWriterFactory.macSigningWriter(SigningAlgorithm.HS256, installation.getSharedSecret()).jsonToJwt(jwtBuilder.build());
    }

    public static Pair<String, BitbucketCloudInstallationIndex.BitbucketInstallation> deserializeAccountIdentifier(String accountIdentifier) throws RepositoryException {
        String[] appInstallationInfo = accountIdentifier.split(SEPARATOR);
        if (appInstallationInfo.length != 4) {
            throw new RepositoryException("Insufficient information available in the app info [" + accountIdentifier + "] to create a connection with the Bitbucket server.");
        }
        BitbucketCloudInstallationIndex.BitbucketInstallation installation = new BitbucketCloudInstallationIndex.BitbucketInstallation(appInstallationInfo[1], appInstallationInfo[2], appInstallationInfo[3]);
        return new Pair((Object)appInstallationInfo[0], (Object)installation);
    }

    public static String serializeAccountIdentifier(String url, BitbucketCloudInstallationIndex.BitbucketInstallation installation) {
        return url + SEPARATOR + installation.getInstallationUsername() + SEPARATOR + installation.getClientKey() + SEPARATOR + installation.getSharedSecret();
    }

    public static String getUrlSafeFullRepositoryName(String fullRepositoryName) {
        return fullRepositoryName.replace("{", "%7B").replace("}", "%7D");
    }

    public static String getHttpCloneUrlFromResponse(BitbucketCloudRepository repository) throws ConnectorValidationException {
        return repository.getHttpCloneUrl().orElseThrow(() -> new ConnectorValidationException("Missing clone URL in response!"));
    }
}

