/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.google.common.base.Preconditions;
import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.testcoverage.LineCoverageChange;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.LineCoverageVotingInfo;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.common.TestGapVotingInfo;
import com.teamscale.index.repository.git.common.TestingIntegrationRequirementsChecker;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.github.ECheckRunType;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.GitHubMergeRequestProvider;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.CheckRunBuilder;
import com.teamscale.index.repository.git.github.data.GitHubBuildJob;
import com.teamscale.index.repository.git.github.data.GitHubChangedFile;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.github.data.GitHubPullRequestComment;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunIndex;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

public class GitHubMergeRequestAnnotationTrigger
extends MergeRequestAnnotationTriggerBase<GitHubPullRequest, GitHubBuildJob> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TEXT_FIELD_LIMIT = 64000;
    private static final int ANNOTATIONS_LIMIT = 50;
    private static final String AND_MORE_SUFFIX = "\nand more ...";
    private GitHubPullRequestClient client;
    private CheckRunBuilder findingsCheckRunBuilder;
    private CheckRunBuilder testGapsCheckRunBuilder;
    private CheckRunBuilder testCoverageCheckRunBuilder;
    private CheckRun.CheckRunAnnotation[] findingsAnnotations;
    private CheckRun.CheckRunAnnotation[] testGapAnnotations;
    private PlatformRepositoryIdentifier repositoryIdentifier;
    private GitHubCheckRunIndex checkRunIndex;

    public GitHubMergeRequestAnnotationTrigger() {
    }

    @TestOnly
    protected GitHubMergeRequestAnnotationTrigger(GitHubPullRequestClient client, PlatformRepositoryIdentifier repositoryIdentifier, GitHubCheckRunIndex checkRunIndex) {
        this.client = client;
        this.repositoryIdentifier = repositoryIdentifier;
        this.checkRunIndex = checkRunIndex;
    }

    @Override
    protected MergeRequestProvider<GitHubPullRequest, GitHubBuildJob> createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        GlobalStorageSystem globalStorage = this.indexLayer.openGlobalStorageSystem();
        String repositoryName = GitHubMergeRequestAnnotationTrigger.getRepositoryName(schedulingParameters.connector());
        this.repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName(repositoryName);
        String githubServerUrl = schedulingParameters.connector().getOptionValue("GitHub Server URL");
        GitHubAppBasedRepositoryAccessHelper<StorageException> repositoryAccessHelper = new GitHubAppBasedRepositoryAccessHelper<StorageException>(githubServerUrl, repositoryName, (GitHubInstallationIndex)globalStorage.openGlobalIndex(GitHubInstallationIndex.class), this.serverOptionIndex, (AccessTokenIndex)globalStorage.openGlobalIndex(AccessTokenIndex.class), StorageException::new, LOGGER);
        try {
            this.client = repositoryAccessHelper.createGitHubPullRequestClient();
        }
        catch (ServiceCallException e) {
            throw new StorageException("Could not create GitHub pull request client: " + e.getMessage(), (Throwable)e);
        }
        return new GitHubMergeRequestProvider(repositoryName, this.client, VotingConnectorUtils.getBuildIncludeExcludePatterns(schedulingParameters.connector()), GitHubMergeRequestAnnotationTrigger.getContextIdentifier(schedulingParameters.connector()));
    }

    @Override
    protected void handleVotingException(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequest mergeRequest, VotingException votingException) {
        LOGGER.debug("Cleaning up findings check run");
        this.postSkippedCheckRun(ECheckRunType.FINDINGS, this.findingsCheckRunBuilder, schedulingParameters.schedulingCommit(), votingException);
        LOGGER.debug("Cleaning up test gaps check run");
        this.postSkippedCheckRun(ECheckRunType.TEST_GAPS, this.testGapsCheckRunBuilder, schedulingParameters.schedulingCommit(), votingException);
        LOGGER.debug("Cleaning up test coverage check run");
        this.postSkippedCheckRun(ECheckRunType.TEST_COVERAGE, this.testCoverageCheckRunBuilder, schedulingParameters.schedulingCommit(), votingException);
    }

    private void postSkippedCheckRun(ECheckRunType type, CheckRunBuilder checkRunBuilder, CommitDescriptor schedulingCommit, VotingException votingException) {
        if (checkRunBuilder == null) {
            if (votingException instanceof VotingException.Skipped) {
                VotingException.Skipped skippedException = (VotingException.Skipped)votingException;
                LOGGER.debug(LoggingUtils.INTERACTION, "No clean up required: Skip happened before check run was initialized, indicating that skipping reason '{}' is not reported to the CCP.", (Object)skippedException.getReason(), (Object)skippedException);
            } else if (votingException instanceof VotingException.Error) {
                VotingException.Error errorException = (VotingException.Error)votingException;
                LOGGER.error(LoggingUtils.INTERACTION, "Clean up can not proceed, because a non-recoverable error happened before check run was initialized.", (Throwable)errorException);
            } else {
                LOGGER.error(LoggingUtils.INTERACTION, "Clean up can not proceed, because an unexpected exception occurred before the check run builder was initialized.", (Throwable)votingException);
            }
            return;
        }
        CheckRun currentCheckRun = checkRunBuilder.build();
        if (currentCheckRun.id() == null || currentCheckRun.status() != CheckRun.Status.IN_PROGRESS) {
            LOGGER.debug(LoggingUtils.INTERACTION, "No clean up required: No existing check run with status '{}' found.", (Object)CheckRun.Status.IN_PROGRESS.name(), (Object)votingException);
            return;
        }
        if (votingException instanceof VotingException.Skipped) {
            checkRunBuilder.withConclusion(CheckRun.Conclusion.SKIPPED);
        } else if (votingException instanceof VotingException.Error) {
            checkRunBuilder.withConclusion(CheckRun.Conclusion.FAILURE);
        } else {
            LOGGER.warn(LoggingUtils.INTERACTION, "Check run is still in progress but voting exception '{}' does not inform us about a conclusion. Concluding with '{}'.", (Object)votingException.getMessage(), (Object)CheckRun.Conclusion.FAILURE.name(), (Object)votingException);
            checkRunBuilder.withConclusion(CheckRun.Conclusion.FAILURE);
        }
        checkRunBuilder.withOutputTitle(votingException.getMessage());
        try {
            this.sendCheckRun(type, schedulingCommit, checkRunBuilder, null);
        }
        catch (ServiceCallException | ExecutionCanceledException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = currentCheckRun::id;
            LOGGER.atError().withThrowable(e).log("Concluding check run {} failed.", supplierArray);
        }
    }

    @Override
    protected VotingRecord.EVotingState performVoting(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        this.prepareCheckRuns(schedulingParams, input);
        VotingRecord.EVotingState state = super.performVoting(schedulingParams, input);
        this.verifyNotCanceled();
        this.sendCheckRuns(schedulingParams.schedulingCommit(), schedulingParams.connector());
        return state;
    }

    private void prepareCheckRuns(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException {
        GitHubCheckRunIndex checkRunIndex = this.openCheckRunIndex();
        String contextIdentifier = GitHubMergeRequestAnnotationTrigger.getContextIdentifier(schedulingParams.connector());
        this.findingsCheckRunBuilder = GitHubMergeRequestAnnotationTrigger.initCheckRun(ECheckRunType.FINDINGS, contextIdentifier, input, schedulingParams, checkRunIndex);
        this.testGapsCheckRunBuilder = GitHubMergeRequestAnnotationTrigger.initCheckRun(ECheckRunType.TEST_GAPS, contextIdentifier, input, schedulingParams, checkRunIndex);
        this.testCoverageCheckRunBuilder = GitHubMergeRequestAnnotationTrigger.initCheckRun(ECheckRunType.TEST_COVERAGE, contextIdentifier, input, schedulingParams, checkRunIndex);
    }

    private static CheckRunBuilder initCheckRun(ECheckRunType type, String contextIdentifier, MergeRequestAnnotationInput input, CommitVotingTriggerBase.SchedulingParameters schedulingParams, GitHubCheckRunIndex checkRunIndex) throws StorageException {
        CheckRunBuilder checkRunBuilder = CheckRun.builder(type, contextIdentifier, input.mergeRequest.sourceHead, input.createMergeRequestDetailsLink(schedulingParams.linkProvider())).withConclusion(CheckRun.Conclusion.NEUTRAL);
        checkRunIndex.readId(schedulingParams.schedulingCommit(), type).ifPresent(checkRunBuilder::withId);
        return checkRunBuilder;
    }

    private GitHubCheckRunIndex openCheckRunIndex() throws StorageException {
        if (this.checkRunIndex == null) {
            this.checkRunIndex = (GitHubCheckRunIndex)this.openIndexInProject(GitHubCheckRunIndex.class);
        }
        return this.checkRunIndex;
    }

    @Override
    protected void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String badgeAsMarkdown) {
        this.findingsCheckRunBuilder.withMarkdownBadge(badgeAsMarkdown);
        this.testGapsCheckRunBuilder.withMarkdownBadge(input.buildTestGapBadgeAsMarkdown((TeamscaleProjectLinkProvider)schedulingParams.linkProvider(), this.appendSizeValuesToMarkdownImage()));
    }

    @Override
    protected VotingRecord.EVotingState addFindingsVote(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException {
        return this.createCommitStatusForFindings(schedulingParams, input);
    }

    private VotingRecord.EVotingState createCommitStatusForFindings(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
        if (!CcpIntegrationFeatureEnablements.isVotingForFindingsEnabled(schedulingParams.connector())) {
            return VotingRecord.EVotingState.VOTED;
        }
        List<TrackedFinding> addedFindings = input.getAddedFindings();
        this.findingsCheckRunBuilder.withOutputText(GitHubMergeRequestAnnotationTrigger.createCheckRunOutputDetailsForFindings(addedFindings, schedulingParams.linkProvider(), input.ignoreYellowFindingsForVotes));
        this.findingsCheckRunBuilder.withOutputTitle(GitHubMergeRequestAnnotationTrigger.createVoteOutputSummaryForFindings(addedFindings, input.ignoreYellowFindingsForVotes));
        if (input.getAddedFindingsForVoting().isEmpty()) {
            this.findingsCheckRunBuilder.withConclusion(CheckRun.Conclusion.SUCCESS);
            return VotingRecord.EVotingState.VOTED_POSITIVE;
        }
        this.findingsCheckRunBuilder.withConclusion(CheckRun.Conclusion.ACTION_REQUIRED);
        return VotingRecord.EVotingState.VOTED_NEGATIVE;
    }

    @Override
    protected VotingRecord.EVotingState addTestGapsVote(TestGapVotingInfo testGapVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
        TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult = testGapVotingInfo.votingRequirementsCheckerResult();
        if (!votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return GitHubMergeRequestAnnotationTrigger.setStatusForUnfulfilledRequirements(this.testGapsCheckRunBuilder, votingRequirementsCheckerResult);
        }
        this.testGapsCheckRunBuilder.withOutputText(GitHubMergeRequestAnnotationTrigger.createCheckRunOutputDetailsForTestGaps(testGapVotingInfo.untestedMethods(), schedulingParams.linkProvider(), input.mergeRequest.identifier));
        this.testGapsCheckRunBuilder.withOutputTitle(testGapVotingInfo.toReadableDescription());
        if (testGapVotingInfo.numberOfTestGaps() > 0) {
            this.testGapsCheckRunBuilder.withConclusion(CheckRun.Conclusion.ACTION_REQUIRED);
            return VotingRecord.EVotingState.VOTED_NEGATIVE;
        }
        this.testGapsCheckRunBuilder.withConclusion(CheckRun.Conclusion.SUCCESS);
        return VotingRecord.EVotingState.VOTED_POSITIVE;
    }

    @Override
    protected VotingRecord.EVotingState addTestCoverageVote(LineCoverageVotingInfo coverageVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
        TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult = coverageVotingInfo.votingRequirementsCheckerResult();
        if (!votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return GitHubMergeRequestAnnotationTrigger.setStatusForUnfulfilledRequirements(this.testCoverageCheckRunBuilder, votingRequirementsCheckerResult);
        }
        this.testCoverageCheckRunBuilder.withOutputText(GitHubMergeRequestAnnotationTrigger.createCheckRunOutputDetailsForTestCoverage(coverageVotingInfo.lineCoverageChangesPerFile(), input.mergeRequest.identifier.toString(), schedulingParams.linkProvider()));
        this.testCoverageCheckRunBuilder.withOutputTitle(coverageVotingInfo.toReadableDescription());
        if (!coverageVotingInfo.isCoverageAboveThreshold()) {
            this.testCoverageCheckRunBuilder.withConclusion(CheckRun.Conclusion.ACTION_REQUIRED);
            return VotingRecord.EVotingState.VOTED_NEGATIVE;
        }
        this.testCoverageCheckRunBuilder.withConclusion(CheckRun.Conclusion.SUCCESS);
        return VotingRecord.EVotingState.VOTED_POSITIVE;
    }

    private static VotingRecord.EVotingState setStatusForUnfulfilledRequirements(CheckRunBuilder checkRunBuilder, TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult) {
        checkRunBuilder.withOutputTitle(votingRequirementsCheckerResult.getFailureReason());
        if (votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.BUILD_INCOMPLETE || votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.WAITING_EXTERNAL_UPLOADS) {
            checkRunBuilder.setInProgress();
        }
        if (votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.BUILD_INCOMPLETE) {
            return VotingRecord.EVotingState.VOTED_INCOMPLETE_BUILD;
        }
        return VotingRecord.EVotingState.VOTED;
    }

    private static String createCheckRunOutputDetailsForFindings(List<TrackedFinding> addedFindings, TeamscaleCommitLinkProvider linkProvider, boolean ignoreYellowFindingsForVoting) {
        StringBuilder builder = new StringBuilder();
        if (addedFindings.isEmpty()) {
            builder.append("There are no finding details to show.");
            return builder.toString();
        }
        if (!ignoreYellowFindingsForVoting) {
            GitHubMergeRequestAnnotationTrigger.addFindingsToCheckRunOutputDetails(builder, "**Findings**\n", addedFindings, linkProvider);
        } else {
            List<TrackedFinding> redFindings = addedFindings.stream().filter(finding -> finding.getAssessment() == ETrafficLightColor.RED).toList();
            List<TrackedFinding> otherFindings = addedFindings.stream().filter(finding -> finding.getAssessment() != ETrafficLightColor.RED).toList();
            if (!redFindings.isEmpty()) {
                GitHubMergeRequestAnnotationTrigger.addFindingsToCheckRunOutputDetails(builder, "**Critical findings to be fixed before merging**\n", redFindings, linkProvider);
            }
            if (!otherFindings.isEmpty()) {
                if (!redFindings.isEmpty()) {
                    builder.append("\n");
                }
                GitHubMergeRequestAnnotationTrigger.addFindingsToCheckRunOutputDetails(builder, "**Non-critical findings that may be fixed after merging**\n", otherFindings, linkProvider);
            }
        }
        Preconditions.checkState((builder.length() <= 64000 ? 1 : 0) != 0, (Object)"Details text is longer than text field limit.");
        return builder.toString();
    }

    private static void addFindingsToCheckRunOutputDetails(StringBuilder builder, String title, List<TrackedFinding> findings, TeamscaleCommitLinkProvider linkProvider) {
        if (builder.length() + title.length() > 64000 - AND_MORE_SUFFIX.length()) {
            builder.append(AND_MORE_SUFFIX);
            return;
        }
        builder.append(title);
        for (TrackedFinding finding : findings) {
            String nextLine = "* %s#%s: %s [(view in Teamscale)](%s)\n".formatted(finding.getLocation().getUniformPath(), GitHubMergeRequestAnnotationTrigger.getTextRegion(finding.getLocation()).startLine(), finding.getMessage(), linkProvider.createFindingsDetailLink(finding.getId()));
            if (builder.length() + nextLine.length() > 64000 - AND_MORE_SUFFIX.length()) {
                builder.append(AND_MORE_SUFFIX);
                break;
            }
            builder.append(nextLine);
        }
    }

    private static String createVoteOutputSummaryForFindings(List<TrackedFinding> addedFindings, boolean ignoreYellowFindingsForVoting) {
        if (addedFindings.isEmpty()) {
            return "No new findings";
        }
        if (!ignoreYellowFindingsForVoting) {
            return addedFindings.size() + " new " + StringUtils.pluralize((String)"finding", (int)addedFindings.size()) + ".";
        }
        int redFindingsCount = addedFindings.stream().filter(finding -> finding.getAssessment() == ETrafficLightColor.RED).toList().size();
        int otherFindingsCount = addedFindings.stream().filter(finding -> finding.getAssessment() != ETrafficLightColor.RED).toList().size();
        StringBuilder builder = new StringBuilder();
        if (redFindingsCount == 0) {
            builder.append("No");
        } else {
            builder.append(redFindingsCount);
        }
        builder.append(StringUtils.pluralize((String)" new critical finding", (int)redFindingsCount));
        if (otherFindingsCount > 0) {
            builder.append(" and ").append(otherFindingsCount).append(StringUtils.pluralize((String)" other new finding", (int)otherFindingsCount));
        }
        return builder.toString();
    }

    private static String createCheckRunOutputDetailsForTestGaps(List<AssessedTgaData.AssessedMethodData> untestedMethods, TeamscaleCommitLinkProvider linkProvider, MergeRequestIdentifier mergeRequestIdentifier) {
        StringBuilder builder = new StringBuilder();
        if (untestedMethods.isEmpty()) {
            builder.append("There are no test gap details to show.");
            return builder.toString();
        }
        String nextLine = "**Test Gaps**\n";
        builder.append(nextLine);
        for (AssessedTgaData.AssessedMethodData method : untestedMethods) {
            nextLine = "* %s: Untested %s method `%s` [(view in Teamscale)](%s)\n".formatted(method.getLocation().getUniformPath(), GitHubMergeRequestAnnotationTrigger.getTestGapStateText(method.getTestGapState()), method.getMethodName(), linkProvider.createMergeRequestTestGapDetailsLink(method.getLocation().getUniformPath(), method.getLocation().getRegion().getStart(), method.getLocation().getRegion().getEnd(), mergeRequestIdentifier));
            if (builder.length() + nextLine.length() > 64000 - AND_MORE_SUFFIX.length()) {
                builder.append(AND_MORE_SUFFIX);
                break;
            }
            builder.append(nextLine);
        }
        Preconditions.checkState((builder.length() <= 64000 ? 1 : 0) != 0, (Object)"Details text is longer than text field limit.");
        return builder.toString();
    }

    private static String createCheckRunOutputDetailsForTestCoverage(List<LineCoverageChange> lineCoveragePerFile, String mergeRequestId, TeamscaleCommitLinkProvider linkProvider) {
        StringBuilder builder = new StringBuilder();
        if (lineCoveragePerFile.isEmpty()) {
            builder.append("There are no test coverage details to show.");
            return builder.toString();
        }
        String nextLine = "**Test Coverage per File**\n";
        builder.append(nextLine);
        for (LineCoverageChange lineCoverageChange : lineCoveragePerFile) {
            nextLine = "* %s: %.2f%% [(view in Teamscale)](%s)\n".formatted(lineCoverageChange.uniformPath(), lineCoverageChange.coverageOfChanges() * 100.0, linkProvider.createMergeRequestTestCoverageDetailsLink(mergeRequestId, lineCoverageChange.uniformPath(), lineCoverageChange.originPath()));
            if (builder.length() + nextLine.length() > 64000 - AND_MORE_SUFFIX.length()) {
                builder.append(AND_MORE_SUFFIX);
                break;
            }
            builder.append(nextLine);
        }
        Preconditions.checkState((builder.length() <= 64000 ? 1 : 0) != 0, (Object)"Details text is longer than text field limit.");
        return builder.toString();
    }

    @Override
    protected void addInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism mechanism) {
        List<IReviewComment> filteredReviewComments = this.filterReviewComments(input, reviewComments);
        Map<Boolean, List<CheckRun.CheckRunAnnotation>> findingsAndTestGapAnnotations = GitHubMergeRequestAnnotationTrigger.createAnnotations(filteredReviewComments).stream().collect(Collectors.partitioningBy(annotation -> annotation.message().startsWith("[Test Gap] ")));
        this.findingsAnnotations = (CheckRun.CheckRunAnnotation[])CollectionUtils.toArray((Collection)findingsAndTestGapAnnotations.get(false), CheckRun.CheckRunAnnotation.class);
        GitHubMergeRequestAnnotationTrigger.addAnnotationsToCheckRun(this.findingsCheckRunBuilder, this.findingsAnnotations);
        this.testGapAnnotations = (CheckRun.CheckRunAnnotation[])CollectionUtils.toArray((Collection)findingsAndTestGapAnnotations.get(true), CheckRun.CheckRunAnnotation.class);
        GitHubMergeRequestAnnotationTrigger.addAnnotationsToCheckRun(this.testGapsCheckRunBuilder, this.testGapAnnotations);
    }

    private static void addAnnotationsToCheckRun(CheckRunBuilder checkRunBuilder, CheckRun.CheckRunAnnotation[] annotations) {
        CheckRun.CheckRunAnnotation[] annotationsBatch = Arrays.copyOfRange(annotations, 0, Math.min(50, annotations.length));
        checkRunBuilder.withAnnotations(annotationsBatch);
    }

    @Override
    protected void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        List<GitHubPullRequestComment> allComments = this.client.getPullRequestComments(this.repositoryIdentifier, (int)input.mergeRequest.getId());
        List aggregatedTeamscaleComments = CollectionUtils.filter(allComments, c -> CcpCommentUtils.isTeamscaleTestGapSummaryComment(c.body()));
        for (GitHubPullRequestComment comment : aggregatedTeamscaleComments) {
            this.client.deletePullRequestComment(this.repositoryIdentifier, comment.id());
        }
    }

    @Override
    protected void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, long pullRequestId, String commentContent) throws IOException, ServiceCallException {
        this.client.createPullRequestComment(this.repositoryIdentifier, (int)pullRequestId, new GitHubPullRequestComment(commentContent, null));
    }

    private static List<CheckRun.CheckRunAnnotation> createAnnotations(List<IReviewComment> reviewComments) {
        ArrayList<CheckRun.CheckRunAnnotation> annotations = new ArrayList<CheckRun.CheckRunAnnotation>();
        for (IReviewComment reviewComment : reviewComments) {
            ElementLocation location = reviewComment.getLocation();
            Object commentContent = reviewComment.getText();
            if (((String)commentContent).length() > 64000) {
                commentContent = ((String)commentContent).substring(0, 64000 - "\u2026".length()) + "\u2026";
            }
            annotations.add(GitHubMergeRequestAnnotationTrigger.createAnnotation(reviewComment, location, (String)commentContent));
        }
        return annotations;
    }

    private static CheckRun.CheckRunAnnotation createAnnotation(IReviewComment reviewComment, ElementLocation location, String commentContent) {
        CheckRun.CheckRunAnnotation.Level annotationLevel = switch (reviewComment.getAssessment()) {
            case ETrafficLightColor.RED -> CheckRun.CheckRunAnnotation.Level.FAILURE;
            case ETrafficLightColor.YELLOW -> CheckRun.CheckRunAnnotation.Level.WARNING;
            default -> throw new IllegalStateException("Can't create a check run annotation from assessment " + String.valueOf(reviewComment.getAssessment()) + ".");
        };
        TextRegion startAndEndLine = GitHubMergeRequestAnnotationTrigger.getTextRegion(location);
        return new CheckRun.CheckRunAnnotation(location.getUniformPath(), startAndEndLine.startLine(), startAndEndLine.endLine(), annotationLevel, commentContent);
    }

    @Override
    protected void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String commentLimitWarningExceededMessage, String commentLimitWarningFormat) {
        if (commentLimitWarningFormat.equals("There are %s test gaps. This number exceeds the set limit for test gaps to be shown as individual comments. Please navigate to [Teamscale](%s) instead for more test gap details.")) {
            this.testGapsCheckRunBuilder.withCommentLimitExceededWarning(commentLimitWarningExceededMessage);
        } else {
            this.findingsCheckRunBuilder.withCommentLimitExceededWarning(commentLimitWarningExceededMessage);
        }
    }

    private void sendCheckRuns(CommitDescriptor commit, ConnectorConfiguration connector) throws ExecutionCanceledException, ServiceCallException {
        this.sendCheckRun(ECheckRunType.FINDINGS, commit, this.findingsCheckRunBuilder, this.findingsAnnotations);
        this.findingsAnnotations = null;
        if (CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(connector)) {
            this.sendCheckRun(ECheckRunType.TEST_GAPS, commit, this.testGapsCheckRunBuilder, this.testGapAnnotations);
        }
        this.testGapAnnotations = null;
        if (CcpIntegrationFeatureEnablements.isVotingForTestCoverageEnabled(connector)) {
            this.sendCheckRun(ECheckRunType.TEST_COVERAGE, commit, this.testCoverageCheckRunBuilder, null);
        }
    }

    private void sendCheckRun(ECheckRunType type, CommitDescriptor commit, CheckRunBuilder checkRunBuilder, CheckRun.CheckRunAnnotation[] annotations) throws ExecutionCanceledException, ServiceCallException {
        CheckRun checkRun = checkRunBuilder.build();
        LOGGER.debug(LoggingUtils.INTERACTION, "Sending check run '{}'.", (Object)checkRun);
        Long createdCheckRunId = this.callCheckRunCreationService(checkRun);
        if (annotations != null && annotations.length > 50) {
            this.patchRemainingAnnotations(createdCheckRunId, checkRunBuilder, annotations);
        }
        try {
            this.openCheckRunIndex().storeId(commit, type, createdCheckRunId);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to store created check run with id '{}'.", (Object)createdCheckRunId);
        }
    }

    protected EnumSet<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration connector) {
        return EnumSet.of(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.PLATFORM_SPECIFIC);
    }

    @Override
    protected void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ExecutionCanceledException {
    }

    @Override
    protected void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException, ExecutionCanceledException {
    }

    private List<IReviewComment> filterReviewComments(MergeRequestAnnotationInput input, List<IReviewComment> reviewComments) {
        try {
            List<GitHubChangedFile> pullRequestFiles = this.client.getPullRequestFiles(this.repositoryIdentifier, (int)input.mergeRequest.getId());
            Set pullRequestFileNames = CollectionUtils.mapToSet(pullRequestFiles, GitHubChangedFile::fileName);
            return CollectionUtils.filter(reviewComments, comment -> pullRequestFileNames.contains(comment.getLocation().getUniformPath()));
        }
        catch (ServiceCallException e) {
            LOGGER.error("Fetching the pull request files and filtering the comments to be annotated failed: " + e.getMessage(), (Throwable)e);
            return new ArrayList<IReviewComment>();
        }
    }

    protected static String getContextIdentifier(ConnectorConfiguration connector) {
        String contextIdentifier = connector.getOptionValue("Context identifier");
        return GitHubRepositoryConnectorDescriptor.computeContextIdentifier(contextIdentifier);
    }

    private void patchRemainingAnnotations(Long checkRunId, CheckRunBuilder checkRunBuilder, CheckRun.CheckRunAnnotation[] annotations) throws ExecutionCanceledException {
        int startIndex = 50;
        while (startIndex < annotations.length) {
            this.verifyNotCanceled();
            int endIndex = Math.min(startIndex + 50, annotations.length);
            CheckRun.CheckRunAnnotation[] nextAnnotationsBatch = Arrays.copyOfRange(annotations, startIndex, endIndex);
            checkRunBuilder.withAnnotations(nextAnnotationsBatch);
            this.callCheckRunUpdateService(checkRunBuilder.build(), checkRunId);
            startIndex = endIndex;
        }
    }

    private Long callCheckRunCreationService(CheckRun checkRun) throws ServiceCallException {
        try {
            return this.client.createCheckRun(this.repositoryIdentifier, checkRun);
        }
        catch (ServiceCallException e) {
            throw new ServiceCallException((Throwable)e);
        }
    }

    private void callCheckRunUpdateService(CheckRun updatedCheckRun, Long checkRunId) {
        try {
            this.client.updateCheckRun(this.repositoryIdentifier, checkRunId, updatedCheckRun);
        }
        catch (ServiceCallException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Updating the annotations failed: {}", (Object)e.getMessage());
        }
    }

    @Override
    protected boolean shouldAddFindingsVoteOnMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams) {
        return true;
    }

    @Override
    protected boolean shouldIncludeTestGapBadge() {
        return false;
    }

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.GITHUB;
    }

    private static TextRegion getTextRegion(ElementLocation location) {
        if (location instanceof TextRegionLocation) {
            TextRegionLocation textRegionLocation = (TextRegionLocation)location;
            return new TextRegion(textRegionLocation.getRawStartLine(), textRegionLocation.getRawEndLine());
        }
        return new TextRegion(1, 1);
    }

    private static String getTestGapStateText(ETestGapState state) {
        return switch (state) {
            case ETestGapState.UNTESTED_ADDITION -> "added";
            case ETestGapState.UNTESTED_CHANGE -> "changed";
            default -> "";
        };
    }

    private record TextRegion(int startLine, int endLine) {
    }
}

