/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.conqat.lib.commons.string.StringUtils;

public class ScmManagerCiStatus {

    public static class CiStatus {
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="type")
        private final String type;
        @JsonProperty(value="displayName")
        private final String displayName;
        @JsonProperty(value="status")
        private final String status;
        @JsonProperty(value="url")
        private final String url;

        @JsonCreator
        public CiStatus(String name, String type, String url, int findingsCount) {
            this.name = name;
            this.type = type;
            this.url = url;
            if (findingsCount == 0) {
                this.status = "SUCCESS";
                this.displayName = "No new findings";
            } else {
                this.status = "FAILURE";
                Object description = "This pull request would add " + findingsCount + " new finding";
                this.displayName = description = StringUtils.pluralize((String)description, (int)findingsCount);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getStatus() {
            return this.status;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

