/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.svn.SVNUtils;
import com.teamscale.index.repository.svn.SvnChangeEntry;
import com.teamscale.index.repository.svn.SvnExternalTarget;
import com.teamscale.index.repository.svn.SvnLogCacheIndex;
import com.teamscale.index.repository.svn.SvnLogQueue;
import com.teamscale.index.repository.svn.SvnRepositoryViewBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.predicate.IPredicateWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class PlainSvnRepositoryView
extends SvnRepositoryViewBase {
    private final String repositoryRoot;

    public PlainSvnRepositoryView(SVNRepository repository, IPredicateWithException<String, RepositoryException> isPathIncluded, Predicate<String> canSubPathsBeIncluded, Function<String, Optional<String>> branchNameExtractor, SvnLogCacheIndex logCacheIndex, String branchesDirectory) throws RepositoryException {
        super(repository, isPathIncluded, canSubPathsBeIncluded, branchNameExtractor, logCacheIndex, branchesDirectory);
        try {
            this.repositoryRoot = SVNUtils.determineRepositoryRoot(this.mainRepository, true).toDecodedString();
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public List<SvnChangeEntry> getNextLogEntries(long nextScanTimestamp, long startTimestamp, int maximumChunkSize) throws RepositoryException {
        String repositorySuffix = StringUtils.stripPrefix((String)this.mainRepository.getLocation().toDecodedString(), (String)this.repositoryRoot);
        List<SvnExternalTarget> externalTargets = Collections.singletonList(new SvnExternalTarget("", this.repositoryRoot, repositorySuffix, 0L));
        long timestamp = Math.max(nextScanTimestamp, startTimestamp) - 1L;
        SvnLogQueue logQueue = new SvnLogQueue("##single-root##", this.getOrCreateRepository(this.repositoryRoot), externalTargets, Collections.emptyList(), this.logCacheIndex, timestamp, null, this.repositoryExecutor, (IPredicateWithException<String, RepositoryException>)this.isPathIncluded, this.canSubPathsBeIncluded, this.branchNameExtractor, this.branchesDirectory);
        ArrayList<SvnChangeEntry> result = new ArrayList<SvnChangeEntry>();
        for (int i = 0; i < maximumChunkSize && !logQueue.isEmpty(); ++i) {
            result.add(logQueue.pollEntry());
        }
        return result;
    }

    @Override
    public Map<String, Long> getHeadTimestamp(List<String> paths) throws RepositoryException {
        SVNWCClient wcClient = this.clientManager.getWCClient();
        try {
            HashMap<String, Long> result = new HashMap<String, Long>();
            for (String path : paths) {
                result.put(path, this.getTimestampForPath(wcClient, path));
            }
            return result;
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private long getTimestampForPath(SVNWCClient wcClient, String path) throws SVNException {
        try {
            SVNInfo entry = wcClient.doInfo(this.mainRepository.getLocation().appendPath(path, false), SVNRevision.HEAD, SVNRevision.HEAD);
            return entry.getCommittedDate().getTime();
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_ILLEGAL_URL) {
                return -1L;
            }
            throw e;
        }
    }

    @Override
    public SvnChangeEntry getLogEntry(String revision) throws RepositoryException {
        try {
            return this.logCacheIndex.getRepositoryLog("##single-root##", Long.parseLong(revision));
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public Set<String> crawl(String path, String revision) throws RepositoryException {
        try {
            return PlainSvnRepositoryView.crawl(this.mainRepository, path, Long.parseLong(revision), this.repositoryExecutor, (IPredicateWithException<String, RepositoryException>)this.isPathIncluded, this.canSubPathsBeIncluded);
        }
        catch (NumberFormatException | SVNException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    protected SvnRepositoryViewBase.BinaryContentAccessor getBinaryContentAccessor(String path, String revision) {
        return new SvnRepositoryViewBase.BinaryContentAccessor(this, this.mainRepository, path, Long.parseLong(revision));
    }

    @Override
    public String resolveMainRepositoryRevision(long revision) {
        return Long.toString(revision);
    }
}

