/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeInfo;
import com.teamscale.index.repository.svn.SvnExternalTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@IndexValueClass
public class SvnChangeEntry
implements Serializable,
Comparable<SvnChangeEntry> {
    public static final String SINGLE_REPOSITORY_ROOT_NAME = "##single-root##";
    private static final long serialVersionUID = 1L;
    private final long revision;
    private final long timestamp;
    private final String repositoryRoot;
    private final String author;
    private final String message;
    private final PairList<String, RepositoryChangeInfo> affectedPaths = new PairList();
    private final Set<String> branchNames = new HashSet<String>();
    private final Set<String> clearedExternalPaths = new HashSet<String>();
    private final List<SvnExternalTarget> addedExternalTargets = new ArrayList<SvnExternalTarget>();
    private final Set<String> rootRepoModifiedDirectories = new HashSet<String>();

    public SvnChangeEntry(long revision, String repositoryRoot, long timestamp, String author, String message) {
        this.revision = revision;
        this.repositoryRoot = repositoryRoot;
        this.timestamp = timestamp;
        this.author = author;
        this.message = message;
    }

    public List<String> getPaths() {
        return this.affectedPaths.extractFirstList();
    }

    public long getRevision() {
        return this.revision;
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public String getAuthor() {
        return this.author;
    }

    public PairList<String, RepositoryChangeInfo> getAffectedPaths() {
        return this.affectedPaths;
    }

    public void addChange(String entryPath, ERepositoryChangeType changeType, @Nullable String originPath, @Nullable CommitDescriptor originCommit) {
        UniformPath parsedPath = Optional.ofNullable(originPath).map(UniformPathCompatibilityUtil::convert).orElse(null);
        this.affectedPaths.add((Object)entryPath, (Object)new RepositoryChangeInfo(parsedPath, originCommit, changeType));
    }

    public Set<String> getClearedExternalPaths() {
        return this.clearedExternalPaths;
    }

    public void addClearedExternalPath(String workingCopyPath) {
        this.clearedExternalPaths.add(workingCopyPath);
    }

    public List<SvnExternalTarget> getAddedExternalTargets() {
        return this.addedExternalTargets;
    }

    public void addAddedExternalTarget(SvnExternalTarget target) {
        this.clearedExternalPaths.remove(target.getLocalPath());
        this.addedExternalTargets.add(target);
    }

    public Set<String> getRootRepoModifiedDirectories() {
        return this.rootRepoModifiedDirectories;
    }

    public void addRootRepoModifiedDirectory(String directory) {
        this.rootRepoModifiedDirectories.add(directory);
    }

    public String getCompositeRevision() {
        if (SINGLE_REPOSITORY_ROOT_NAME.equals(this.repositoryRoot)) {
            return Long.toString(this.revision);
        }
        return SvnChangeEntry.createCompositeRevision(this.revision, this.repositoryRoot);
    }

    public static String createCompositeRevision(long revision, String repositoryRoot) {
        return revision + "@" + repositoryRoot;
    }

    public static Pair<Long, String> parseCompositeRevision(String compositeRevision) {
        String[] parts = compositeRevision.split("@", 2);
        if (parts.length < 2) {
            return new Pair((Object)Long.parseLong(parts[0]), (Object)SINGLE_REPOSITORY_ROOT_NAME);
        }
        return new Pair((Object)Long.parseLong(parts[0]), (Object)parts[1]);
    }

    public void addBranchName(String branchName) {
        this.branchNames.add(branchName);
    }

    public Set<String> getBranchNames() {
        return this.branchNames;
    }

    @Override
    public int compareTo(SvnChangeEntry other) {
        return Long.compare(this.revision, other.revision);
    }

    public String toString() {
        return "SvnChangeEntry [revision=" + this.revision + ", timestamp=" + this.timestamp + ", repositoryRoot=" + this.repositoryRoot + ", author=" + this.author + ", message=" + this.message + ", affectedPaths=" + String.valueOf(this.affectedPaths) + ", clearedExternalPaths=" + String.valueOf(this.clearedExternalPaths) + ", addedExternalTargets=" + String.valueOf(this.addedExternalTargets) + "]";
    }
}

