/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.svn.SVNUtils;
import com.teamscale.index.repository.svn.SvnExternalTarget;
import com.teamscale.index.repository.svn.SvnQueryTaskBase;
import com.teamscale.index.repository.svn.SvnRepositoryExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.predicate.IPredicateWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;

class SvnCrawlHelper
extends SvnQueryTaskBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IPredicateWithException<String, RepositoryException> isPathIncluded;
    private final Predicate<String> canSubPathsBeIncluded;
    final Set<String> paths = Collections.synchronizedSet(new HashSet());

    public SvnCrawlHelper(SVNRepository repository, long revision, SvnRepositoryExecutor repositoryExecutor, IPredicateWithException<String, RepositoryException> isPathIncluded, Predicate<String> canSubPathsBeIncluded) {
        super(repository, revision, repositoryExecutor);
        this.isPathIncluded = isPathIncluded;
        this.canSubPathsBeIncluded = canSubPathsBeIncluded;
    }

    public void crawl(String basePath) {
        String trimmedBasePath = SvnExternalTarget.trimSlashes(basePath);
        this.futures.add(this.repositoryExecutor.submit(repository -> this.crawlTask((SVNRepository)repository, trimmedBasePath), this.repository));
    }

    private Void crawlTask(SVNRepository repository, String basePath) throws SVNException {
        SVNUtils.runWithRetry(() -> this.crawlTaskInternal(repository, basePath), e -> LOGGER.warn("Had error during crawl in " + basePath + " at revision " + this.revision + " in " + repository.getLocation().toDecodedString() + ": " + e.getMessage() + ". Performing retry!", (Throwable)e), (ConsumerWithException<SVNException, SVNException>)((ConsumerWithException)e -> LOGGER.error("Had fatal error during crawl in " + basePath + " at revision " + this.revision + " in " + repository.getLocation().toDecodedString() + ": " + e.getMessage(), (Throwable)e)));
        return null;
    }

    private void crawlTaskInternal(SVNRepository repository, String basePath) throws SVNException {
        ArrayList entries = new ArrayList();
        repository.getDir(basePath, this.revision, null, 1, entries);
        for (SVNDirEntry entry : entries) {
            Object path = entry.getName();
            if (!StringUtils.isEmpty((String)basePath)) {
                path = basePath + "/" + (String)path;
            }
            if (entry.getKind() == SVNNodeKind.DIR && this.canSubPathsBeIncluded.test((String)path)) {
                this.crawl((String)path);
                continue;
            }
            if (entry.getKind() != SVNNodeKind.FILE) continue;
            this.crawlFileEntry(entry, repository);
        }
    }

    private void crawlFileEntry(SVNDirEntry entry, SVNRepository repository) throws SVNException {
        String relativePath = entry.getURL().toDecodedString().substring(SVNUtils.getSVNRepositoryLocation(repository).length());
        String svnBasePath = StringUtils.stripPrefix((String)SVNUtils.getSVNRepositoryLocation(repository), (String)(SVNUtils.determineRepositoryRoot(repository, false).toDecodedString() + "/"));
        relativePath = StringUtils.stripPrefix((String)relativePath, (String)svnBasePath);
        try {
            if (this.isPathIncluded.test((Object)relativePath)) {
                this.paths.add(relativePath);
            }
        }
        catch (RepositoryException e) {
            throw new SVNException(SVNErrorMessage.UNKNOWN_ERROR_MESSAGE, (Throwable)e);
        }
    }
}

