/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.util;

import com.polarion.alm.ws.client.types.Text;
import com.polarion.alm.ws.client.types.planning.Plan;
import com.polarion.alm.ws.client.types.projects.User;
import com.polarion.alm.ws.client.types.tracker.Category;
import com.polarion.alm.ws.client.types.tracker.Custom;
import com.polarion.alm.ws.client.types.tracker.EnumOptionId;
import com.polarion.alm.ws.client.types.tracker.LinkedWorkItem;
import com.polarion.alm.ws.client.types.tracker.Module;
import com.polarion.alm.ws.client.types.tracker.WorkItem;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionExternalElementCache;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemLinkRole;
import com.teamscale.wia.ExternalToolIssueCustomField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.string.StringUtils;

public class PolarionWorkItemFieldResolvingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String WORK_ITEM_ID_SEPARATOR = "${WorkItem}";
    private static final String DOCUMENT_ID_SEPARATOR = "#";
    private static final String REVISION_SEPARATOR = "%";
    private static final String MODULE_FOLDER_PREFIX = "{moduleFolder}";

    public static List<String> resolveWorkItemAssignees(WorkItem item) {
        User[] assignees = item.getAssignee();
        ArrayList<String> usernames = new ArrayList<String>();
        if (assignees != null && assignees.length > 0) {
            usernames.addAll(Arrays.stream(assignees).map(User::getId).collect(Collectors.toList()));
        }
        return usernames;
    }

    public static List<String> resolveWorkItemComponents(WorkItem item) {
        Category[] categories = item.getCategories();
        ArrayList<String> components = new ArrayList<String>();
        if (categories != null) {
            components.addAll(Arrays.stream(categories).map(Category::getName).collect(Collectors.toList()));
        }
        return components;
    }

    public static String resolveWorkItemDescription(WorkItem item) {
        Text description = item.getDescription();
        String teamscaleDescription = "";
        if (description != null) {
            teamscaleDescription = description.getContent();
        }
        return teamscaleDescription;
    }

    public static List<String> getWorkItemParentIds(List<String> includedLinkRoles, List<List<String>> includedWorkItems) {
        List<String> ids;
        ArrayList<String> parentIds = new ArrayList<String>();
        int index = includedLinkRoles.indexOf("has parent");
        if (index != -1 && (ids = includedWorkItems.get(index)) != null && !ids.isEmpty()) {
            parentIds.addAll(ids);
        }
        return parentIds;
    }

    public static List<List<String>> resolveLinkedWorkItems(WorkItem item, Collection<PolarionWorkItemLinkRole> includedWorkItemLinkRoles) {
        ArrayList<List<String>> linkedSpecItems = new ArrayList<List<String>>();
        LinkedWorkItem[] linkedWorkItems = item.getLinkedWorkItems();
        LinkedWorkItem[] linkedWorkItemsDerived = item.getLinkedWorkItemsDerived();
        for (PolarionWorkItemLinkRole workItemLinkRole : includedWorkItemLinkRoles) {
            if (workItemLinkRole.getName() != null) {
                linkedSpecItems.add(PolarionWorkItemFieldResolvingUtils.getIncludedWorkItemIds(workItemLinkRole, linkedWorkItems));
            }
            if (workItemLinkRole.getOppositeName() == null) continue;
            linkedSpecItems.add(PolarionWorkItemFieldResolvingUtils.getIncludedWorkItemIds(workItemLinkRole, linkedWorkItemsDerived));
        }
        return linkedSpecItems;
    }

    private static List<String> getIncludedWorkItemIds(PolarionWorkItemLinkRole workItemLinkRole, LinkedWorkItem[] linkedWorkItems) {
        if (linkedWorkItems == null || linkedWorkItems.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        List includedLinkedWorkItems = Arrays.stream(linkedWorkItems).filter(workItem -> workItem.getRole() != null && workItem.getRole().getId().equals(workItemLinkRole.getId())).collect(Collectors.toList());
        if (!includedLinkedWorkItems.isEmpty()) {
            for (LinkedWorkItem includedLinkedWorkItem : includedLinkedWorkItems) {
                String linkedWorkItemUri = includedLinkedWorkItem.getWorkItemURI();
                String linkedWorkItemIdFront = StringUtils.getLastPart((String)linkedWorkItemUri, (String)WORK_ITEM_ID_SEPARATOR);
                int revIndex = linkedWorkItemIdFront.indexOf(REVISION_SEPARATOR);
                if (revIndex != -1) {
                    linkedWorkItemIdFront = linkedWorkItemIdFront.substring(0, revIndex);
                }
                result.add(linkedWorkItemIdFront);
            }
        }
        return result;
    }

    public static List<ExternalToolIssueCustomField> resolveWorkItemCustomFields(WorkItem item, TwoDimHashMap<String, String, ExternalToolIssueCustomField> customFieldsByFieldIdByWorkItemType) {
        Custom[] workItemCustomFields = item.getCustomFields();
        HashSet<ExternalToolIssueCustomField> specItemCustomFields = new HashSet<ExternalToolIssueCustomField>();
        Collection customFieldsForWorkItemType = customFieldsByFieldIdByWorkItemType.getValuesByFirstKey((Object)item.getType().getId());
        if (customFieldsForWorkItemType == null) {
            return Collections.emptyList();
        }
        for (ExternalToolIssueCustomField customFieldForWorkItemType : customFieldsForWorkItemType) {
            specItemCustomFields.add(customFieldForWorkItemType);
            customFieldForWorkItemType.setValue("");
        }
        if (workItemCustomFields == null) {
            return new ArrayList<ExternalToolIssueCustomField>(specItemCustomFields);
        }
        for (Custom workItemCustomField : workItemCustomFields) {
            Object workItemCustomFieldValue = workItemCustomField.getValue();
            ExternalToolIssueCustomField customField = (ExternalToolIssueCustomField)customFieldsByFieldIdByWorkItemType.getValue((Object)item.getType().getId(), (Object)workItemCustomField.getKey());
            if (customField == null) {
                LOGGER.error("The definition of custom field " + workItemCustomField.getKey() + " not found in the custom field schema for work items of type " + item.getType().getId() + " when trying to resolve custom fields of the work item " + item.getId());
                continue;
            }
            String mappedCustomFieldValue = PolarionWorkItemFieldResolvingUtils.getMappedCustomFieldValue(customField, workItemCustomFieldValue);
            customField.setValue(mappedCustomFieldValue);
        }
        return new ArrayList<ExternalToolIssueCustomField>(specItemCustomFields);
    }

    public static Optional<String> resolveDocumentId(WorkItem workItem, PolarionExternalElementCache elementCache) throws InterruptedException {
        return PolarionWorkItemFieldResolvingUtils.getReferencedModule(workItem, elementCache).map(Module::getId);
    }

    public static Optional<String> resolveDocumentTitle(WorkItem workItem, PolarionExternalElementCache elementCache) throws InterruptedException {
        return PolarionWorkItemFieldResolvingUtils.getReferencedModule(workItem, elementCache).map(Module::getTitle);
    }

    public static List<String> resolvePlans(WorkItem workItem, PolarionExternalElementCache elementCache) throws InterruptedException {
        return PolarionWorkItemFieldResolvingUtils.getReferencedPlans(workItem, elementCache).stream().map(Plan::getName).toList();
    }

    private static Optional<Module> getReferencedModule(WorkItem workItem, PolarionExternalElementCache elementCache) throws InterruptedException {
        String moduleUri = workItem.getModuleURI();
        if (moduleUri == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(elementCache.getModuleByUri(moduleUri));
        }
        catch (PolarionServerException e) {
            LOGGER.error("Unable to retrieve module for Work Item: %s".formatted(workItem.getId()), (Throwable)e);
            return Optional.empty();
        }
    }

    private static List<Plan> getReferencedPlans(WorkItem workItem, PolarionExternalElementCache elementCache) throws InterruptedException {
        String[] plannedInURIs = workItem.getPlannedInURIs();
        if (plannedInURIs == null || plannedInURIs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Plan> result = new ArrayList<Plan>(plannedInURIs.length);
        for (String planUri : plannedInURIs) {
            try {
                elementCache.getPlanByUri(planUri).ifPresent(result::add);
            }
            catch (PolarionServerException e) {
                LOGGER.error("Unable to retrieve plan %s for Work Item: %s".formatted(planUri, workItem.getId()), (Throwable)e);
            }
        }
        return result;
    }

    public static String resolveModuleFolderFromModuleUri(WorkItem workItem) {
        String moduleUri = workItem.getModuleURI();
        int endIndex = moduleUri.indexOf(DOCUMENT_ID_SEPARATOR);
        int folderBeginIndex = moduleUri.indexOf(MODULE_FOLDER_PREFIX) + MODULE_FOLDER_PREFIX.length();
        return moduleUri.substring(folderBeginIndex, endIndex);
    }

    private static String getMappedCustomFieldValue(ExternalToolIssueCustomField customField, Object workItemCustomFieldValue) {
        String type = customField.getType();
        if (type == null || workItemCustomFieldValue == null) {
            return null;
        }
        if (workItemCustomFieldValue instanceof EnumOptionId) {
            EnumOptionId enumOptionId = (EnumOptionId)workItemCustomFieldValue;
            return enumOptionId.getId();
        }
        if (workItemCustomFieldValue instanceof EnumOptionId[]) {
            EnumOptionId[] enumOptionIds = (EnumOptionId[])workItemCustomFieldValue;
            return Arrays.stream(enumOptionIds).map(EnumOptionId::getId).collect(Collectors.joining(", "));
        }
        if (workItemCustomFieldValue instanceof Calendar) {
            Calendar calendar = (Calendar)workItemCustomFieldValue;
            return String.valueOf(calendar.getTimeInMillis());
        }
        if (workItemCustomFieldValue instanceof Date) {
            Date date = (Date)workItemCustomFieldValue;
            return String.valueOf(date.getTime());
        }
        if (workItemCustomFieldValue instanceof Text) {
            Text text = (Text)workItemCustomFieldValue;
            return text.getContent();
        }
        if (workItemCustomFieldValue instanceof String) {
            String string = (String)workItemCustomFieldValue;
            return string;
        }
        if (workItemCustomFieldValue instanceof Number) {
            Number number = (Number)workItemCustomFieldValue;
            return number.toString();
        }
        if (workItemCustomFieldValue instanceof Boolean) {
            Boolean bool = (Boolean)workItemCustomFieldValue;
            return bool.toString();
        }
        LOGGER.warn("Unknown custom field type: " + String.valueOf(workItemCustomFieldValue.getClass()));
        return String.valueOf(workItemCustomFieldValue);
    }
}

