/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.google.common.collect.ImmutableList;
import com.teamscale.index.dependencies.NearestNeighborFileDependencyFilteringStrategy;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;

public class FileIncludeLookup {
    private final IMatchingPathsLookup pathsLookup;
    private final SystemIncludeFileLookup systemIncludeFileLookup;

    public FileIncludeLookup(IMatchingPathsLookup pathLookupIndex, SystemIncludeFileLookup systemIncludeFileLookup) {
        this.pathsLookup = Objects.requireNonNull(pathLookupIndex);
        this.systemIncludeFileLookup = Objects.requireNonNull(systemIncludeFileLookup);
    }

    public Optional<String> resolveIncludeToUniformPath(IncludeDirective includeDirective, String includingUniformPath, List<String> includeSearchPaths) {
        return this.resolveIncludeToUniformPath(includeDirective.getIncludedFilePath(), includingUniformPath, includeSearchPaths, includeDirective.isIncludeNext());
    }

    public Optional<String> resolveIncludeToUniformPath(String includedFilePath, String includingUniformPath) {
        return this.resolveIncludeToUniformPath(includedFilePath, includingUniformPath, Collections.emptyList(), false);
    }

    private Optional<String> resolveIncludeToUniformPath(String includedFilePath, String includingUniformPath, List<String> includeSearchPaths, boolean includeNextSemantics) {
        CStandardLookupStrategy cStandardLookupStrategy = new CStandardLookupStrategy(includeSearchPaths, false, true, includeNextSemantics);
        Optional<String> uniformPath = cStandardLookupStrategy.resolveIncludedFilePath(includedFilePath, includingUniformPath);
        if (uniformPath.isPresent()) {
            return uniformPath;
        }
        HeuristicLookupStrategy heuristicLookupStrategy = new HeuristicLookupStrategy(includeNextSemantics);
        return heuristicLookupStrategy.resolveIncludedFilePath(includedFilePath, includingUniformPath);
    }

    public Optional<String> resolveIncludeToUniformPathWithCStandardLookup(IncludeDirective includeDirective, String includingUniformPath, List<String> includeSearchPaths, boolean caseSensitive) {
        CStandardLookupStrategy cStandardLookupStrategy = new CStandardLookupStrategy(includeSearchPaths, caseSensitive, includeDirective.isUsingQuotes(), includeDirective.isIncludeNext());
        return cStandardLookupStrategy.resolveIncludedFilePath(includeDirective.getIncludedFilePath(), includingUniformPath);
    }

    public Optional<String> resolveIncludeToUniformPathWithHeuristic(IncludeDirective includeDirective, String includingUniformPath) {
        HeuristicLookupStrategy heuristicLookupStrategy = new HeuristicLookupStrategy(includeDirective.isIncludeNext());
        return heuristicLookupStrategy.resolveIncludedFilePath(includeDirective.getIncludedFilePath(), includingUniformPath);
    }

    public SystemIncludeFileLookup getSystemIncludeFileLookup() {
        return this.systemIncludeFileLookup;
    }

    private class CStandardLookupStrategy
    extends IncludeLookupStrategyBase {
        private final List<String> includeSearchPaths;
        private final boolean caseSensitive;
        private final boolean searchRelativeToIncludingPath;
        private final boolean includeNextSemantics;

        private CStandardLookupStrategy(List<String> includeSearchPaths, boolean caseSensitive, boolean searchRelativeToIncludingPath, boolean includeNextSemantics) {
            this.includeSearchPaths = Objects.requireNonNull(includeSearchPaths);
            this.caseSensitive = caseSensitive;
            this.searchRelativeToIncludingPath = searchRelativeToIncludingPath;
            this.includeNextSemantics = includeNextSemantics;
        }

        @Override
        protected Optional<String> resolveIncludedFilePath(String includedFilePath, String includingUniformPath) {
            String candidate;
            Optional<String> uniformPath;
            String normalizedIncludedFilePath = UniformPathUtils.normalizeAllSeparators((String)includedFilePath);
            if (this.searchRelativeToIncludingPath && !this.includeNextSemantics && (uniformPath = this.findCompletePath(candidate = UniformPathUtils.resolveRelativePath((String)includingUniformPath, (String)normalizedIncludedFilePath), this.caseSensitive)).isPresent()) {
                return uniformPath;
            }
            for (String includeSearchPath : this.includeSearchPaths) {
                String path = CStandardLookupStrategy.buildIncludedFilePath(includeSearchPath, normalizedIncludedFilePath);
                if (this.includeNextSemantics && path.startsWith(UniformPathUtils.getParentPath((String)includingUniformPath))) continue;
                Optional<String> uniformPath2 = this.findCompletePath(path, this.caseSensitive);
                if (uniformPath2.isPresent()) {
                    return uniformPath2;
                }
                uniformPath2 = this.tryResolveSystemIncludeToUniformPath(path);
                if (!uniformPath2.isPresent()) continue;
                return uniformPath2;
            }
            return Optional.empty();
        }

        private static String buildIncludedFilePath(String includeSearchPath, String normalizedIncludedFilePath) {
            boolean startsWithLeadingSlash = includeSearchPath.startsWith("/");
            String normalizedIncludeSearchPath = UniformPathUtils.cleanPath((String)UniformPathUtils.normalizeAllSeparators((String)includeSearchPath));
            String path = normalizedIncludeSearchPath + UniformPathUtils.SEPARATOR + normalizedIncludedFilePath;
            if (startsWithLeadingSlash) {
                return UniformPathUtils.SEPARATOR + path;
            }
            return path;
        }

        private Optional<String> tryResolveSystemIncludeToUniformPath(String uniformPath) {
            if (FileIncludeLookup.this.systemIncludeFileLookup.isSystemIncludedHeader(uniformPath)) {
                return Optional.of(uniformPath);
            }
            return Optional.empty();
        }
    }

    private class HeuristicLookupStrategy
    extends IncludeLookupStrategyBase {
        private final boolean includeNextSemantics;

        private HeuristicLookupStrategy(boolean includeNextSemantics) {
            this.includeNextSemantics = includeNextSemantics;
        }

        @Override
        protected Optional<String> resolveIncludedFilePath(String includedFilePath, String includingUniformPath) {
            ImmutableList<String> candidatePaths;
            String normalizedIncludedFilePath = UniformPathUtils.normalizeAllSeparators((String)includedFilePath);
            String expectedPath = UniformPathUtils.resolveRelativePath((String)includingUniformPath, (String)normalizedIncludedFilePath);
            Optional<String> bestMatch = this.pickBestMatch(expectedPath, (Collection<String>)(candidatePaths = FileIncludeLookup.this.pathsLookup.lookupAllPaths(normalizedIncludedFilePath)));
            if (bestMatch.isEmpty() || !this.includeNextSemantics) {
                return bestMatch;
            }
            List candidatePathsWithoutBestPath = CollectionUtils.filter(candidatePaths, path -> !path.equals(bestMatch.get()));
            return this.pickBestMatch(expectedPath, candidatePathsWithoutBestPath);
        }

        private Optional<String> pickBestMatch(String uniformPath, Collection<String> candidates) {
            if (candidates.isEmpty()) {
                return Optional.empty();
            }
            String nearestPath = NearestNeighborFileDependencyFilteringStrategy.getNearestPath(uniformPath, candidates);
            return Optional.of(nearestPath);
        }
    }

    private abstract class IncludeLookupStrategyBase {
        private IncludeLookupStrategyBase() {
        }

        protected abstract Optional<String> resolveIncludedFilePath(String var1, String var2);

        protected Optional<String> findCompletePath(String candidate, boolean caseSensitive) {
            if (caseSensitive) {
                return FileIncludeLookup.this.pathsLookup.lookupSuffix(candidate).stream().filter(candidate::equals).findFirst();
            }
            return FileIncludeLookup.this.pathsLookup.lookupSuffix(candidate).stream().filter(candidate::equalsIgnoreCase).findFirst();
        }
    }
}

