/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.CppSystemIncludeDirectories;
import com.teamscale.index.resource.IndexAwareCPreprocessor;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.cpp.CppCheckUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class SystemIncludeFileLookup {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SystemIncludeFileCacheIndex cacheIndex;
    private final ConcurrentMap<String, List<IToken>> inMemoryCache;
    private final List<String> systemIncludedDirectories;
    private final Set<String> nonPersistedHeaders = new HashSet<String>();
    private final Set<String> nonExistentHeaders = Collections.synchronizedSet(new HashSet());

    public SystemIncludeFileLookup(SystemIncludeFileCacheIndex cacheIndex, List<String> systemIncludedDirectories) {
        this.cacheIndex = cacheIndex;
        this.systemIncludedDirectories = systemIncludedDirectories;
        this.inMemoryCache = new ConcurrentHashMap<String, List<IToken>>();
    }

    public static SystemIncludeFileLookup create(MetaIndex metaIndex, SystemIncludeFileCacheIndex cacheIndex) throws StorageException {
        CppSystemIncludeDirectories systemIncludeDirectoriesOption = (CppSystemIncludeDirectories)metaIndex.getValue(CppSystemIncludeDirectories.class);
        List systemIncludeDirectories = systemIncludeDirectoriesOption == null ? Collections.emptyList() : (List)systemIncludeDirectoriesOption.getDirectoriesForAllCodeScopes().getValue(CodeScopeAware.DEFAULT_CODE_SCOPE);
        return new SystemIncludeFileLookup(cacheIndex, systemIncludeDirectories);
    }

    public boolean isSystemIncludedHeader(String path) {
        return this.readTokens(path).isPresent();
    }

    public Optional<List<IToken>> readTokens(String path) {
        if (this.nonExistentHeaders.contains(path) || !this.isUnderSystemIncludedDirectories(path)) {
            return Optional.empty();
        }
        Optional<List<IToken>> cachedTokens = this.readFromInMemoryCache(path);
        if (cachedTokens.isPresent()) {
            return cachedTokens;
        }
        cachedTokens = this.readFromCacheIndex(path);
        if (cachedTokens.isPresent()) {
            this.inMemoryCache.put(path, cachedTokens.get());
            return cachedTokens;
        }
        return this.readTokensForNonCachedPath(path);
    }

    private synchronized Optional<List<IToken>> readTokensForNonCachedPath(String path) {
        if (this.nonExistentHeaders.contains(path)) {
            return Optional.empty();
        }
        Optional<List<IToken>> cachedTokens = this.readFromInMemoryCache(path);
        if (cachedTokens.isPresent()) {
            return cachedTokens;
        }
        Optional<SystemIncludedHeader> resolvedHeader = SystemIncludeFileLookup.tryReadingContentsOfSystemIncludedHeader(path);
        if (resolvedHeader.isPresent()) {
            String resolvedPath = resolvedHeader.get().path();
            List<IToken> tokens = resolvedHeader.get().tokens();
            this.nonPersistedHeaders.add(resolvedPath);
            this.inMemoryCache.put(resolvedPath, tokens);
            return Optional.of(tokens);
        }
        this.nonExistentHeaders.add(path);
        return Optional.empty();
    }

    private boolean isUnderSystemIncludedDirectories(String path) {
        for (String systemIncludedDirectory : this.systemIncludedDirectories) {
            if (!path.startsWith(systemIncludedDirectory)) continue;
            return true;
        }
        return false;
    }

    private Optional<List<IToken>> readFromInMemoryCache(String path) {
        return SystemIncludeFileLookup.readEnsuringFileExtension(path, this.inMemoryCache::get);
    }

    private Optional<List<IToken>> readFromCacheIndex(String path) {
        return SystemIncludeFileLookup.readEnsuringFileExtension(path, pathWithExtension -> {
            try {
                return this.cacheIndex.getCachedTokens((String)pathWithExtension).orElse(null);
            }
            catch (StorageException e) {
                LOGGER.warn("Could not read from cache index for path '{}'", (Object)path, (Object)e);
                return null;
            }
        });
    }

    private static Optional<List<IToken>> readEnsuringFileExtension(String path, Function<String, List<IToken>> readFunction) {
        List<IToken> tokens;
        block2: {
            String extension;
            String pathWithExtension;
            if (UniformPathUtils.getExtension((String)path) != null) {
                return Optional.ofNullable(readFunction.apply(path));
            }
            tokens = readFunction.apply(path);
            if (tokens != null) break block2;
            Iterator iterator = CppCheckUtils.HEADER_EXTENSIONS.iterator();
            while (iterator.hasNext() && (tokens = readFunction.apply(pathWithExtension = path + "." + (extension = (String)iterator.next()))) == null) {
            }
        }
        return Optional.ofNullable(tokens);
    }

    private static Optional<SystemIncludedHeader> tryReadingContentsOfSystemIncludedHeader(String path) {
        List tokens = SystemIncludeFileLookup.readEnsuringFileExtension(path, SystemIncludeFileLookup::extractTokens).orElse(null);
        if (tokens == null) {
            LOGGER.warn("Could not create tokens from standard system include file: {}", (Object)path);
            return Optional.empty();
        }
        return Optional.of(new SystemIncludedHeader(path, tokens));
    }

    private static @Nullable List<IToken> extractTokens(String systemIncludeHeaderPath) {
        if (!Files.exists(Path.of(systemIncludeHeaderPath, new String[0]), new LinkOption[0])) {
            return null;
        }
        try {
            String fileContents = FileSystemUtils.readFileUTF8((Path)Path.of(systemIncludeHeaderPath, new String[0]));
            return IndexAwareCPreprocessor.scanAndDropCommentTokens(systemIncludeHeaderPath, fileContents);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncIndexWithLocalCache() throws StorageException {
        Set<String> set = this.nonPersistedHeaders;
        synchronized (set) {
            PairList resolvedHeaderPathAndTokens = new PairList();
            for (String nonPersistedHeader : this.nonPersistedHeaders) {
                List tokens = (List)this.inMemoryCache.get(nonPersistedHeader);
                if (tokens == null) {
                    LOGGER.error("Missing entry in tokens cache for '{}'. Current cache contains tokens for: {}", (Object)nonPersistedHeader, this.inMemoryCache.keySet());
                    continue;
                }
                resolvedHeaderPathAndTokens.add((Object)nonPersistedHeader, (Object)tokens);
            }
            this.cacheIndex.cacheTokens((PairList<String, List<IToken>>)resolvedHeaderPathAndTokens);
            this.nonPersistedHeaders.clear();
        }
    }

    private record SystemIncludedHeader(String path, List<IToken> tokens) {
        private SystemIncludedHeader(String path, List<IToken> tokens) {
            this.path = Objects.requireNonNull(path);
            this.tokens = Objects.requireNonNull(tokens);
        }
    }
}

