/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenElementPreprocessingUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ShallowEntity> getUnpreprocessedEntitiesIfPossible(TokenElementInfo element) {
        if (element.getLanguage().isCppOrC() || element.getLanguage().isObjectiveCOrObjectiveCpp()) {
            List<ShallowEntity> entities = TokenElementPreprocessingUtils.getUnpreprocessedShallowEntities(element);
            if (ShallowEntityTraversalUtils.findIncompleteEntity(entities) != null) {
                entities = element.getShallowEntitiesWithoutPreprocessorTokens();
            }
            return entities;
        }
        return element.getShallowEntitiesWithoutPreprocessorTokens();
    }

    private static List<ShallowEntity> getUnpreprocessedShallowEntities(TokenElementInfo element) {
        if (!PreprocessorUtils.hasPreprocessor((ELanguage)element.getLanguage())) {
            return element.getShallowEntitiesWithoutPreprocessorTokens();
        }
        if (!ShallowParserFactory.supportsLanguage((ELanguage)element.getLanguage())) {
            return null;
        }
        try {
            return ShallowParserFactory.createParser((ELanguage)element.getLanguage()).parseTopLevel(element.getTokens());
        }
        catch (ShallowParserException e) {
            throw new AssertionError("Impossible, as we checked for language " + String.valueOf(element.getLanguage()) + " before!", e);
        }
        catch (Error | RuntimeException e) {
            LOGGER.error("Error while parsing " + element.getUniformPath());
            throw e;
        }
    }
}

