/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.reparsing_dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="reparsing-required", options={EStorageOption.COMPRESSED}, valueClasses={String.class})
public class ReparseRequiredIndex
extends IndexBase
implements IRollbackableIndex,
IProjectIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INDEX_NAME = "reparsing-required";
    private static final byte[] COMMIT_PATH_SENTINEL = new byte[]{-2};

    public ReparseRequiredIndex(IStore store) {
        super(store);
    }

    public void storeAdditionalUniformPathsForReparsing(CommitDescriptor commit, Set<String> uniformPaths) throws StorageException {
        byte[] commitRepresentation = commit.toBranchTimestampKeyWithSeparator();
        PairList newEntries = new PairList();
        for (String uniformPath : uniformPaths) {
            newEntries.add((Object)ReparseRequiredIndex.buildKey(commitRepresentation, uniformPath), (Object)new byte[0]);
        }
        this.store.put(newEntries);
    }

    private static byte[] buildKey(byte[] commitRepresentation, String uniformPath) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{commitRepresentation, COMMIT_PATH_SENTINEL, StringUtils.stringToBytes((String)uniformPath)});
    }

    public List<String> getAdditionalReparsingRequiredPaths(CommitDescriptor commit) throws StorageException {
        byte[] commitRepresentation = commit.toBranchTimestampKeyWithSeparator();
        byte[] keyPrefix = ByteArrayUtils.concat((byte[][])new byte[][]{commitRepresentation, COMMIT_PATH_SENTINEL});
        PairList entries = this.store.getEntriesStartingWith(keyPrefix);
        ArrayList<String> uniformPaths = new ArrayList<String>();
        for (byte[] key : entries.extractFirstList()) {
            int pathLength = key.length - keyPrefix.length;
            uniformPaths.add(StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, keyPrefix.length, keyPrefix.length + pathLength)));
        }
        return uniformPaths;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        if (timestampByBranch.isEmpty()) {
            return;
        }
        ArrayList<byte[]> prefixesForRollbackBranches = new ArrayList<byte[]>();
        for (String branchName : timestampByBranch.keySet()) {
            prefixesForRollbackBranches.add(ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)branchName), CommitDescriptor.SEPARATOR}));
        }
        ArrayList allKeysOnRollbackBranches = new ArrayList();
        this.store.scanKeys(prefixesForRollbackBranches, (IKeyValueCallback)new KeyCollectingCallback(allKeysOnRollbackBranches));
        ArrayList<byte[]> invalidKeys = new ArrayList<byte[]>();
        for (byte[] key : allKeysOnRollbackBranches) {
            CommitDescriptor commit = ReparseRequiredIndex.extractCommitFromKey(key);
            if (commit == null) {
                String keyString = ByteArrayUtils.hexDump((byte[])key, (int)key.length);
                LOGGER.error("Could not extract commit from key {}. Removing this key.", (Object)keyString);
                invalidKeys.add(key);
                continue;
            }
            Long newestValidTimestampForBranch = timestampByBranch.get(commit.getBranchName());
            if (newestValidTimestampForBranch == null || commit.getTimestamp() <= newestValidTimestampForBranch) continue;
            invalidKeys.add(key);
        }
        this.store.remove(invalidKeys);
    }

    private static CommitDescriptor extractCommitFromKey(byte[] key) {
        int sentinelIndex = ByteArrayUtils.indexOf((byte[])COMMIT_PATH_SENTINEL, (byte[])key, (int)0);
        if (sentinelIndex == -1) {
            return null;
        }
        return CommitDescriptor.fromBranchTimestampKeyWithSeparator((byte[])Arrays.copyOf(key, sentinelIndex));
    }
}

