/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.user.User;
import com.teamscale.index.configuration.WorkItemCoreConfiguration;
import com.teamscale.index.resource.retrieval_strategy.CodeMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.CombiningMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.DynamicMetricRecalculatingMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.ExecutionUnitMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.IssueQueryMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricHidingRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricReorderingRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.NonCodeMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.SpecItemQueryMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.TestMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.TestQueryMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.VirtualFileSystemMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.WorkItemMetricRetrievalStrategy;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MetricRetrievalStrategyFactory {
    public static IMetricRetrievalStrategy getStrategy(UniformPath.EType uniformPathType, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, MetricSchemaRetrieverFactory schemaRetrieverFactory) {
        return MetricRetrievalStrategyFactory.getStrategy(uniformPathType, null, projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory, false);
    }

    public static IMetricRetrievalStrategy getStrategy(UniformPath.EType uniformPathType, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser) {
        MetricSchemaRetrieverFactory schemaRetrieverFactory = new MetricSchemaRetrieverFactory(projectStorageSystem);
        return MetricRetrievalStrategyFactory.getStrategy(uniformPathType, projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory);
    }

    public static IMetricRetrievalStrategy getStrategy(UniformPath.EType uniformPathType, @Nullable Set<String> partitions, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser) {
        return MetricRetrievalStrategyFactory.getStrategy(uniformPathType, partitions, projectStorageSystem, globalStorageSystem, currentUser, false);
    }

    public static IMetricRetrievalStrategy getStrategy(UniformPath.EType uniformPathType, @Nullable Set<String> partitions, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, boolean includeHidden) {
        MetricSchemaRetrieverFactory schemaRetrieverFactory = new MetricSchemaRetrieverFactory(projectStorageSystem);
        return MetricRetrievalStrategyFactory.getStrategy(uniformPathType, partitions, projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory, includeHidden);
    }

    public static IMetricRetrievalStrategy getStrategy(UniformPath.EType uniformPathType, @Nullable Set<String> partitions, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, MetricSchemaRetrieverFactory schemaRetrieverFactory, boolean includeHidden) {
        return switch (uniformPathType) {
            default -> throw new MatchException(null, null);
            case UniformPath.EType.ISSUE_QUERY, UniformPath.EType.ISSUE_ITEM -> new IssueQueryMetricRetrievalStrategy(projectStorageSystem, globalStorageSystem, currentUser);
            case UniformPath.EType.SPEC_ITEM_QUERY -> MetricRetrievalStrategyFactory.getSpecItemQueryStrategy(partitions, projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory, includeHidden);
            case UniformPath.EType.SPEC_ITEM -> MetricRetrievalStrategyFactory.getStrategyWithHiddenMetricsSupport(includeHidden, onlyHidden -> MetricRetrievalStrategyFactory.getSpecItemStrategy(projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory, onlyHidden));
            case UniformPath.EType.TEST_QUERY -> new TestQueryMetricRetrievalStrategy(projectStorageSystem, globalStorageSystem, currentUser);
            case UniformPath.EType.NON_CODE -> new NonCodeMetricRetrievalStrategy(projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory.createForType(uniformPathType));
            case UniformPath.EType.TEST_IMPLEMENTATION, UniformPath.EType.TEST_EXECUTION -> new TestMetricRetrievalStrategy(projectStorageSystem, globalStorageSystem, currentUser, partitions, schemaRetrieverFactory.createForType(uniformPathType));
            case UniformPath.EType.CODE -> MetricReorderingRetrievalStrategy.codeMetricsDefaultOrder(MetricRetrievalStrategyFactory.getStrategyWithHiddenMetricsSupport(includeHidden, onlyHidden -> new CodeMetricRetrievalStrategy(projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory.createForType(uniformPathType), (boolean)onlyHidden)));
            case UniformPath.EType.ARCHITECTURE, UniformPath.EType.CODE_SCOPES -> MetricReorderingRetrievalStrategy.codeMetricsDefaultOrder(MetricRetrievalStrategyFactory.getStrategyWithHiddenMetricsSupport(includeHidden, onlyHidden -> new VirtualFileSystemMetricRetrievalStrategy(projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory.createForType(uniformPathType), (boolean)onlyHidden)));
            case UniformPath.EType.EXECUTION_UNIT -> new ExecutionUnitMetricRetrievalStrategy();
        };
    }

    private static IMetricRetrievalStrategy getStrategyWithHiddenMetricsSupport(boolean includeHidden, Function<Boolean, ? extends IMetricRetrievalStrategy> strategyFactory) {
        IMetricRetrievalStrategy strategy = strategyFactory.apply(includeHidden);
        if (includeHidden) {
            strategy = new CombiningMetricRetrievalStrategy(List.of(strategyFactory.apply(false), strategy));
        }
        return strategy;
    }

    private static @NonNull DynamicMetricRecalculatingMetricRetrievalStrategy getSpecItemQueryStrategy(@Nullable Set<String> partitions, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, MetricSchemaRetrieverFactory schemaRetrieverFactory, boolean includeHidden) {
        IMetricRetrievalStrategy specItemMetrics = MetricRetrievalStrategyFactory.getStrategy(UniformPath.EType.SPEC_ITEM, partitions, projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory, includeHidden);
        SpecItemQueryMetricRetrievalStrategy queryMetrics = new SpecItemQueryMetricRetrievalStrategy(projectStorageSystem, globalStorageSystem, currentUser, UniformPath.EType.SPEC_ITEM, specItemMetrics);
        return new DynamicMetricRecalculatingMetricRetrievalStrategy(queryMetrics);
    }

    private static @NonNull IMetricRetrievalStrategy getSpecItemStrategy(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, MetricSchemaRetrieverFactory schemaRetrieverFactory, boolean onlyHidden) {
        WorkItemMetricRetrievalStrategy defaultCodeMetrics = new WorkItemMetricRetrievalStrategy(projectStorageSystem, globalStorageSystem, currentUser, "metrics-dir", "metric-trend", schemaRetrieverFactory.createForType("metric-schema"), onlyHidden);
        MetricHidingRetrievalStrategy reducedCodeMetrics = MetricHidingRetrievalStrategy.ofMetrics(List.of(WorkItemMetricRetrievalStrategy.INCLUDED_DEFAULT_METRICS::contains, metric -> metric.startsWith("Number of Findings")), defaultCodeMetrics);
        if (onlyHidden) {
            return new DynamicMetricRecalculatingMetricRetrievalStrategy(reducedCodeMetrics);
        }
        WorkItemMetricRetrievalStrategy specItemSpecificMetrics = new WorkItemMetricRetrievalStrategy(projectStorageSystem, globalStorageSystem, currentUser, "work-item-metrics-directory", "work-item-metrics-trend", schemaRetrieverFactory.createForType(WorkItemCoreConfiguration.METRICS_SCHEMA_INDEX_NAME), onlyHidden);
        CombiningMetricRetrievalStrategy specItemMetrics = new CombiningMetricRetrievalStrategy(List.of(specItemSpecificMetrics, reducedCodeMetrics));
        return new DynamicMetricRecalculatingMetricRetrievalStrategy(specItemMetrics);
    }
}

