/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.reviews;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@ExportToTypeScript
@Option(id="review.baseline", name="Code Review Baseline Date. When changing this value, a full re-analysis of the project is necessary.", type=EOptionType.PROJECT, category=EOptionCategory.CODE_REVIEW)
@IndexValueClass(containedInBackup=true)
public class CodeReviewBaselineOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "review.baseline";
    public static final String OPTION_NAME = "Code Review Baseline Date. When changing this value, a full re-analysis of the project is necessary.";
    private static final String BASELINE_DATE_FORMAT = "yyyy-MM-dd";
    private static final DateTimeFormatter BASELINE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Logger LOGGER = LogManager.getLogger();
    @JsonProperty(value="baselineDate")
    @OptionFieldDescription(name="The baseline date using the format yyyy-MM-dd")
    public String baselineDate = null;

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        try {
            this.getBaselineDate();
            return null;
        }
        catch (ParseException e) {
            return "Invalid date. Expected format: yyyy-MM-dd";
        }
    }

    private LocalDate getBaselineDate() throws ParseException {
        if (StringUtils.isEmpty((String)this.baselineDate)) {
            return null;
        }
        return LocalDate.parse(this.baselineDate, BASELINE_DATE_FORMATTER);
    }

    @VisibleForTesting
    void setBaseline(LocalDate date) {
        this.baselineDate = date.format(BASELINE_DATE_FORMATTER);
    }

    public static long getBaselineOption(ProjectOptionIndex projectOptionIndex) throws StorageException {
        CodeReviewBaselineOption baselineOption = (CodeReviewBaselineOption)ProjectOptionRegistry.getInstance().getOption("<p>", OPTION_ID, null, CodeReviewBaselineOption.class, (OptionIndexBase)projectOptionIndex);
        if (baselineOption != null) {
            try {
                LocalDate baselineDate = baselineOption.getBaselineDate();
                if (baselineDate != null) {
                    return baselineDate.atStartOfDay(DateTimeUtils.getZone()).toInstant().toEpochMilli();
                }
            }
            catch (ParseException e) {
                LOGGER.error("Failed to parse base line, so ignoring this option: " + e.getMessage(), (Throwable)e);
                return -1L;
            }
        }
        return -1L;
    }
}

