/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.reviews;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.external.ExternalUploadIndexBase;
import com.teamscale.index.external.update.ExternalUploadPersisterBase;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.reviews.ElementReviewCommit;
import com.teamscale.index.reviews.ElementReviewStatus;
import com.teamscale.index.reviews.ElementReviewStatusIndex;
import com.teamscale.index.reviews.ElementReviewUploadIndex;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class ElementReviewChangePersister
extends ExternalUploadPersisterBase<ElementReviewCommit> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ElementReviewStatusIndex reviewStatusIndex;
    @BranchingLayerAccess(value=ElementReviewUploadIndex.class)
    private IBranchingLayer uploadIndexBranchingLayer;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="element-review-commit-tree")
    private CommitTreeIndex commitTreeIndex;
    @DeltaSource(value=CommitTreeIndex.class, indexName="element-review-commit-tree")
    private KeyDelta commitTreeDelta;

    @Override
    protected KeyDelta getCommitTreeDelta() {
        return this.commitTreeDelta;
    }

    @Override
    protected IBranchingLayer getExternalUploadBranchingLayer() {
        return this.uploadIndexBranchingLayer;
    }

    @Override
    protected ExternalUploadIndexBase<ElementReviewCommit> createExternalUploadIndex(IStore baseStore) {
        return new ElementReviewUploadIndex(baseStore);
    }

    @Override
    protected void processCommitsForNodes(List<ICommitTreeNode> commitTreeNodes) throws StorageException {
        if (commitTreeNodes.isEmpty()) {
            return;
        }
        String user = null;
        PairList reviewStatusValues = new PairList();
        PairList elementHistoryValues = new PairList();
        HashSet<UniformPath> uniformPaths = new HashSet<UniformPath>();
        StringBuilder message = new StringBuilder("Code Review:");
        for (ICommitTreeNode node : commitTreeNodes) {
            ElementReviewCommit commitInfo = (ElementReviewCommit)((Object)this.getExternalUploadIndex(node).getCommitInfo());
            if (user == null) {
                user = commitInfo.getUser();
            }
            uniformPaths.add(UniformPathCompatibilityUtil.convert((String)commitInfo.getUniformPath()));
            reviewStatusValues.add((Object)commitInfo.getUniformPath(), (Object)new ElementReviewStatus(commitInfo.getReviewStatus(), commitInfo.getUser(), commitInfo.getTimestamp()));
            elementHistoryValues.add((Object)commitInfo.getUniformPath(), (Object)new ElementHistoryEntry(EElementHistoryChangeType.EXTERNAL_ANALYSIS_UPLOAD, commitInfo.getCommit(), EChangeEntryOrigin.MANUAL_CODE_REVIEW));
            message.append(" ").append(UniformPathUtils.getElementName((String)commitInfo.getUniformPath())).append(" set to '").append(commitInfo.getReviewStatus().getReadableName()).append("'");
        }
        this.reviewStatusIndex.setReviewStatuses((PairList<String, ElementReviewStatus>)reviewStatusValues);
        this.elementHistoryIndex.setHistoryEntries((PairList<String, ElementHistoryEntry>)elementHistoryValues);
        this.writeRepositoryLogEntry(this.getSchedulingCommit(), "code-review", message.toString(), user, 0, uniformPaths.size(), 0);
        this.writeRepositoryLogFileEntries(this.getSchedulingCommit(), uniformPaths, Collections.emptyList(), ECommitType.CODE_REVIEW);
    }

    @Override
    protected CommitTreeIndex getCommitTreeIndex() {
        return this.commitTreeIndex;
    }

    @Override
    protected String getRepositoryIdentifier() {
        return "Review commits";
    }

    @Override
    protected ECommitType getCommitType() {
        return ECommitType.CODE_REVIEW;
    }
}

