/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.reviews;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.reviews.CodeReviewBaselineOption;
import com.teamscale.index.reviews.ElementReviewStatus;
import com.teamscale.index.reviews.ElementReviewStatusIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ReviewRatingSynchronizer
extends ChangeProcessorAnalysisStep {
    public static final String METRIC_INDEX_PARTITION = "rating";
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @DeltaSource(value=ElementReviewStatusIndex.class)
    private KeyDelta reviewStatusDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ElementReviewStatusIndex reviewStatusIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="metrics")
    private MetricsIndex metricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ProjectOptionIndex projectOptionIndex;

    public void execute() throws StorageException, ExecutionException {
        this.metricsIndex.removeEntries((Collection)this.contentDelta.getDeletedKeysAsStrings(), new String[]{METRIC_INDEX_PARTITION});
        long baseline = CodeReviewBaselineOption.getBaselineOption(this.projectOptionIndex);
        ArrayList uniformPaths = new ArrayList(CollectionUtils.unionSet((Collection)this.reviewStatusDelta.getAddedOrChangedKeysAsStrings(), (Collection[])new Collection[]{this.contentDelta.getAddedOrChangedKeysAsStrings()}));
        this.executeInParallelBatches(uniformPaths, batch -> this.processBatch((List<String>)batch, baseline));
    }

    private void processBatch(List<String> uniformPaths, long baseline) throws StorageException {
        List<TokenElementInfo> tokenElements = this.contentIndex.getTokenElements(uniformPaths);
        List<ElementReviewStatus> reviewStatusValues = this.reviewStatusIndex.getReviewStatuses(uniformPaths);
        PairList values = new PairList();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            TokenElementInfo tokenElement = tokenElements.get(i);
            if (tokenElement == null) continue;
            ElementReviewStatus reviewStatus = reviewStatusValues.get(i);
            values.add((Object)uniformPaths.get(i), (Object)this.determineAssessment(tokenElement, reviewStatus, baseline));
        }
        this.metricsIndex.setMetricValues(values, METRIC_INDEX_PARTITION);
    }

    private Assessment determineAssessment(TokenElementInfo element, ElementReviewStatus reviewStatus, long baseline) {
        String content = element.getText();
        ETrafficLightColor color = ETrafficLightColor.RED;
        if (this.getSchedulingCommit().getTimestamp() <= baseline) {
            color = ETrafficLightColor.BASELINE;
        } else if (reviewStatus != null && reviewStatus.getTimestamp() < this.getSchedulingCommit().getTimestamp()) {
            return ReviewRatingSynchronizer.singleFileAssessment(content, color);
        }
        if (reviewStatus != null && reviewStatus.getTimestamp() > baseline) {
            color = reviewStatus.getStatus().getColor();
        }
        return ReviewRatingSynchronizer.singleFileAssessment(content, color);
    }

    private static Assessment singleFileAssessment(String content, ETrafficLightColor color) {
        Assessment assessment = new Assessment();
        assessment.add(color, StringUtils.splitLinesAsList((String)content).size());
        return assessment;
    }
}

