/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type.dimensions;

import com.google.common.collect.Multimap;
import com.teamscale.index.simulink.LibraryBlockIdentifier;
import com.teamscale.index.simulink.signal_type.SimulinkLibraryLoader;
import com.teamscale.index.simulink.signal_type.SimulinkNavigationUtils;
import com.teamscale.index.simulink.signal_type.SimulinkPropagationUtils;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionUpdater;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionUtils;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionalityResolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkMatrix;
import org.conqat.lib.simulink.model.SimulinkMatrixFactory;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.SimulinkResolvedDimensions;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkDimensionalityResolverFromInput {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SimulinkResolvedDimensions resolvedDimensions;
    private final SimulinkLibraryLoader libraryLoader;
    private final SimulinkDimensionUpdater updater;
    private final Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks;
    private static final String DEFAULT_DIMENSION = "";
    private final Map<String, SimulinkDimensionalityResolver> resolvedDimensionsForEmbeddedModels;
    private final Set<SimulinkBlock> visitedBlocks = new HashSet<SimulinkBlock>();
    private final Set<LibraryBlockIdentifier> visitedLibraryBlocks;

    public SimulinkDimensionalityResolverFromInput(SimulinkLibraryLoader libraryLoader, SimulinkResolvedDimensions resolvedDimensions, SimulinkDimensionUpdater updater, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks, Map<String, SimulinkDimensionalityResolver> resolvedDimensionsForEmbeddedModels, Set<LibraryBlockIdentifier> visitedLibraryBlocks) {
        this.libraryLoader = libraryLoader;
        this.resolvedDimensions = resolvedDimensions;
        this.updater = updater;
        this.typeLinks = typeLinks;
        this.resolvedDimensionsForEmbeddedModels = resolvedDimensionsForEmbeddedModels;
        this.visitedLibraryBlocks = visitedLibraryBlocks;
    }

    public Map<String, SimulinkDimensionalityResolver> resolveDimensions(SimulinkModel model) throws StorageException {
        this.visitedBlocks.add((SimulinkBlock)model);
        List blocks = SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)true, (boolean)true);
        this.resolveDimensions(blocks);
        this.setDefaultDimensionsForTypeLinks();
        this.resolveDimensions(blocks);
        return this.resolvedDimensionsForEmbeddedModels;
    }

    private void resolveDimensions(List<SimulinkBlock> blocks) throws StorageException {
        do {
            this.updater.setBlocksUpdated(false);
            for (SimulinkBlock block : blocks) {
                this.resolveDimensions(block);
            }
            for (SimulinkBlock block : blocks) {
                this.backpropagateDimensionality(block);
            }
            this.updateTypeLinks();
            this.visitedBlocks.clear();
        } while (this.updater.hasBeenUpdated());
    }

    private void resolveDimensions(SimulinkBlock block) throws StorageException {
        if (!this.needsUpdate(block)) {
            return;
        }
        this.visitedBlocks.add(block);
        if (SimulinkUtils.referencesCustomLibrary((SimulinkBlock)block)) {
            this.resolveDimensionsForLibraryReferenceBlock(block);
        } else if (SimulinkUtils.isSubsystemReferenceBlock((SimulinkBlock)block)) {
            this.resolveDimensionsForSubsystemReferenceBlock(block);
        } else if (block.getInPorts().isEmpty()) {
            this.determineDimensionsFromSuccessors(block);
        } else if (block.isOfType("Mux")) {
            this.determineDimensionsOfMuxBlock(block);
        } else if (block.isOfType("Demux")) {
            this.determineDimensionsOfDemuxBlock(block);
        } else if (SimulinkDimensionalityResolverFromInput.dimensionDependsOnPredecessor(block)) {
            this.determineDimensionFromPredecessor(block);
        }
    }

    private void determineDimensionFromPredecessor(SimulinkBlock block) throws StorageException {
        this.checkPrecondition(block);
        Set inputDimensions = this.resolvedDimensions.getInputDimensionalities(block);
        if (!inputDimensions.isEmpty()) {
            Optional<SimulinkMatrix> largestSignalDimension = SimulinkDimensionUtils.getLargestCommonSignalDimension(inputDimensions);
            largestSignalDimension.ifPresent(simulinkMatrix -> this.updater.updateDimension(block, (SimulinkMatrix)simulinkMatrix));
            if (largestSignalDimension.isPresent()) {
                this.updater.updateDimension(block, largestSignalDimension.get());
            } else {
                LOGGER.info("Encountered input signals with incompatible dimensions for block " + block.getName() + " of model " + block.getModel().getName());
            }
        }
    }

    private boolean needsUpdate(SimulinkBlock block) {
        if (this.visitedBlocks.contains(block)) {
            return false;
        }
        if (block.getOutPorts().isEmpty()) {
            return !this.resolvedDimensions.contains(block);
        }
        return !block.getOutPorts().stream().map(SimulinkPortBase::getIndex).allMatch(index -> this.resolvedDimensions.contains(block, index));
    }

    private static boolean dimensionDependsOnPredecessor(SimulinkBlock block) {
        return !block.isOfType("SubSystem");
    }

    private void determineDimensionsFromSuccessors(SimulinkBlock block) {
        List<SimulinkBlock> successors = SimulinkNavigationUtils.getNonSubsystemSuccessorBlocks(block);
        if (successors.isEmpty()) {
            this.updater.updateDimension(block, SimulinkMatrixFactory.createMatrixFromDimensions((String)DEFAULT_DIMENSION));
            return;
        }
        HashSet<SimulinkMatrix> possibleDimensions = new HashSet<SimulinkMatrix>();
        for (SimulinkBlock successor : successors) {
            Set types = this.resolvedDimensions.getDimensionalityForAllPorts(successor);
            if (types.isEmpty()) {
                return;
            }
            possibleDimensions.addAll(this.resolvedDimensions.getDimensionalityForAllPorts(successor));
        }
        Optional<SimulinkMatrix> dimension = SimulinkDimensionUtils.getLargestCommonSignalDimension(possibleDimensions);
        if (dimension.isPresent()) {
            this.updater.updateDimension(block, dimension.get());
            this.propagateTypeToPredecessor(block, dimension.get().toDimensionFormat());
        }
    }

    private void resolveDimensionsForLibraryReferenceBlock(SimulinkBlock block) throws StorageException {
        this.checkPrecondition(block);
        List<SimulinkModel> libraryModels = this.libraryLoader.loadLibraryFromReferenceBlock(block);
        if (libraryModels.isEmpty()) {
            this.resolvedDimensions.setInformationForBlock(block, SimulinkMatrixFactory.createMatrixFromDimensions((String)DEFAULT_DIMENSION));
            return;
        }
        for (SimulinkModel libraryModel : libraryModels) {
            LibraryBlockIdentifier libraryBlockIdentifier = LibraryBlockIdentifier.of(libraryModel, block);
            if (this.visitedLibraryBlocks.contains(libraryBlockIdentifier)) continue;
            this.visitedLibraryBlocks.add(libraryBlockIdentifier);
            SimulinkResolvedDimensions alreadyResolvedDimensions = this.getAlreadyResolvedSignalsForLibrary(libraryModel);
            SimulinkDimensionalityResolver libraryResolver = new SimulinkDimensionalityResolver(libraryModel, this.libraryLoader, alreadyResolvedDimensions, this.resolvedDimensionsForEmbeddedModels, SimulinkPropagationUtils.extractReferencedBlock(libraryModel, block.getSourceBlockName()));
            this.passInformationToInPortsOfLibrary(block, libraryResolver);
            libraryResolver.resolveDimensions(this.visitedLibraryBlocks);
            this.fetchInformationFromOutPortsOfLibrary(block, libraryResolver);
            this.resolvedDimensionsForEmbeddedModels.put(libraryModel.getUniformPath(), libraryResolver);
        }
    }

    private void resolveDimensionsForSubsystemReferenceBlock(SimulinkBlock subsystemReferenceBlock) throws StorageException {
        this.checkPrecondition(subsystemReferenceBlock);
        List<SimulinkModel> targetModels = this.libraryLoader.loadReferencedModelFromSubsystemReferenceBlock(subsystemReferenceBlock);
        if (targetModels.isEmpty()) {
            this.resolvedDimensions.setInformationForBlock(subsystemReferenceBlock, SimulinkMatrixFactory.createMatrixFromDimensions((String)DEFAULT_DIMENSION));
            return;
        }
        for (SimulinkModel targetModel : targetModels) {
            LibraryBlockIdentifier libraryBlockIdentifier = LibraryBlockIdentifier.of(targetModel, subsystemReferenceBlock);
            if (this.visitedLibraryBlocks.contains(libraryBlockIdentifier)) continue;
            this.visitedLibraryBlocks.add(libraryBlockIdentifier);
            SimulinkResolvedDimensions alreadyResolvedDimensions = this.getAlreadyResolvedSignalsForLibrary(targetModel);
            SimulinkDimensionalityResolver libraryResolver = new SimulinkDimensionalityResolver(targetModel, this.libraryLoader, alreadyResolvedDimensions, this.resolvedDimensionsForEmbeddedModels, (SimulinkBlock)targetModel);
            this.passInformationToInPortsOfLibrary(subsystemReferenceBlock, libraryResolver);
            libraryResolver.resolveDimensions(this.visitedLibraryBlocks);
            this.fetchInformationFromOutPortsOfLibrary(subsystemReferenceBlock, libraryResolver);
            this.resolvedDimensionsForEmbeddedModels.put(targetModel.getUniformPath(), libraryResolver);
        }
    }

    private SimulinkResolvedDimensions getAlreadyResolvedSignalsForLibrary(SimulinkModel libraryModel) {
        SimulinkDimensionalityResolver simulinkDimensionalityResolver = this.resolvedDimensionsForEmbeddedModels.get(libraryModel.getUniformPath());
        if (simulinkDimensionalityResolver == null) {
            return new SimulinkResolvedDimensions();
        }
        return simulinkDimensionalityResolver.getResolvedDimensions();
    }

    private void backpropagateDimensionality(SimulinkBlock block) {
        Set dimensions = this.resolvedDimensions.getDimensionalityForAllPorts(block);
        if (dimensions.size() == 1) {
            String dimension = ((SimulinkMatrix)dimensions.stream().findFirst().get()).toDimensionFormat();
            this.propagateTypeToPredecessor(block, dimension);
        }
    }

    private void updateTypeLinks() {
        for (SimulinkBlock block : this.typeLinks.keySet()) {
            if (!SimulinkUtils.isInport((SimulinkBlock)block) || !this.resolvedDimensions.getInputDimensionalities(block).isEmpty()) continue;
            this.determineDimensionsFromSuccessors(block);
        }
    }

    private void setDefaultDimensionsForTypeLinks() {
        for (SimulinkBlock block : this.typeLinks.keySet()) {
            if (!this.resolvedDimensions.getDimensionalityForAllPorts(block).isEmpty()) continue;
            this.updater.updateDimension(block, SimulinkMatrixFactory.createMatrixFromDimensions((String)DEFAULT_DIMENSION));
        }
    }

    private void passInformationToInPortsOfLibrary(SimulinkBlock libraryBlock, SimulinkDimensionalityResolver libraryResolver) {
        for (SimulinkInPort inPort : libraryBlock.getInPorts()) {
            SimulinkMatrix resolvedDimension = this.resolvedDimensions.getInputDimensionality(libraryBlock, inPort.getIndex());
            if (resolvedDimension == null) continue;
            libraryResolver.addResolvedInPortDimension(inPort.getIndex(), resolvedDimension);
        }
    }

    private void fetchInformationFromOutPortsOfLibrary(SimulinkBlock libraryBlock, SimulinkDimensionalityResolver libraryResolver) {
        Map<String, SimulinkMatrix> outputDimensionsOfLibrary = libraryResolver.getResolvedOutPortDimensions();
        for (Map.Entry<String, SimulinkMatrix> entry : outputDimensionsOfLibrary.entrySet()) {
            String port = entry.getKey();
            SimulinkMatrix dimension = entry.getValue();
            this.updater.updateDimension(libraryBlock, port, dimension);
        }
    }

    private void checkPrecondition(SimulinkBlock block) throws StorageException {
        List<SimulinkBlock> predecessors = SimulinkNavigationUtils.getPredecessorAndSiblingsBlocks(block);
        for (SimulinkBlock predecessor : predecessors) {
            if (predecessor == null || !this.needsUpdate(predecessor)) continue;
            this.resolveDimensions(predecessor);
        }
    }

    private void propagateTypeToPredecessor(SimulinkBlock block, String dimension) {
        List<Object> blocksToUpdate = new ArrayList();
        if (SimulinkUtils.isInport((SimulinkBlock)block)) {
            String port = block.getParameter("Port");
            Optional<SimulinkBlock> optional = SimulinkNavigationUtils.getPredecessorBlockFromInputPort(block.getParent(), port);
            optional.ifPresent(blocksToUpdate::add);
        } else {
            blocksToUpdate = SimulinkNavigationUtils.getPredecessors(block);
        }
        for (SimulinkBlock simulinkBlock : blocksToUpdate) {
            if (this.resolvedDimensions.contains(simulinkBlock)) continue;
            Set currentDimensions = this.resolvedDimensions.getDimensionalityForAllPorts(simulinkBlock);
            currentDimensions.add(SimulinkMatrixFactory.createMatrixFromDimensions((String)dimension));
            Optional<SimulinkMatrix> newDimensionality = SimulinkDimensionUtils.getLargestCommonSignalDimension(currentDimensions);
            newDimensionality.ifPresent(simulinkMatrix -> this.updater.updateDimension(predecessor, (SimulinkMatrix)simulinkMatrix));
        }
    }

    private void determineDimensionsOfMuxBlock(SimulinkBlock block) throws StorageException {
        this.checkPrecondition(block);
        List inputDimensions = this.resolvedDimensions.getInputDimensionalitiesAsList(block);
        if (inputDimensions.isEmpty()) {
            return;
        }
        long sum = 0L;
        for (SimulinkMatrix dimension : inputDimensions) {
            if (dimension.isScalar()) {
                ++sum;
                continue;
            }
            if (dimension.getNumberOfRows() > 0L) {
                sum += dimension.getNumberOfRows();
                continue;
            }
            sum += dimension.getNumberOfColumns();
        }
        SimulinkMatrix port1Dimension = this.resolvedDimensions.getInputDimensionality(block, "1");
        if (port1Dimension == null) {
            LOGGER.info("Input dimensionality of Demux block " + block.getName() + " in model " + block.getModel().getUniformPath() + " is null.");
            return;
        }
        SimulinkMatrix outputDimension = port1Dimension.getNumberOfRows() > 0L ? new SimulinkMatrix(sum, -1L) : new SimulinkMatrix(-1L, sum);
        this.resolvedDimensions.setInformationForBlock(block, outputDimension);
    }

    private void determineDimensionsOfDemuxBlock(SimulinkBlock block) throws StorageException {
        this.checkPrecondition(block);
        SimulinkMatrix inputDimension = this.resolvedDimensions.getInputDimensionality(block, "1");
        if (inputDimension == null) {
            return;
        }
        int remainingNumberOfOutPorts = block.getOutPorts().size();
        long remainingSignalSize = Math.max(inputDimension.getNumberOfRows(), inputDimension.getNumberOfColumns());
        for (SimulinkOutPort port : block.getOutPorts()) {
            long newLength = remainingSignalSize / (long)remainingNumberOfOutPorts + remainingSignalSize % (long)remainingNumberOfOutPorts;
            remainingSignalSize -= newLength;
            --remainingNumberOfOutPorts;
            if (newLength == 1L) {
                newLength = -1L;
            }
            SimulinkMatrix outputDimension = new SimulinkMatrix(newLength, -1L);
            this.resolvedDimensions.setInformationForBlock(block, port.getIndex(), outputDimension);
        }
    }
}

