/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.code_links.ICodeLinkProvider;
import com.teamscale.index.simulink.tracing.SimulinkCoderCodeGenerationSourceFileMapper;
import com.teamscale.index.simulink.tracing.SimulinkCoderGeneratorTracingUtils;
import com.teamscale.index.simulink.tracing.SimulinkPlcCoderTraceIndex;
import com.teamscale.index.simulink.tracing.SimulinkSourceFileMapper;
import com.teamscale.index.simulink.tracing.TracelinkAbbreviationIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;

public class SimulinkCodeTraceLinkProvider
implements ICodeLinkProvider {
    @Override
    public void registerLinks(FormattedTokenElementInfo targetInfo, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        if (targetInfo.getLanguage() == ELanguage.IEC61131) {
            SimulinkPlcCoderTraceIndex plcCoderTraceIndex = (SimulinkPlcCoderTraceIndex)projectStorageSystem.openProjectIndex(SimulinkPlcCoderTraceIndex.class, historyAccessOption);
            targetInfo.mapCommentParts(new PlcCoderCommentPartLinker(plcCoderTraceIndex.getAllTraces()));
        }
        if (targetInfo.getLanguage().isCppOrC() && projectStorageSystem.hasIndex("simulink-tracelink-abbr")) {
            SimulinkCodeTraceLinkProvider.generateLinksForBmwCodeGeneration(targetInfo, projectStorageSystem, historyAccessOption);
        }
    }

    private static void generateLinksForBmwCodeGeneration(FormattedTokenElementInfo targetInfo, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        Optional<String> modelName = SimulinkCoderGeneratorTracingUtils.extractModelName(targetInfo);
        if (modelName.isEmpty()) {
            return;
        }
        SimulinkModelInfoIndex modelInfoIndex = (SimulinkModelInfoIndex)projectStorageSystem.openProjectIndex(SimulinkModelInfoIndex.class, historyAccessOption);
        Optional<String> uniformPath = SimulinkCodeTraceLinkProvider.findBestUniformPathForBmwModelName(modelName.get(), modelInfoIndex);
        if (uniformPath.isEmpty()) {
            return;
        }
        ElementLocation baseLocation = new ElementLocation(uniformPath.get());
        TracelinkAbbreviationIndex tracelinkAbbreviationIndex = (TracelinkAbbreviationIndex)projectStorageSystem.openProjectIndex(TracelinkAbbreviationIndex.class, historyAccessOption);
        targetInfo.mapCommentParts(new SimulinkTraceLinkResolver(modelName.get(), baseLocation, modelInfoIndex, tracelinkAbbreviationIndex));
    }

    private static Optional<String> findBestUniformPathForBmwModelName(String modelName, SimulinkModelInfoIndex modelInfoIndex) throws StorageException {
        String alternativeModelName;
        List<Object> uniformPaths = Collections.emptyList();
        Iterator<String> iterator = SimulinkModelInfoIndex.createAlternativeModelNames(modelName).iterator();
        while (iterator.hasNext() && (uniformPaths = modelInfoIndex.getUniformPathsForModelName(alternativeModelName = iterator.next())).isEmpty()) {
        }
        if (uniformPaths.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((String)uniformPaths.get(0));
    }

    private static class PlcCoderCommentPartLinker
    implements FormattedTokenElementInfo.ICommentPartLinker<NeverThrownRuntimeException> {
        private final PairList<String, QualifiedNameLocation> plcCoderCodeToModelTraces;

        private PlcCoderCommentPartLinker(PairList<String, QualifiedNameLocation> plcCoderCodeToModelTraces) {
            this.plcCoderCodeToModelTraces = plcCoderCodeToModelTraces;
        }

        @Override
        public Optional<FormattedTokenElementInfo.CommentPartLink> extractLink(String commentContent) {
            int smallestMatchOffset = -1;
            FormattedTokenElementInfo.CommentPartLink result = null;
            for (Pair entry : this.plcCoderCodeToModelTraces) {
                int matchStart = commentContent.indexOf((String)entry.getFirst());
                if (matchStart == -1 || smallestMatchOffset != -1 && smallestMatchOffset < matchStart) continue;
                result = new FormattedTokenElementInfo.CommentPartLink(matchStart, matchStart + ((String)entry.getFirst()).length(), (ElementLocation)entry.getSecond());
                smallestMatchOffset = matchStart;
            }
            return Optional.ofNullable(result);
        }
    }

    private static class SimulinkTraceLinkResolver
    implements FormattedTokenElementInfo.ICommentPartLinker<StorageException> {
        private final String modelName;
        private final ElementLocation baseLocation;
        private final SimulinkModelInfoIndex modelInfoIndex;
        private final TracelinkAbbreviationIndex tracelinkAbbreviationIndex;

        public SimulinkTraceLinkResolver(String modelName, ElementLocation baseLocation, SimulinkModelInfoIndex modelInfoIndex, TracelinkAbbreviationIndex tracelinkAbbreviationIndex) {
            this.modelName = modelName;
            this.baseLocation = baseLocation;
            this.modelInfoIndex = modelInfoIndex;
            this.tracelinkAbbreviationIndex = tracelinkAbbreviationIndex;
        }

        @Override
        public Optional<FormattedTokenElementInfo.CommentPartLink> extractLink(String commentContent) throws StorageException {
            Matcher matcher = SimulinkSourceFileMapper.CODE_LINK_PATTERN.matcher(commentContent);
            if (!matcher.find()) {
                return Optional.empty();
            }
            Optional<String> resolved = SimulinkCoderCodeGenerationSourceFileMapper.resolveCodeLink(matcher.group(1), this.modelName, this.tracelinkAbbreviationIndex);
            if (!resolved.isPresent()) {
                return Optional.empty();
            }
            ElementLocation linkLocation = SimulinkCoderCodeGenerationSourceFileMapper.resolveSimulinkElementLocation(resolved.get(), this.baseLocation, this.modelInfoIndex);
            return Optional.of(new FormattedTokenElementInfo.CommentPartLink(matcher.start(1), matcher.end(1), linkLocation));
        }
    }
}

