/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.structure;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.structure.LongestStatementListAnalyzerBase;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class ShallowParsedLongestStatementListAnalyzer
extends LongestStatementListAnalyzerBase {
    private final boolean countStatements;
    private final Pattern ignoredMethodsPattern;
    private static final Logger LOGGER = LogManager.getLogger();

    public ShallowParsedLongestStatementListAnalyzer(boolean slocBased, boolean countStatements, Pattern ignoredMethodsPattern) {
        super(slocBased);
        this.countStatements = countStatements;
        this.ignoredMethodsPattern = ignoredMethodsPattern;
    }

    @Override
    protected void calculateStatementListLocations(TokenElementInfo element, Set<Integer> ignoredLines) {
        if (CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES.contains(element.getLanguage())) {
            ShallowEntity.traverse(element.getShallowEntitiesWithPreprocessorTokens(), (IShallowEntityVisitor)new PreprocessorAwareStatementListLengthVisitor(ignoredLines, element.getLanguage(), this.ignoredMethodsPattern));
        } else {
            ShallowEntity.traverse(element.getShallowEntitiesWithoutPreprocessorTokens(), (IShallowEntityVisitor)new StatementListLengthVisitor(ignoredLines, element.getLanguage(), this.ignoredMethodsPattern));
        }
    }

    public static Optional<Pair<IToken, IToken>> getBodyStartEndBraceTokens(ShallowEntity entity) {
        UnmodifiableList includedTokens = entity.includedTokens();
        if (TokenStreamUtils.endsWith((List)includedTokens, (ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.RBRACE})) {
            return Optional.of(Pair.createPair((Object)((IToken)includedTokens.get(includedTokens.size() - 2)), (Object)((IToken)includedTokens.get(includedTokens.size() - 1))));
        }
        CCSMAssert.isTrue((boolean)entity.hasChildren(), (String)("Can't determine start/end brace of method without body: " + entity.getName()));
        IToken lastStartToken = (IToken)CollectionUtils.getLast((List)entity.ownStartTokens());
        IToken firstEndToken = null;
        if (entity.getChildren().isEmpty() && lastStartToken != null) {
            int indexOfLastStartToken = includedTokens.indexOf((Object)lastStartToken);
            if (indexOfLastStartToken + 1 < includedTokens.size()) {
                firstEndToken = (IToken)includedTokens.get(indexOfLastStartToken + 1);
            }
        } else {
            UnmodifiableList endTokens = entity.ownEndTokens();
            if (!endTokens.isEmpty()) {
                firstEndToken = (IToken)endTokens.get(0);
            }
        }
        if (lastStartToken == null || firstEndToken == null) {
            return ShallowParsedLongestStatementListAnalyzer.getBodyStartEndForFunctionTryBlock(entity);
        }
        return Optional.of(Pair.createPair((Object)lastStartToken, (Object)firstEndToken));
    }

    private static Optional<Pair<IToken, IToken>> getBodyStartEndForFunctionTryBlock(ShallowEntity entity) {
        List fileTokens = entity.getAllTokensOfFile();
        ShallowEntity firstChild = (ShallowEntity)entity.getChildren().get(0);
        ShallowEntity lastChild = (ShallowEntity)entity.getChildren().get(entity.getChildren().size() - 1);
        if (((IToken)fileTokens.get(0)).getLanguage().isCppOrObjectiveCpp() && firstChild.getSubtype().equals("try") && lastChild.getSubtype().equals("catch")) {
            IToken startingLeftBrace = (IToken)fileTokens.get(firstChild.getStartTokenIndex() + 1);
            IToken endingRightBrace = (IToken)fileTokens.get(lastChild.getEndTokenIndex() - 1);
            return Optional.of(Pair.createPair((Object)startingLeftBrace, (Object)endingRightBrace));
        }
        return Optional.empty();
    }

    private class PreprocessorAwareStatementListLengthVisitor
    extends StatementListLengthVisitor {
        public PreprocessorAwareStatementListLengthVisitor(Set<Integer> ignoredLines, ELanguage language, Pattern ignoredMethodsPattern) {
            super(ignoredLines, language, ignoredMethodsPattern);
        }

        @Override
        public void endVisit(ShallowEntity entity) {
            if (entity.getType() != EShallowEntityType.METHOD) {
                return;
            }
            if (this.isExcludedByName(entity)) {
                return;
            }
            if (ShallowParsedLongestStatementListAnalyzer.this.countStatements) {
                super.endVisit(entity);
                return;
            }
            if (!entity.isCompleted()) {
                LOGGER.warn("Could not determine preprocessor-aware method length of " + entity.getName() + " in " + ShallowParsedLongestStatementListAnalyzer.this.currentElement.getUniformPath() + " because of parse errors. Falling back to non-preprocessor aware method-length computing.");
                super.endVisit(entity);
                return;
            }
            if (!entity.hasChildren() && !TokenStreamUtils.endsWith((List)entity.includedTokens(), (ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.RBRACE})) {
                return;
            }
            if (PreprocessorAwareStatementListLengthVisitor.isDeclaredInMethod(entity)) {
                return;
            }
            Optional<Pair<IToken, IToken>> bodyStartEndTokens = ShallowParsedLongestStatementListAnalyzer.getBodyStartEndBraceTokens(entity);
            if (!bodyStartEndTokens.isPresent()) {
                LOGGER.warn("Could not determine preprocessor-aware method length of " + entity.getName() + " in " + ShallowParsedLongestStatementListAnalyzer.this.currentElement.getUniformPath() + " (could not determine method-body start or end). Falling back to non-preprocessor aware method-length computing.");
                super.endVisit(entity);
                return;
            }
            this.reportStatementListForStartEndTokens(entity.getName(), (IToken)bodyStartEndTokens.get().getFirst(), (IToken)bodyStartEndTokens.get().getSecond());
        }

        private static boolean isDeclaredInMethod(ShallowEntity entity) {
            for (ShallowEntity parent = entity.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getType() != EShallowEntityType.METHOD) continue;
                return true;
            }
            return false;
        }

        private void reportStatementListForStartEndTokens(String entityName, IToken lastStartToken, IToken firstEndToken) {
            UnmodifiableList<IToken> nonPreprocessedTokens = ShallowParsedLongestStatementListAnalyzer.this.currentElement.getTokens();
            int bodyStartTokenIndex = TokenStreamUtils.indexOfByOffset(nonPreprocessedTokens, (int)lastStartToken.getOffset()) + 1;
            int bodyEndTokenIndex = TokenStreamUtils.indexOfByOffset(nonPreprocessedTokens, (int)firstEndToken.getOffset()) - 1;
            if (bodyEndTokenIndex < bodyStartTokenIndex) {
                return;
            }
            int startOffset = ((IToken)nonPreprocessedTokens.get(bodyStartTokenIndex)).getOffset();
            int endOffset = ((IToken)nonPreprocessedTokens.get(bodyEndTokenIndex)).getOffset();
            if (endOffset < startOffset) {
                LOGGER.warn("Skipping method " + entityName + " with negative length (possibly caused by macro expansion) in " + ShallowParsedLongestStatementListAnalyzer.this.currentElement.getUniformPath());
            } else {
                ShallowParsedLongestStatementListAnalyzer.this.reportStatementListForOffsets(startOffset, endOffset, this.ignoredLines);
            }
        }
    }

    private class StatementListLengthVisitor
    implements IShallowEntityVisitor {
        private final Set<Integer> ignoredLines;
        private final ELanguage language;
        private final Pattern ignoredMethodsPattern;

        public StatementListLengthVisitor(Set<Integer> ignoredLines, ELanguage language, Pattern ignoredMethodsPattern) {
            this.ignoredLines = ignoredLines;
            this.language = language;
            this.ignoredMethodsPattern = ignoredMethodsPattern;
        }

        public boolean visit(ShallowEntity entity) {
            return true;
        }

        private void reportStatements(List<ShallowEntity> statements, int startOffset, int endOffset) {
            if (ShallowParsedLongestStatementListAnalyzer.this.countStatements) {
                this.reportStatementCount(statements, startOffset, endOffset);
            } else {
                ShallowParsedLongestStatementListAnalyzer.this.reportStatementListForOffsets(startOffset, endOffset, this.ignoredLines);
            }
        }

        private void reportStatementCount(List<ShallowEntity> statements, int startOffset, int endOffset) {
            int statementCount;
            List allStatements = ShallowEntityTraversalUtils.listEntitiesOfType(statements, (EShallowEntityType)EShallowEntityType.STATEMENT);
            if (CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES.contains(this.language)) {
                HashSet<Integer> uniqueOffsets = new HashSet<Integer>();
                for (ShallowEntity statement : allStatements) {
                    uniqueOffsets.add(statement.getStartOffset());
                }
                statementCount = uniqueOffsets.size();
            } else {
                statementCount = allStatements.size();
            }
            int rawStartOffset = ShallowParsedLongestStatementListAnalyzer.this.currentOffsetTransformer.getUnfilteredOffset(startOffset);
            int rawEndOffset = ShallowParsedLongestStatementListAnalyzer.this.currentOffsetTransformer.getUnfilteredOffset(endOffset);
            int rawStartLine = ShallowParsedLongestStatementListAnalyzer.this.currentRawLineOffsetConverter.getLine(rawStartOffset);
            int rawEndLine = ShallowParsedLongestStatementListAnalyzer.this.currentRawLineOffsetConverter.getLine(rawEndOffset);
            ShallowParsedLongestStatementListAnalyzer.this.reportMetricValue(statementCount, (ElementLocation)new TextRegionLocation(ShallowParsedLongestStatementListAnalyzer.this.currentElement.getUniformPath(), rawStartOffset, rawEndOffset, rawStartLine, rawEndLine));
        }

        public void endVisit(ShallowEntity entity) {
            if (entity.getType() != EShallowEntityType.METHOD) {
                return;
            }
            List<ShallowEntity> statements = this.getStatements(entity);
            if (statements.isEmpty()) {
                return;
            }
            if (this.isMethodExcluded(entity)) {
                return;
            }
            int startOffset = statements.get(0).getStartOffset();
            int endOffset = this.determineEndOffset(statements);
            if (endOffset < startOffset) {
                LOGGER.warn("Skipping method " + entity.getName() + " with negative length (possibly caused by marco expansion) in " + ShallowParsedLongestStatementListAnalyzer.this.currentElement.getUniformPath());
            } else {
                this.reportStatements(statements, startOffset, endOffset);
            }
            if (this.isLanguageJavaScript() && (LanguageFeatureParser.JAVASCRIPT.isDefinedInAngularJsMethod(entity) || LanguageFeatureParser.JAVASCRIPT.isDefinedInYuiModule(entity) || LanguageFeatureParser.JAVASCRIPT.isMethodDefinedInImmediatelyReturnedObject(entity) || LanguageFeatureParser.JAVASCRIPT.isDefinedInLowerLevelOfTopLevelImmediatelyInvokedFunctionExpression(entity))) {
                for (int i = entity.getStartLine(); i <= entity.getEndLine(); ++i) {
                    this.ignoredLines.add(i);
                }
            }
        }

        private boolean isMethodExcluded(ShallowEntity entity) {
            return this.isExcludedByName(entity) || this.isJavaScriptMethodExcluded(entity);
        }

        protected boolean isExcludedByName(ShallowEntity entity) {
            String name = entity.getName();
            if (StringUtils.isEmpty((String)name) || this.ignoredMethodsPattern.toString().equals("")) {
                return false;
            }
            return this.ignoredMethodsPattern.matcher(name).matches();
        }

        private List<ShallowEntity> getStatements(ShallowEntity entity) {
            if (ShallowParsedLongestStatementListAnalyzer.this.countStatements) {
                return entity.getChildrenOfType(EShallowEntityType.STATEMENT);
            }
            return entity.getChildren().stream().filter(childEntity -> childEntity.getType() == EShallowEntityType.STATEMENT || childEntity.getType() == EShallowEntityType.TYPE && childEntity.getSubtype().equals("struct")).collect(Collectors.toList());
        }

        private boolean isJavaScriptMethodExcluded(ShallowEntity entity) {
            if (!this.isLanguageJavaScript()) {
                return false;
            }
            return LanguageFeatureParser.JAVASCRIPT.isConstructor(entity) || LanguageFeatureParser.JAVASCRIPT.isDescribeBlock(entity) || LanguageFeatureParser.JAVASCRIPT.isTopLevelImmediatelyInvokedFunctionExpression(entity);
        }

        private int determineEndOffset(List<ShallowEntity> statements) {
            List nonSyntheticTokens;
            ShallowEntity lastStatement = (ShallowEntity)CollectionUtils.getLast(statements);
            if (this.language == ELanguage.PYTHON && !(nonSyntheticTokens = CollectionUtils.filter((Collection)lastStatement.includedTokens(), token -> token.getType().getTokenClass() != ETokenType.ETokenClass.SYNTHETIC && token.getType().getTokenClass() != ETokenType.ETokenClass.WHITESPACE)).isEmpty()) {
                return ((IToken)CollectionUtils.getLast((List)nonSyntheticTokens)).getEndOffset();
            }
            return lastStatement.getEndOffset();
        }

        private boolean isLanguageJavaScript() {
            return this.language == ELanguage.JAVASCRIPT;
        }
    }
}

