/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.task;

import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.user.User;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskChangeNotifier;
import com.teamscale.index.task.TaskNotificationOption;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.html.EHTMLAttribute;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;

public class TaskNotificationUtils {
    public static void sendCreationNotification(Task task, User user, PublicProjectId publicId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        TaskNotificationOption.ETaskNotificationEvent event = TaskNotificationOption.ETaskNotificationEvent.TASK_CREATE;
        String userFullName = user.getFullName();
        String subject = TaskNotificationUtils.buildTaskSubject(event.getSubjectTextSnippet(), task, user);
        String body = TaskNotificationUtils.buildTaskSummaryMail(event.getBodyTextSnippet() + userFullName, task);
        TaskNotificationUtils.sendNotificationsToParticipants(task, subject, body, event, user, publicId, globalStorageSystem);
    }

    public static void sendChangeNotification(Task task, List<String> changes, User user, PublicProjectId publicId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        TaskNotificationOption.ETaskNotificationEvent event = TaskNotificationOption.ETaskNotificationEvent.TASK_CHANGE;
        String userFullName = user.getFullName();
        String subject = TaskNotificationUtils.buildTaskSubject(event.getSubjectTextSnippet(), task, user);
        String body = TaskNotificationUtils.buildTaskUpdateMail(event.getBodyTextSnippet() + userFullName, changes);
        TaskNotificationUtils.sendNotificationsToParticipants(task, subject, body, event, user, publicId, globalStorageSystem);
    }

    public static void sendCommentNotification(Task task, String comment, User user, PublicProjectId publicId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        TaskNotificationOption.ETaskNotificationEvent event = TaskNotificationOption.ETaskNotificationEvent.COMMENT_ADD;
        String userFullName = user.getFullName();
        String subject = TaskNotificationUtils.buildTaskSubject(event.getSubjectTextSnippet(), task, user);
        String body = TaskNotificationUtils.buildTaskCommentMail(event.getBodyTextSnippet() + userFullName, comment);
        TaskNotificationUtils.sendNotificationsToParticipants(task, subject, body, event, user, publicId, globalStorageSystem);
    }

    private static void sendNotificationsToParticipants(Task task, String subject, String body, TaskNotificationOption.ETaskNotificationEvent event, User user, PublicProjectId publicId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        String header = TaskNotificationUtils.buildTaskHeader(task);
        String footer = TaskNotificationUtils.buildTaskFooter(task, publicId, globalStorageSystem);
        TaskChangeNotifier notifier = new TaskChangeNotifier(task, user, globalStorageSystem);
        notifier.sendNotificationsToParticipants(subject, header + body + footer, event);
    }

    private static String buildTaskHeader(Task task) {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        StringBuilder heading = new StringBuilder();
        heading.append("Task ");
        heading.append(task.getId());
        heading.append(": ");
        heading.append(task.getSubject());
        writer.addClosedTextElement((Enum)EHTMLElement.H2, heading.toString(), new Object[0]);
        writer.close();
        return stringWriter.toString();
    }

    private static String buildTaskFooter(Task task, PublicProjectId projectId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        String link = TaskNotificationUtils.buildTaskURL(task, projectId, globalStorageSystem);
        StringWriter stringWriter = new StringWriter();
        if (link != null) {
            HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
            writer.addText("Follow this ");
            writer.addClosedTextElement((Enum)EHTMLElement.A, "link", new Object[]{EHTMLAttribute.HREF, link});
            writer.addText(" to see the task details.");
            writer.close();
        }
        return stringWriter.toString();
    }

    private static String buildTaskURL(Task task, PublicProjectId projectId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        String baseUrl = BaseUrlOption.getBaseUrl((GlobalStorageSystem)globalStorageSystem);
        if (baseUrl != null) {
            return new TeamscaleProjectLinkProvider(baseUrl, projectId).createTaskDetailLink(task.getId());
        }
        return null;
    }

    private static String buildTaskSummaryMail(String header, Task task) {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        TaskNotificationUtils.appendHeader(writer, header);
        TaskNotificationUtils.appendTaskSummary(writer, task);
        writer.close();
        return stringWriter.toString();
    }

    private static void appendTaskSummary(HTMLWriter writer, Task task) {
        writer.openElement((Enum)EHTMLElement.UL);
        TaskNotificationUtils.appendTaskStatus(writer, task);
        TaskNotificationUtils.appendTaskResolution(writer, task);
        TaskNotificationUtils.appendTaskTags(writer, task);
        TaskNotificationUtils.appendTaskDescription(writer, task);
        TaskNotificationUtils.appendTaskFindings(writer, task);
        writer.closeElement((Enum)EHTMLElement.UL);
    }

    private static void appendTaskStatus(HTMLWriter writer, Task task) {
        if (task.getStatus() != null) {
            String statusText = "Status: " + task.getStatus().getReadableName();
            writer.addClosedTextElement((Enum)EHTMLElement.LI, statusText, new Object[0]);
        }
    }

    private static void appendTaskResolution(HTMLWriter writer, Task task) {
        if (task.getResolution() != null) {
            String resolutionText = "Resolution: " + task.getResolution().getReadableName();
            writer.addClosedTextElement((Enum)EHTMLElement.LI, resolutionText, new Object[0]);
        }
    }

    private static void appendTaskTags(HTMLWriter writer, Task task) {
        if (task.getTags().size() > 0) {
            writer.openElement((Enum)EHTMLElement.LI);
            writer.addText("Tags: ");
            for (String tag : task.getTags()) {
                writer.addText(tag + "; ");
            }
            writer.closeElement((Enum)EHTMLElement.LI);
        }
    }

    private static void appendTaskDescription(HTMLWriter writer, Task task) {
        if (task.getDescription() != null) {
            writer.openElement((Enum)EHTMLElement.LI);
            writer.addText("Description: ");
            writer.openElement((Enum)EHTMLElement.BR);
            writer.closeElement((Enum)EHTMLElement.BR);
            writer.addClosedTextElement((Enum)EHTMLElement.PRE, task.getDescription(), new Object[0]);
            writer.closeElement((Enum)EHTMLElement.LI);
        }
    }

    private static void appendTaskFindings(HTMLWriter writer, Task task) {
        List<String> findings = task.getFindingIds();
        if (!findings.isEmpty()) {
            writer.openElement((Enum)EHTMLElement.LI);
            writer.addText("Findings: ");
            writer.openElement((Enum)EHTMLElement.BR);
            writer.closeElement((Enum)EHTMLElement.BR);
            writer.openElement((Enum)EHTMLElement.UL);
            for (String finding : findings) {
                writer.addClosedTextElement((Enum)EHTMLElement.LI, finding, new Object[0]);
            }
            writer.closeElement((Enum)EHTMLElement.UL);
            writer.closeElement((Enum)EHTMLElement.LI);
        }
    }

    private static String buildTaskCommentMail(String header, String comment) {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        TaskNotificationUtils.appendHeader(writer, header);
        writer.addClosedTextElement((Enum)EHTMLElement.PRE, comment, new Object[0]);
        writer.close();
        return stringWriter.toString();
    }

    private static String buildTaskUpdateMail(String header, List<String> content) {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        TaskNotificationUtils.appendHeader(writer, header);
        TaskNotificationUtils.appendList(writer, content);
        writer.close();
        return stringWriter.toString();
    }

    private static void appendHeader(HTMLWriter writer, String header) {
        writer.openElement((Enum)EHTMLElement.P);
        writer.addClosedTextElement((Enum)EHTMLElement.B, header, new Object[0]);
        writer.closeElement((Enum)EHTMLElement.P);
    }

    private static void appendList(HTMLWriter writer, List<String> content) {
        writer.openElement((Enum)EHTMLElement.UL);
        for (String line : content) {
            writer.openElement((Enum)EHTMLElement.LI);
            writer.addRawString(line);
            writer.closeElement((Enum)EHTMLElement.LI);
        }
        writer.closeElement((Enum)EHTMLElement.UL);
    }

    private static String buildTaskSubject(String text, Task task, User user) {
        StringBuilder subject = new StringBuilder();
        subject.append(user.getFullName());
        subject.append(" ");
        subject.append(text);
        subject.append(" task ");
        subject.append(task.getId());
        subject.append(": '");
        subject.append(task.getSubject());
        subject.append("'.");
        return subject.toString();
    }
}

