/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="executed-methods", options={EStorageOption.ABBREVIATE_STRINGS, EStorageOption.COMMIT_ISOLATED}, valueClasses={byte[].class})
public class ExecutedMethodIndex
extends IndexBase
implements IProjectIndex,
IRollbackableIndex {
    public static final String INDEX_NAME = "executed-methods";
    private static final byte[] EMPTY_VALUE = new byte[0];

    public ExecutedMethodIndex(IStore store) {
        super(store, true);
    }

    public void addExecutedMethods(CommitDescriptor commit, List<AssociatedMethodInfo> infos) throws StorageException {
        ArrayList<byte[]> methodEntryKeys = new ArrayList<byte[]>(infos.size());
        for (AssociatedMethodInfo info : infos) {
            byte[] methodEntryKey = new ExecutedMethodAccessKey(info.getUniformPath(), info).toStoreInternalKey(this.store.getAbbreviator());
            methodEntryKeys.add(methodEntryKey);
        }
        List methodEntryValues = this.store.get(methodEntryKeys);
        HashSet<byte[]> newMethodEntryKeys = new HashSet<byte[]>();
        for (int i = 0; i < methodEntryKeys.size(); ++i) {
            if (methodEntryValues.get(i) != null) continue;
            newMethodEntryKeys.add((byte[])methodEntryKeys.get(i));
        }
        if (newMethodEntryKeys.isEmpty()) {
            return;
        }
        PairList addedEntries = new PairList();
        newMethodEntryKeys.forEach(newMethodEntryKey -> addedEntries.add(newMethodEntryKey, (Object)EMPTY_VALUE));
        addedEntries.add((Object)ExecutedMethodIndex.makeCommitEntryKey(commit), (Object)StorageUtils.serialize(newMethodEntryKeys));
        this.store.put(addedEntries);
    }

    public boolean isMethodExecuted(AssociatedMethodInfo info) throws StorageException {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        keys.add(new ExecutedMethodAccessKey(info.getUniformPath(), info).toStoreInternalKey(abbreviator));
        keys.addAll(CollectionUtils.mapWithException(info.getCrossAnnotationKeys(), key -> key.toStoreInternalKey(abbreviator)));
        return this.store.get(keys).stream().anyMatch(Objects::nonNull);
    }

    private static byte[] makeCommitEntryKey(CommitDescriptor commitDescriptor) {
        return EEntryType.COMMIT_ENTRY.prefixKey(commitDescriptor.toBranchTimestampKey());
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        ArrayList<byte[]> keysToDelete = new ArrayList<byte[]>();
        for (String branch : timestampByBranch.keySet()) {
            keysToDelete.addAll(this.determineKeysToDelete(timestampByBranch, branch));
        }
        this.store.remove(keysToDelete);
    }

    private List<byte[]> determineKeysToDelete(Map<String, Long> timestampByBranch, String branch) throws StorageException {
        ArrayList<byte[]> keysToDelete = new ArrayList<byte[]>();
        ArrayList serializedMethodInfoKeysForCommit = new ArrayList();
        long timestamp = timestampByBranch.get(branch);
        byte[] beginCommitKey = ExecutedMethodIndex.makeCommitEntryKey(new CommitDescriptor(branch, timestamp + 1L));
        byte[] endCommitKey = ExecutedMethodIndex.makeCommitEntryKey(CommitDescriptor.latestOnBranch((String)branch));
        this.store.scan(beginCommitKey, endCommitKey, (key, value) -> {
            CommitDescriptor targetCommit = ExecutedMethodIndex.extractCommitFromPrefixedKey(key);
            if (timestampByBranch.containsKey(targetCommit.getBranchName()) && targetCommit.getTimestamp() > (Long)timestampByBranch.get(targetCommit.getBranchName())) {
                List list = keysToDelete;
                synchronized (list) {
                    keysToDelete.add(key);
                    serializedMethodInfoKeysForCommit.add(value);
                }
            }
        });
        for (byte[] methodInfoKeys : serializedMethodInfoKeysForCommit) {
            keysToDelete.addAll((Collection)((Object)StorageUtils.deserialize((byte[])methodInfoKeys)));
        }
        return keysToDelete;
    }

    private static CommitDescriptor extractCommitFromPrefixedKey(byte[] rawKey) {
        return CommitDescriptor.fromBranchTimestampKey((byte[])EEntryType.COMMIT_ENTRY.removePrefixFromKey(rawKey));
    }

    @IndexValueClass
    public static final class ExecutedMethodAccessKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String uniformPath;
        private final String methodName;
        private final String hash;

        public ExecutedMethodAccessKey(String uniformPath, MethodInfo info) {
            this(uniformPath, info.getMethodName(), info.getHash());
        }

        ExecutedMethodAccessKey(String uniformPath, String methodName, String hash) {
            this.uniformPath = uniformPath;
            this.methodName = methodName;
            this.hash = hash;
        }

        public String toMethodEntryKey() {
            Object[] parts = new String[]{this.uniformPath, this.methodName, this.hash};
            return StringUtils.concat((Object[])parts, (String)"#!#");
        }

        private byte[] toStoreInternalKey(StorageStringAbbreviator abbreviator) throws StorageException {
            return EEntryType.METHOD_INFO_ENTRY.prefixKey(ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(this.uniformPath)), ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(this.methodName)), StringUtils.stringToBytes((String)this.hash)}));
        }

        public static ExecutedMethodAccessKey fromMethodEntryKey(String entryKey) {
            String[] parts = entryKey.split("#!#");
            CCSMAssert.isTrue((parts.length == 3 ? 1 : 0) != 0, (String)"Entry key must consist of three parts, as constructed in ExecutedMethodAccessKey#toMethodEntryKey()");
            return new ExecutedMethodAccessKey(parts[0], parts[1], parts[2]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutedMethodAccessKey that = (ExecutedMethodAccessKey)o;
            return Objects.equals(this.uniformPath, that.uniformPath) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.hash, that.hash);
        }

        public int hashCode() {
            return Objects.hash(this.uniformPath, this.methodName, this.hash);
        }
    }

    private static enum EEntryType {
        COMMIT_ENTRY(0),
        METHOD_INFO_ENTRY(1);

        private final byte[] entryTypePrefix;

        private EEntryType(int entryTypePrefix) {
            this.entryTypePrefix = new byte[]{(byte)entryTypePrefix};
        }

        private byte[] prefixKey(byte[] unprefixedKey) {
            return ByteArrayUtils.concat((byte[][])new byte[][]{this.entryTypePrefix, unprefixedKey});
        }

        private byte[] removePrefixFromKey(byte[] prefixedKey) {
            return Arrays.copyOfRange(prefixedKey, this.entryTypePrefix.length, prefixedKey.length);
        }
    }
}

