/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfo;
import com.teamscale.index.testgap.MethodInfoContainer;
import com.teamscale.index.testgap.MethodLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="tga-method-info", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={MethodInfoContainer.class})
public class MethodInfoIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "tga-method-info";
    private static final String CROSS_ANNOTATION_INFO_PREFIX = "#ca#";
    private static final String METHOD_INFO_CONTAINER_PREFIX = "#mc#";

    public MethodInfoIndex(IStore store) {
        super(store);
    }

    public MethodInfo getMethodInfoWithCrossAnnotationInfo(String uniformPath, OffsetBasedRegion region) throws StorageException {
        MethodInfoContainer container = this.readContainerWithCrossAnnotationInfo(uniformPath);
        if (container == null) {
            return null;
        }
        return container.getMethodInfo(region);
    }

    private MethodInfoContainer readContainerWithoutCrossAnnotationInfo(String uniformPath) throws StorageException {
        return MethodInfoContainer.deserializeWithoutCrossAnnotations(this.store.getWithString(MethodInfoIndex.createMethodInfoContainerKey(uniformPath)));
    }

    private @Nullable MethodInfoContainer readContainerWithCrossAnnotationInfo(String uniformPath) throws StorageException {
        MethodInfoContainer baseContainer = this.readContainerWithoutCrossAnnotationInfo(uniformPath);
        if (baseContainer == null) {
            return null;
        }
        byte[] crossAnnotationData = this.store.getWithString(MethodInfoIndex.createCrossAnnotationInfoKey(uniformPath));
        baseContainer.deserializeAndAddCrossAnnotationInfo(crossAnnotationData);
        return baseContainer;
    }

    public AssociatedMethodInfo getAssociatedMethodInfoWithCrossAnnotationInfoLoaded(String uniformPath, OffsetBasedRegion region) throws StorageException {
        MethodInfo methodInfo = this.getMethodInfoWithCrossAnnotationInfo(uniformPath, region);
        if (methodInfo == null) {
            return null;
        }
        return new AssociatedMethodInfo(uniformPath, region, methodInfo);
    }

    public Map<MethodLocation, MethodInfo> getMethodInfoMapForExactPaths(PairList<String, OffsetBasedRegion> uniformPathsAndRegions) throws StorageException {
        HashMap<MethodLocation, MethodInfo> methodInfos = new HashMap<MethodLocation, MethodInfo>();
        List allUniformPaths = uniformPathsAndRegions.extractFirstList();
        List<String> distinctUniformPaths = allUniformPaths.stream().distinct().collect(Collectors.toList());
        List<MethodInfoContainer> values = this.getMethodContainersWithCrossAnnotationInfo(distinctUniformPaths);
        Map methodInfoContainers = CollectionUtils.zipAsMap(distinctUniformPaths, values);
        for (int i = 0; i < allUniformPaths.size(); ++i) {
            MethodInfoContainer methodInfoContainer = (MethodInfoContainer)methodInfoContainers.get(allUniformPaths.get(i));
            if (methodInfoContainer == null) continue;
            String uniformPath = (String)uniformPathsAndRegions.getFirst(i);
            OffsetBasedRegion region = (OffsetBasedRegion)uniformPathsAndRegions.getSecond(i);
            MethodLocation methodLocation = new MethodLocation(uniformPath, region);
            methodInfos.put(methodLocation, methodInfoContainer.getMethodInfo(region));
        }
        return methodInfos;
    }

    private List<MethodInfoContainer> getMethodContainersWithCrossAnnotationInfo(List<String> distinctUniformPaths) throws StorageException {
        List keys = CollectionUtils.map(distinctUniformPaths, MethodInfoIndex::createMethodInfoContainerKey);
        List methodInfoContainers = CollectionUtils.mapWithException((Collection)this.store.getWithStrings(keys), MethodInfoContainer::deserializeWithoutCrossAnnotations);
        this.loadCrossAnnotationInfoIntoMethodContainers(distinctUniformPaths, methodInfoContainers);
        return methodInfoContainers;
    }

    private void loadCrossAnnotationInfoIntoMethodContainers(List<String> distinctUniformPaths, List<MethodInfoContainer> methodInfoContainers) throws StorageException {
        List annotationInfos = this.store.getWithStrings(CollectionUtils.map(distinctUniformPaths, MethodInfoIndex::createCrossAnnotationInfoKey));
        for (int i = 0; i < distinctUniformPaths.size(); ++i) {
            if (methodInfoContainers.get(i) == null) continue;
            methodInfoContainers.get(i).deserializeAndAddCrossAnnotationInfo((byte[])annotationInfos.get(i));
        }
    }

    public List<MethodInfoContainer> getMethodContainersWithoutCrossAnnotationInfo(List<String> uniformPaths) throws StorageException {
        return CollectionUtils.mapWithException((Collection)this.store.getWithStrings(CollectionUtils.map(uniformPaths, MethodInfoIndex::createMethodInfoContainerKey)), MethodInfoContainer::deserializeWithoutCrossAnnotations);
    }

    public Map<String, MethodInfoContainer> getMethodContainersWithoutCrossAnnotationInfoByUniformPath(List<String> uniformPaths) throws StorageException {
        uniformPaths = new ArrayList<String>(new HashSet<String>(uniformPaths));
        List<MethodInfoContainer> values = this.getMethodContainersWithoutCrossAnnotationInfo(uniformPaths);
        HashMap<String, MethodInfoContainer> result = new HashMap<String, MethodInfoContainer>(uniformPaths.size());
        for (int i = 0; i < uniformPaths.size(); ++i) {
            result.put(uniformPaths.get(i), values.get(i));
        }
        return result;
    }

    public List<AssociatedMethodInfo> getMethodInfosForPathPrefix(String uniformPathPrefix) throws StorageException {
        PairList<String, MethodInfoContainer> entriesStartingWith = this.getMethodInfoContainerEntriesWithUniformPathPrefix(uniformPathPrefix);
        this.loadCrossAnnotationInfoIntoMethodContainers(entriesStartingWith.extractFirstList(), entriesStartingWith.extractSecondList());
        return MethodInfoIndex.convertToAssociatedMethodInfos(entriesStartingWith);
    }

    private PairList<String, MethodInfoContainer> getMethodInfoContainerEntriesWithUniformPathPrefix(String uniformPathPrefix) throws StorageException {
        PairList entries = new PairList();
        this.store.scan(MethodInfoIndex.createMethodInfoContainerKey(uniformPathPrefix), (key, value) -> {
            PairList pairList = entries;
            synchronized (pairList) {
                entries.add((Object)key, (Object)value);
            }
        });
        PairList results = new PairList();
        for (int i = 0; i < entries.size(); ++i) {
            results.add((Object)MethodInfoIndex.removeMethodInfoContainerPrefix(StringUtils.bytesToString((byte[])((byte[])entries.getFirst(i)))), (Object)MethodInfoContainer.deserializeWithoutCrossAnnotations((byte[])entries.getSecond(i)));
        }
        return results;
    }

    public List<AssociatedMethodInfo> getAssociatedMethodInfosForExactPaths(List<String> uniformPaths, boolean includeCrossAnnotationInformation) throws StorageException {
        if (includeCrossAnnotationInformation) {
            return this.getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(uniformPaths);
        }
        return this.getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(uniformPaths);
    }

    public List<AssociatedMethodInfo> getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(List<String> uniformPaths) throws StorageException {
        List<MethodInfoContainer> values = this.getMethodContainersWithoutCrossAnnotationInfo(uniformPaths);
        return MethodInfoIndex.convertToAssociatedMethodInfos((PairList<String, MethodInfoContainer>)PairList.zip(uniformPaths, values));
    }

    public List<AssociatedMethodInfo> getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(List<String> uniformPaths) throws StorageException {
        List<MethodInfoContainer> values = this.getMethodContainersWithCrossAnnotationInfo(uniformPaths);
        return MethodInfoIndex.convertToAssociatedMethodInfos((PairList<String, MethodInfoContainer>)PairList.zip(uniformPaths, values));
    }

    public Set<AssociatedMethodInfo> getAssociatedMethodInfosForExactPathsAndRegions(Collection<MethodLocation> methodLocations, boolean includeCrossAnnotationInformation) throws StorageException {
        Map<String, List<MethodLocation>> methodLocationsByUniformPath = methodLocations.stream().collect(Collectors.groupingBy(MethodLocation::getUniformPath));
        ArrayList<String> uniformPaths = new ArrayList<String>(methodLocationsByUniformPath.keySet());
        List<MethodInfoContainer> values = includeCrossAnnotationInformation ? this.getMethodContainersWithCrossAnnotationInfo(uniformPaths) : this.getMethodContainersWithoutCrossAnnotationInfo(uniformPaths);
        HashSet<AssociatedMethodInfo> associatedMethodInfos = new HashSet<AssociatedMethodInfo>();
        for (int i = 0; i < values.size(); ++i) {
            String uniformPath = (String)uniformPaths.get(i);
            MethodInfoContainer container = values.get(i);
            if (container == null) continue;
            for (MethodLocation methodLocation : methodLocationsByUniformPath.get(uniformPath)) {
                OffsetBasedRegion region = methodLocation.getRegion();
                MethodInfo methodInfo = container.getMethodInfo(region);
                if (methodInfo == null) {
                    throw new StorageException("No method with region " + String.valueOf(region) + " found for " + uniformPath + ". This can happen when the project is in analysis, and the retrieved data is inconsistent. The error should disappear when the analysis is finished for the selected branch.");
                }
                associatedMethodInfos.add(new AssociatedMethodInfo(uniformPath, region, methodInfo));
            }
        }
        return associatedMethodInfos;
    }

    @TestOnly
    public void setMethodInfo(String uniformPath, OffsetBasedRegion region, MethodInfo methodInfo) throws StorageException {
        MethodInfoContainer container = new MethodInfoContainer(region, methodInfo);
        this.setOrMergeMethodInfoContainer(uniformPath, container);
    }

    private void setOrMergeMethodInfoContainer(String uniformPath, MethodInfoContainer newValue) throws StorageException {
        MethodInfoContainer oldValue = this.readContainerWithCrossAnnotationInfo(uniformPath);
        if (oldValue != null) {
            newValue = MethodInfoContainer.merge(oldValue, newValue);
        }
        this.setMethodContainer(uniformPath, newValue);
    }

    @TestOnly
    public void removeMethodInfos(String uniformPath, Collection<OffsetBasedRegion> regions) throws StorageException {
        MethodInfoContainer container = this.readContainerWithCrossAnnotationInfo(uniformPath);
        if (container != null) {
            regions.forEach(container::removeMethodInfo);
            if (container.isEmpty()) {
                this.removeValues(Collections.singletonList(uniformPath));
            } else {
                this.setMethodContainer(uniformPath, container);
            }
        }
    }

    @VisibleForTesting
    public static @NonNull String createCrossAnnotationInfoKey(String pathOrPathPrefix) {
        return CROSS_ANNOTATION_INFO_PREFIX + pathOrPathPrefix;
    }

    @VisibleForTesting
    public static @NonNull String createMethodInfoContainerKey(String pathOrPathPrefix) {
        return METHOD_INFO_CONTAINER_PREFIX + pathOrPathPrefix;
    }

    private static String removeMethodInfoContainerPrefix(String key) {
        return StringUtils.stripPrefix((String)key, (String)METHOD_INFO_CONTAINER_PREFIX);
    }

    public static List<String> getUniformPathsFromDelta(List<String> deltaKeys) {
        return deltaKeys.stream().map(key -> key.substring(METHOD_INFO_CONTAINER_PREFIX.length())).distinct().collect(Collectors.toList());
    }

    public void setMethodContainer(String uniformPath, MethodInfoContainer container) throws StorageException {
        this.setMethodContainers((PairList<String, MethodInfoContainer>)PairList.from((Object)uniformPath, (Object)container));
    }

    public void setMethodContainers(PairList<String, MethodInfoContainer> methodContainersByUniformPath) throws StorageException {
        PairList values = new PairList(methodContainersByUniformPath.size() * 2);
        for (Pair entry : methodContainersByUniformPath) {
            values.add((Object)MethodInfoIndex.createMethodInfoContainerKey((String)entry.getFirst()), (Object)((MethodInfoContainer)entry.getSecond()).serializeWithoutCrossAnnotations());
            values.add((Object)MethodInfoIndex.createCrossAnnotationInfoKey((String)entry.getFirst()), (Object)((MethodInfoContainer)entry.getSecond()).serializeCrossAnnotationInfo());
        }
        this.store.putWithStrings(values);
    }

    private static List<AssociatedMethodInfo> convertToAssociatedMethodInfos(PairList<String, MethodInfoContainer> containers) {
        ArrayList<AssociatedMethodInfo> associatedMethodInfos = new ArrayList<AssociatedMethodInfo>();
        for (Pair container : containers) {
            if (container.getSecond() == null) continue;
            for (Map.Entry<OffsetBasedRegion, MethodInfo> entry : ((MethodInfoContainer)container.getSecond()).entrySet()) {
                associatedMethodInfos.add(new AssociatedMethodInfo((String)container.getFirst(), entry.getKey(), entry.getValue()));
            }
        }
        return associatedMethodInfos;
    }

    public static String makeKeyFromPathAndRegion(String uniformPath, OffsetBasedRegion region) {
        return uniformPath + "#!#" + region.getStart() + "#!#" + region.getEnd();
    }

    public static OffsetBasedRegion getRegion(String key) {
        String[] parts = PartitionIndexBase.KEY_SEPARATOR_PATTERN.split(key);
        return new OffsetBasedRegion(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }

    public static String getUniformPathFromKey(String key) {
        return PartitionIndexBase.KEY_SEPARATOR_PATTERN.split(key, 2)[0];
    }

    public static Pair<String, OffsetBasedRegion> getUniformPathAndRegionFromKey(String key) {
        return new Pair((Object)MethodInfoIndex.getUniformPathFromKey(key), (Object)MethodInfoIndex.getRegion(key));
    }

    public PairList<String, MethodInfoContainer> getAllEntries() throws StorageException {
        PairList<String, MethodInfoContainer> entries = this.getMethodInfoContainerEntriesWithUniformPathPrefix("");
        this.loadCrossAnnotationInfoIntoMethodContainers(entries.extractFirstList(), (List<MethodInfoContainer>)entries.getSecondList());
        return entries;
    }

    public void removeValues(List<String> uniformPaths) throws StorageException {
        ArrayList removalKeys = CollectionUtils.unionList((Collection)CollectionUtils.map(uniformPaths, MethodInfoIndex::createMethodInfoContainerKey), (Collection[])new Collection[]{CollectionUtils.map(uniformPaths, MethodInfoIndex::createCrossAnnotationInfoKey)});
        this.store.removeWithStrings((List)removalKeys);
    }

    public List<String> getAllMethodInfoContainerKeys() throws StorageException {
        ArrayList<String> result = new ArrayList<String>();
        this.store.scanKeys(MethodInfoIndex.createMethodInfoContainerKey(""), (key, value) -> {
            List list = result;
            synchronized (list) {
                result.add(MethodInfoIndex.removeMethodInfoContainerPrefix(StringUtils.bytesToString((byte[])key)));
            }
        });
        return result;
    }
}

