/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.testgap.MethodInfoDelta;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodIssueIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class MethodIssueSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private RepositoryCommitIssueMappingIndex repositoryCommitIssueMappingIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex metaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MethodIssueIndex methodIssueIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<MethodIssueIndex> oldMethodIssueIndexes;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MethodInfoIndex methodInfoIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private MethodInfoIndex oldMethodInfoIndex;
    @DeltaSource(value=MethodInfoIndex.class)
    private KeyDelta methodInfoDelta;

    public void execute() throws StorageException {
        if (!this.isIssueConnectorConfigured()) {
            return;
        }
        List<TeamscaleIssueId> currentIssueIds = this.getCurrentIssueIds();
        MethodInfoDelta delta = new MethodInfoDelta(this.methodInfoDelta, this.methodInfoIndex, this.oldMethodInfoIndex);
        Map<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>> addedOrChangedMethods = this.createNewMappingsForAddedOrChangedMethods(delta.getAddedOrChangedMethods(), currentIssueIds);
        this.methodIssueIndex.updateMappings(delta.getDeletedLocations(), addedOrChangedMethods);
    }

    private boolean isIssueConnectorConfigured() throws StorageException {
        UnmodifiableList connectors = ((ProjectConfiguration)this.metaIndex.getValue(ProjectConfiguration.class)).getConnectors();
        HashSet issueTrackers = new HashSet(CollectionUtils.map((Object[])EIssueTracker.values(), EIssueTracker::getReadableName));
        for (ConnectorConfiguration connector : connectors) {
            if (issueTrackers.contains(connector.getType())) {
                return true;
            }
            String analysisReportMapping = connector.getOptionValue("Analysis report mapping");
            if (analysisReportMapping == null || !analysisReportMapping.contains(EReportFormat.ISSUE_CSV.name())) continue;
            return true;
        }
        return false;
    }

    private Map<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>> createNewMappingsForAddedOrChangedMethods(List<MethodInfoDelta.ChangedMethod> addedOrChangedMethods, List<TeamscaleIssueId> currentIssueIds) throws StorageException {
        Map<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>> unionedMappings = this.createUnionedPredecessorMappings(addedOrChangedMethods);
        for (MethodInfoDelta.ChangedMethod addedOrChangedMethod : addedOrChangedMethods) {
            boolean noMergeCommitAndRealChange;
            boolean bl = noMergeCommitAndRealChange = !addedOrChangedMethod.isFromMergeCommit() && addedOrChangedMethod.isRealChange();
            if (!addedOrChangedMethod.isMergeConflictResolution() && !noMergeCommitAndRealChange) continue;
            for (TeamscaleIssueId issueId : currentIssueIds) {
                unionedMappings.get(addedOrChangedMethod).put(issueId, this.getSchedulingCommit().getTimestamp());
            }
        }
        return unionedMappings;
    }

    private Map<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>> createUnionedPredecessorMappings(List<MethodInfoDelta.ChangedMethod> addedOrChangedMethods) throws StorageException {
        HashMap<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>> unionedPredecessorMappings = new HashMap<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>>();
        for (MethodInfoDelta.ChangedMethod addedOrChangedMethod : addedOrChangedMethods) {
            unionedPredecessorMappings.put(addedOrChangedMethod, new HashMap());
        }
        for (int branchIndex = 0; branchIndex < this.oldMethodIssueIndexes.size(); ++branchIndex) {
            List<MethodLocation> predecessorsOnBranch = MethodIssueSynchronizer.getPredecessorsOnBranch(addedOrChangedMethods, branchIndex);
            Map<MethodLocation, Map<TeamscaleIssueId, Long>> oldMappings = this.oldMethodIssueIndexes.get(branchIndex).getMappingsForLocations(predecessorsOnBranch);
            for (MethodInfoDelta.ChangedMethod addedOrChangedMethod : addedOrChangedMethods) {
                MethodLocation predecessorMethodLocation = addedOrChangedMethod.getPredecessors().get(branchIndex);
                Map<TeamscaleIssueId, Long> oldMapping = oldMappings.get(predecessorMethodLocation);
                if (oldMapping == null) continue;
                unionedPredecessorMappings.merge(addedOrChangedMethod, oldMapping, MethodIssueSynchronizer::mergeMappings);
            }
        }
        return unionedPredecessorMappings;
    }

    private static List<MethodLocation> getPredecessorsOnBranch(List<MethodInfoDelta.ChangedMethod> movedMethods, int branchIndex) {
        return CollectionUtils.map(movedMethods, movedMethod -> movedMethod.getPredecessors().get(branchIndex));
    }

    private static Map<TeamscaleIssueId, Long> mergeMappings(Map<TeamscaleIssueId, Long> mapping1, Map<TeamscaleIssueId, Long> mapping2) {
        HashMap<TeamscaleIssueId, Long> newMapping = new HashMap<TeamscaleIssueId, Long>(mapping1);
        mapping2.forEach((key, value) -> newMapping.merge((TeamscaleIssueId)key, (Long)value, Long::max));
        return newMapping;
    }

    private List<TeamscaleIssueId> getCurrentIssueIds() throws StorageException {
        List<TeamscaleIssueId> issuesForCurrentTimestamp = this.repositoryCommitIssueMappingIndex.getIssuesForCommit(this.getSchedulingCommit());
        if (CollectionUtils.isNullOrEmpty(issuesForCurrentTimestamp)) {
            return Collections.singletonList(MethodIssueIndex.NO_ISSUE);
        }
        return issuesForCurrentTimestamp;
    }
}

