/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.NativeLibUtil;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.DotNetUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.region.LineBasedRegion;

public class MethodMappingAnalysisUtils {
    private static final String METHOD_MAPPING_ANALYZER_NAME = "Bummer.exe";
    private static final int ANALYZER_TIMEOUT = 120;

    public static MethodMappingContainer analyzeSymbolFile(String debugInfoContainerPath, String assemblyName) throws ConQATException {
        File bummerDir = NativeLibUtil.getNativeLib((String)"bummer");
        String executablePath = new File(bummerDir, METHOD_MAPPING_ANALYZER_NAME).getAbsolutePath();
        ProcessBuilder builder = DotNetUtils.createDotNetProcessBuilder((String[])new String[]{executablePath, "-f:" + debugInfoContainerPath, "-a:" + assemblyName});
        ProcessUtils.ExecutionResult result = ProcessUtils.executeOrThrow((ProcessBuilder)builder, null, (int)120, ConQATException::new);
        String json = result.getStdout();
        MethodMappingContainer[] mappings = (MethodMappingContainer[])JsonUtils.deserializeFromJson((String)json, MethodMappingContainer[].class);
        CCSMAssert.isTrue((mappings.length == 1 ? 1 : 0) != 0, (String)("Expected to get exactly one mapping but was: " + json));
        return mappings[0];
    }

    public static class MethodMappingContainer {
        @JsonProperty(value="MethodMappings")
        private final List<MethodMapping> methodMappings = null;
        @JsonProperty(value="AssemblyName")
        private final String assemblyName;

        public MethodMappingContainer() {
            this.assemblyName = null;
        }

        public List<MethodMapping> getMethodMappings() {
            return this.methodMappings;
        }

        public String getAssemblyName() {
            return this.assemblyName;
        }
    }

    public static class MethodMapping {
        public static final int COMPILER_HIDDEN_LINE = 0xFEEFEE;
        @JsonProperty(value="MethodToken")
        private final Integer methodToken = null;
        @JsonProperty(value="SourceFile")
        private final String sourceFile;
        @JsonProperty(value="StartLine")
        private final Integer startLine = null;
        @JsonProperty(value="EndLine")
        private final Integer endLine = null;

        public MethodMapping() {
            this.sourceFile = null;
        }

        public String getMethodToken() {
            return Integer.toString(this.methodToken);
        }

        public Optional<String> getSourceFile() {
            return Optional.ofNullable(this.sourceFile);
        }

        public LineBasedRegion getRegion() {
            return new LineBasedRegion(this.startLine.intValue(), this.endLine.intValue());
        }
    }
}

