/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.google.common.collect.Lists;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.AssociatedMethodTestInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.TestInfoProcessorParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

public class TestInfoRegionUpdater {
    private final TestInfoProcessorParameters parameters;
    private final CommitDescriptor schedulingCommit;

    public TestInfoRegionUpdater(CommitDescriptor schedulingCommit, TestInfoProcessorParameters parameters) {
        this.schedulingCommit = schedulingCommit;
        this.parameters = parameters;
    }

    public void updateLastTestedTimestamps() throws StorageException, CommitResolutionException {
        if (!this.parameters.anyParentPartitionExists()) {
            return;
        }
        if (this.shouldMergeTestInfos()) {
            return;
        }
        this.parameters.getNewLastTestedIndex().removeByUniformPath(MethodInfoIndex.getUniformPathsFromDelta(this.parameters.getMethodInfoDelta().getAllKeysAsStrings()));
        this.adjustTestInfosForChangedFiles();
    }

    private boolean shouldMergeTestInfos() {
        ParentedCommitDescriptor parentedCommit;
        CommitDescriptor commitDescriptor = this.schedulingCommit;
        if (commitDescriptor instanceof ParentedCommitDescriptor && (parentedCommit = (ParentedCommitDescriptor)commitDescriptor).isMergeCommit()) {
            return !EFeatureToggle.DISABLE_COVERAGE_MERGING.isEnabled();
        }
        return false;
    }

    private void adjustTestInfosForChangedFiles() throws StorageException {
        List<String> changedFiles = MethodInfoIndex.getUniformPathsFromDelta(this.parameters.getMethodInfoDelta().getAddedOrChangedKeysAsStrings());
        if (changedFiles.isEmpty()) {
            return;
        }
        for (List changedFilesBatch : Lists.partition(changedFiles, (int)500)) {
            List<AssociatedMethodInfo> addedOrChangedMethodInfos = this.parameters.getMethodInfoIndex().getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(changedFilesBatch);
            Map<AssociatedMethodInfo, Map<String, CommitDescriptor>> predecessorCommits = this.getPredecessorCommits(addedOrChangedMethodInfos);
            PairList keysAndCommits = new PairList();
            for (Map.Entry<AssociatedMethodInfo, Map<String, CommitDescriptor>> methodWithPartitionAndCommit : predecessorCommits.entrySet()) {
                AssociatedMethodInfo methodInfo = methodWithPartitionAndCommit.getKey();
                Map<String, CommitDescriptor> latestCommitByPartitions = methodWithPartitionAndCommit.getValue();
                for (Map.Entry<String, CommitDescriptor> latestCommitByPartition : latestCommitByPartitions.entrySet()) {
                    keysAndCommits.add((Object)new MethodLastTestedIndex.AccessKey(latestCommitByPartition.getKey(), methodInfo.getUniformPath(), methodInfo.getAssociatedRegion()), (Object)latestCommitByPartition.getValue());
                }
            }
            if (keysAndCommits.isEmpty()) continue;
            this.parameters.getNewLastTestedIndex().setLastTestedTimestamps((PairList<MethodLastTestedIndex.AccessKey, CommitDescriptor>)keysAndCommits, 0L);
        }
    }

    private Map<AssociatedMethodInfo, Map<String, CommitDescriptor>> getPredecessorCommits(List<AssociatedMethodInfo> methodInfos) throws StorageException {
        List<Set<MethodLocation>> keysToReadTimestampsFromPerOldIndex = this.prepareListsForTimestampKeys();
        HashMap<AssociatedMethodInfo, Map<String, CommitDescriptor>> newestCommitsByPartitionAndMethod = new HashMap<AssociatedMethodInfo, Map<String, CommitDescriptor>>();
        HashMap<MethodLocation, AssociatedMethodInfo> keyToMethodInfoMapping = new HashMap<MethodLocation, AssociatedMethodInfo>();
        this.fillKeysToReadAndLookupMaps(keysToReadTimestampsFromPerOldIndex, keyToMethodInfoMapping, newestCommitsByPartitionAndMethod, methodInfos);
        for (int i = 0; i < this.parameters.getOldLastTestedIndexes().size(); ++i) {
            MethodLastTestedIndex oldLastTestedIndex = this.parameters.getOldLastTestedIndexes().get(i);
            List<AssociatedMethodTestInfo> timestampContainers = oldLastTestedIndex.getTimestampsForMethodKeys((Collection<MethodLocation>)keysToReadTimestampsFromPerOldIndex.get(i));
            for (AssociatedMethodTestInfo associatedMethodTestInfo : timestampContainers) {
                AssociatedMethodInfo methodInfo = (AssociatedMethodInfo)keyToMethodInfoMapping.get(associatedMethodTestInfo.getLocation());
                Map newestCommitByPartition = (Map)newestCommitsByPartitionAndMethod.get(methodInfo);
                newestCommitByPartition.merge(associatedMethodTestInfo.getPartition(), associatedMethodTestInfo.getCommit(), CommitDescriptor::max);
            }
        }
        return newestCommitsByPartitionAndMethod;
    }

    private void fillKeysToReadAndLookupMaps(List<Set<MethodLocation>> keysToReadTimestampsFromPerOldIndex, Map<MethodLocation, AssociatedMethodInfo> keyToMethodInfoMapping, Map<AssociatedMethodInfo, Map<String, CommitDescriptor>> newestTimestampsByPartitionAndMethod, List<AssociatedMethodInfo> methodInfos) {
        for (AssociatedMethodInfo associatedMethodInfo : methodInfos) {
            for (int oldIndex = 0; oldIndex < this.parameters.getOldLastTestedIndexes().size(); ++oldIndex) {
                MethodLocation predecessorMethodLocation;
                List<String> predecessorKeys = associatedMethodInfo.extractPredecessorKeys();
                if (this.methodHasBeenChangedInCommit(associatedMethodInfo, predecessorKeys)) {
                    String predecessorKey = predecessorKeys.get(oldIndex);
                    if (predecessorKey == null) continue;
                    predecessorMethodLocation = MethodLocation.fromIndexKey(predecessorKey);
                } else {
                    predecessorMethodLocation = associatedMethodInfo.getLocation();
                }
                keysToReadTimestampsFromPerOldIndex.get(oldIndex).add(predecessorMethodLocation);
                keyToMethodInfoMapping.put(predecessorMethodLocation, associatedMethodInfo);
            }
            newestTimestampsByPartitionAndMethod.put(associatedMethodInfo, new HashMap());
        }
    }

    private List<Set<MethodLocation>> prepareListsForTimestampKeys() {
        ArrayList<Set<MethodLocation>> keysToReadTimestampsFromPerOldIndex = new ArrayList<Set<MethodLocation>>();
        for (int i = 0; i < this.parameters.getOldLastTestedIndexes().size(); ++i) {
            keysToReadTimestampsFromPerOldIndex.add(new HashSet());
        }
        return keysToReadTimestampsFromPerOldIndex;
    }

    private boolean methodHasBeenChangedInCommit(AssociatedMethodInfo methodInfo, List<String> predecessorKeys) {
        List nonNullPredecessorMethodLocations = CollectionUtils.filterAndMap(predecessorKeys, Objects::nonNull, MethodLocation::fromIndexKey);
        return methodInfo.getLastInfoUpdateCommit().equals((Object)this.schedulingCommit) && !nonNullPredecessorMethodLocations.isEmpty();
    }
}

