/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.abap.AbapIncludeIndex;
import com.teamscale.index.testgap.abap.AbapScovMethodMappingIndex;
import com.teamscale.index.testgap.abap.ScovIdFeature;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.OffsetBasedRegion;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class AbapMethodMappingSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private AbapIncludeIndex includeIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private AbapIncludeIndex oldIncludeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private AbapScovMethodMappingIndex mappingIndex;

    public void execute() throws StorageException {
        List<String> deletedAbapFiles = AbapMethodMappingSynchronizer.onlyAbapPaths(this.contentDelta.getDeletedKeysAsStrings());
        HashSet<String> pathsToClean = new HashSet<String>(deletedAbapFiles);
        pathsToClean.addAll(AbapMethodMappingSynchronizer.onlyAbapPaths(this.contentDelta.getAddedOrChangedKeysAsStrings()));
        pathsToClean.addAll(this.oldIncludeIndex.getInboundsTransitive(new ArrayList<String>(pathsToClean)).getValues());
        for (String path : pathsToClean) {
            try {
                this.mappingIndex.removeMappingsByObjectName(AbapMethodMappingSynchronizer.pathToObject(path));
            }
            catch (ConQATException e) {
                LOGGER.warn("Could not parse ABAP path " + path + ". Skipping path for clean up!", (Throwable)e);
            }
        }
        ArrayList<String> paths = new ArrayList<String>(CollectionUtils.differenceSet(pathsToClean, (Collection[])new Collection[]{deletedAbapFiles}));
        try {
            SetMap<ScovIdFeature, MethodLocation> mappings = this.getMappings(paths);
            this.mappingIndex.putMappings(mappings);
        }
        catch (StorageException e) {
            LOGGER.warn("Could not store mappings. Skipping update!", (Throwable)e);
        }
    }

    private SetMap<ScovIdFeature, MethodLocation> getMappings(List<String> uniformPaths) throws StorageException {
        SetMap result = new SetMap();
        SetMap<String, String> outboundsTransitive = this.includeIndex.getOutboundsTransitive(uniformPaths);
        HashMap<String, @Nullable TokenElementInfo> tokenElementsByPath = new HashMap<String, TokenElementInfo>();
        ArrayList<String> allPathsToLoadContentFor = new ArrayList<String>(CollectionUtils.unionSet((Collection)outboundsTransitive.getValues(), (Collection[])new Collection[]{uniformPaths}));
        List<@Nullable TokenElementInfo> tokenElements = this.contentIndex.getTokenElements(allPathsToLoadContentFor);
        for (int i = 0; i < allPathsToLoadContentFor.size(); ++i) {
            tokenElementsByPath.put((String)allPathsToLoadContentFor.get(i), tokenElements.get(i));
        }
        for (String uniformPath : uniformPaths) {
            result.addAll(AbapMethodMappingSynchronizer.getAndExtract(uniformPath, (TokenElementInfo)((Object)tokenElementsByPath.get(uniformPath)), uniformPath));
            for (String outbound : (Set)outboundsTransitive.getCollection((Object)uniformPath)) {
                result.addAll(AbapMethodMappingSynchronizer.getAndExtract(outbound, (TokenElementInfo)((Object)tokenElementsByPath.get(outbound)), uniformPath));
            }
        }
        return result;
    }

    private static SetMap<ScovIdFeature, MethodLocation> getAndExtract(String uniformPath, @Nullable TokenElementInfo elementForUniformPath, String featurePath) {
        SetMap mappings = new SetMap();
        if (elementForUniformPath == null) {
            LOGGER.error("Could not retrieve content for '" + uniformPath + "' - either the content delta or the AbapIncludeIndex contains invalid information.");
            return new SetMap();
        }
        try {
            UnmodifiableList<ShallowEntity> rootEntities = elementForUniformPath.getShallowEntitiesWithoutPreprocessorTokens();
            List methods = ShallowEntityTraversalUtils.selectEntities(rootEntities, AbapMethodMappingSynchronizer::isNonEmptyMethod);
            for (ShallowEntity method : methods) {
                MethodLocation location = new MethodLocation(uniformPath, new OffsetBasedRegion(method.getStartOffset(), method.getEndOffset()));
                mappings.add((Object)AbapMethodMappingSynchronizer.getFeatureFor(featurePath, method), (Object)location);
            }
        }
        catch (ConQATException e) {
            LOGGER.error("Error extracting SCOV ID features for path {}, returning empty set", (Object)uniformPath, (Object)e);
        }
        return mappings;
    }

    private static String pathToObject(String uniformPath) throws ConQATException {
        return new ParsedAbapElementPath(uniformPath).getElementName().getObjectName();
    }

    private static ScovIdFeature getFeatureFor(String path, ShallowEntity method) throws ConQATException {
        ParsedAbapElementPath abapPath = new ParsedAbapElementPath(path);
        String scovObjectName = AbapUtils.formatNameForSCOV((ParsedAbapElementPath)abapPath);
        return ScovIdFeature.createFrom(scovObjectName, method);
    }

    private static boolean isNonEmptyMethod(ShallowEntity element) {
        return EShallowEntityType.METHOD == element.getType() && !"method declaration".equals(element.getSubtype()) && element.hasChildren();
    }

    private static List<String> onlyAbapPaths(List<String> uniformPaths) {
        return CollectionUtils.filter(uniformPaths, path -> ELanguage.fromPath((String)path) == ELanguage.ABAP);
    }
}

