/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap.structure;

import com.teamscale.index.testgap.abap.structure.EProcessingBlockType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.string.StringUtils;

public class AbapScovUtils {
    public static final String START_OF_SELECTION_SCOV_BLOCK_NAME = "START-OF-SELECTION";

    public static String buildSCOVMethodNameWithNumberedBlocks(ShallowEntity method, EProcessingBlockType blockType, CounterSet<EProcessingBlockType> counters) {
        String name = AbapScovUtils.buildSCOVMethodName(method, blockType);
        if (EProcessingBlockType.COUNTED_TYPES.contains((Object)blockType)) {
            String suffix = StringUtils.flushRight((String)String.valueOf(counters.getValue((Object)blockType)), (int)2, (char)'0');
            counters.inc((Object)blockType);
            return StringUtils.addSuffix((String)name, (String)":", (String)suffix);
        }
        return name;
    }

    public static String buildSCOVMethodName(ShallowEntity method, EProcessingBlockType blockType) {
        if (EProcessingBlockType.COUNTED_TYPES.contains((Object)blockType)) {
            return AbapScovUtils.getSCOVCountedAnonymousBlockName(blockType);
        }
        String name = method.getName();
        if (name != null) {
            return name;
        }
        return method.getSubtype();
    }

    private static String getSCOVCountedAnonymousBlockName(EProcessingBlockType blockType) {
        CCSMAssert.isTrue((boolean)EProcessingBlockType.COUNTED_TYPES.contains((Object)blockType), (String)"This method only handles counted block types");
        switch (blockType) {
            case LISE: {
                return "ATLINE-SELECTION";
            }
            case ATUC: {
                return "ATUSER-COMMAND";
            }
            case ESEL: {
                return "END-OF-SELECTION";
            }
            case INIT: {
                return "INITIALIZATION";
            }
            case LDPR: {
                return "LOAD-OF-PROGRAM";
            }
            case SSEL: {
                return START_OF_SELECTION_SCOV_BLOCK_NAME;
            }
            case TOPA: {
                return "TOP-OF-PAGE";
            }
            case TOPS: {
                return "TOP-OF-PAGE DURING LINE-SELECTION";
            }
        }
        CCSMAssert.fail((String)("Unhandled counted block type: " + String.valueOf((Object)blockType)));
        return null;
    }
}

