/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.user.User;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.MethodIssueIndex;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAssessor;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import com.teamscale.index.testgap.query.TgaBranchMergeRequest;
import com.teamscale.index.testgap.query.TgaIssueRequest;
import com.teamscale.index.testgap.query.TgaNoIssueRequest;
import com.teamscale.index.testgap.query.TgaPathRequest;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.index.testgap.query.TgaTestQueryRequest;
import com.teamscale.index.utils.IssueUtils;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import jakarta.ws.rs.NotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;

public interface ITgaRequest {
    public ETgaAssessmentType getTgaAssessmentType();

    public long getBaselineTimestamp();

    public CommitDescriptor getIndexAccessCommit();

    public List<String> getPartitions() throws StorageException;

    public Set<PublicProjectId> getCrossAnnotationProjects() throws StorageException;

    public TgaAssessor createAssessor();

    public UnassessedTestGapData fetchUnassessedData(MethodInfoFilter var1) throws StorageException;

    default public AssessedTgaData fetchAndAssessData() throws StorageException {
        return this.fetchAndAssessData(MethodInfoFilter.DEFAULT);
    }

    public AssessedTgaData fetchAndAssessData(MethodInfoFilter var1) throws StorageException;

    public static ITgaRequest createRequest(CoverageSourceParameterBase coverageParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestParameters, IssueTgaParameters issueTgaParameters, ETgaAssessmentType assessmentType, IndexLayer indexLayer, IProjectId projectId, User user) throws StorageException, RepositoryException, BranchPointNotFoundException {
        if (tgaRequestParameters.getTestUniformPath() != null) {
            return TgaTestQueryRequest.createSingleTestRequest(coverageParameters, timeIntervalParameters, tgaRequestParameters, assessmentType, indexLayer, projectId);
        }
        if (tgaRequestParameters.getTestQuery() != null) {
            return TgaTestQueryRequest.createRequest(coverageParameters, timeIntervalParameters, tgaRequestParameters, assessmentType, indexLayer, projectId, user);
        }
        String issueIdFromQuery = tgaRequestParameters.getIssueId();
        if (Objects.equals(issueIdFromQuery, MethodIssueIndex.NO_ISSUE.getExternalId()) || Objects.equals(issueIdFromQuery, MethodIssueIndex.NO_ISSUE.getInternalId())) {
            return TgaNoIssueRequest.createRequest(coverageParameters, timeIntervalParameters, assessmentType, indexLayer, projectId);
        }
        if (issueIdFromQuery != null) {
            TeamscaleIssueId issueId = ITgaRequest.determineIssueId(issueIdFromQuery, indexLayer, projectId);
            CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
            return TgaIssueRequest.createRequest(issueId, coverageParameters, issueTgaParameters, assessmentType, TgaRequestUtils.createAndPreloadIssueMappingCache(Collections.singletonList(issueId), projectStorageSystem), timeIntervalParameters, indexLayer, projectId);
        }
        if (tgaRequestParameters.isMergeRequest()) {
            return TgaBranchMergeRequest.createRequest(coverageParameters, timeIntervalParameters, tgaRequestParameters, assessmentType, indexLayer, projectId);
        }
        return TgaPathRequest.createRequest(coverageParameters, timeIntervalParameters, tgaRequestParameters, assessmentType, indexLayer, projectId);
    }

    private static TeamscaleIssueId determineIssueId(String issueIdFromQuery, IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        IssueHistoryIndex historyIndex = (IssueHistoryIndex)indexLayer.openProjectIndex(projectId, IssueHistoryIndex.class, null);
        IssueIndex issueIndex = (IssueIndex)indexLayer.openProjectIndex(projectId, IssueIndex.class, null);
        Optional<TeamscaleIssue> issue = IssueUtils.getSingleIssueHistoryForId(historyIndex, issueIndex, issueIdFromQuery, true);
        return issue.orElseThrow(() -> new NotFoundException(String.format("No issue found for the provided id '%s'", issueIdFromQuery))).getId();
    }
}

