/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.MergeRequestIdentifier;

public class TgaIssueAndMergeRequestOptions {
    public static final String MERGE_REQUEST_MODE_PARAMETER_NAME = "merge-request-mode";
    private static final String MERGE_REQUEST_MODE_PARAMETER_DESCRIPTION = "If this is true, we will compute TGA information based on the methods changed in the history of commit1 but not in the history of commit2. This simulates a merge from commit1 to commit2.";
    private static final String MERGE_BASE_KEY_PARAMETER_NAME = "merge-base-cache-key";
    private static final String MERGE_BASE_KEY_PARAMETER_DESCRIPTION = "Optional key into the cache index for merge base calculation. If this is known it can be used to speed up calculation of the merge base.";
    private static final String MERGE_REQUEST_IDENTIFIER_PARAMETER_NAME = "merge-request-identifier";
    private static final String MERGE_REQUEST_IDENTIFIER_PARAMETER_DESCRIPTION = "Optional merge request identifier to retrieve the merge base info. If this is provided it can be used to directly fetch the merge base info from the merge request delta index before trying to calculate the merge base. This is especially required when creating the TgaBranchMergeRequest for an already merged  merge request.";
    public static final String ISSUE_ID_PARAMETER_NAME = "issue-id";
    private static final String ISSUE_ID_PARAMETER_DOC = "If this parameter is given and is a valid issue ID, information about all methods changed in the context of this issue ID will be returned. In this case, the baseline parameter is ignored (the baseline is determined automatically for the issue instead). If the special value \"###no-connector###|[no-issue]\" is given, instead all methods that were changed in commits without an issue link between the baseline and end date are returned.";
    @Parameter(description="If this parameter is given and is a valid issue ID, information about all methods changed in the context of this issue ID will be returned. In this case, the baseline parameter is ignored (the baseline is determined automatically for the issue instead). If the special value \"###no-connector###|[no-issue]\" is given, instead all methods that were changed in commits without an issue link between the baseline and end date are returned.")
    @QueryParam(value="issue-id")
    private String issueId;
    @Parameter(description="If this is true, we will compute TGA information based on the methods changed in the history of commit1 but not in the history of commit2. This simulates a merge from commit1 to commit2.")
    @QueryParam(value="merge-request-mode")
    private boolean mergeRequestMode;
    @Parameter(description="Optional key into the cache index for merge base calculation. If this is known it can be used to speed up calculation of the merge base.")
    @QueryParam(value="merge-base-cache-key")
    private String mergeBaseCacheKey;
    @Parameter(description="Optional merge request identifier to retrieve the merge base info. If this is provided it can be used to directly fetch the merge base info from the merge request delta index before trying to calculate the merge base. This is especially required when creating the TgaBranchMergeRequest for an already merged  merge request.")
    @QueryParam(value="merge-request-identifier")
    private MergeRequestIdentifier mergeRequestIdentifier;

    @JsonCreator
    public TgaIssueAndMergeRequestOptions() {
    }

    public TgaIssueAndMergeRequestOptions(String issueId, boolean mergeRequestMode, String mergeBaseCacheKey, MergeRequestIdentifier mergeRequestIdentifier) {
        this.issueId = issueId;
        this.mergeRequestMode = mergeRequestMode;
        this.mergeBaseCacheKey = mergeBaseCacheKey;
        this.mergeRequestIdentifier = mergeRequestIdentifier;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public void setIssueId(String issueId) {
        this.issueId = issueId;
    }

    public boolean isMergeRequestMode() {
        return this.mergeRequestMode;
    }

    public String getMergeBaseCacheKey() {
        return this.mergeBaseCacheKey;
    }

    public MergeRequestIdentifier getMergeRequestIdentifier() {
        return this.mergeRequestIdentifier;
    }
}

