/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.FirstLastCommit;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndexCache;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.ExecutedMethodIndex;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.IssueDataRetriever;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaRequestBase;
import com.teamscale.index.utils.IssueUtils;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class TgaIssueRequest
extends TgaRequestBase {
    protected final Set<TeamscaleIssueId> issueIds;
    private final long lastCommitToIssueTimestamp;

    private TgaIssueRequest(Set<TeamscaleIssueId> issueIds, CommitDescriptor endCommit, long baseline, long lastCommitToIssueTimestamp, CoverageSourceParameterBase coverageSourceOptions, ETgaAssessmentType assessmentType, IProjectId projectId, IndexLayer indexLayer) {
        super(coverageSourceOptions, assessmentType, baseline, endCommit, projectId, indexLayer);
        this.issueIds = issueIds;
        this.lastCommitToIssueTimestamp = lastCommitToIssueTimestamp;
    }

    @Override
    protected ITgaDataRetriever createDataRetriever(TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        return new IssueDataRetriever(this.issueIds, this.getPartitions(), dataRetrieverIndexes, crossAnnotator, this.testInfoFilter, tgaEnablementPerCodeScope);
    }

    @Override
    protected CrossAnnotator createCrossAnnotator(List<ExecutedMethodIndex> crossAnnotationIndexes, ProjectStorageSystem projectStorageSystem) {
        return CrossAnnotator.createForIssueRequest(crossAnnotationIndexes, projectStorageSystem, this.lastCommitToIssueTimestamp);
    }

    public static TgaIssueRequest createRequest(TeamscaleIssueId issueId, CoverageSourceParameterBase coverageSourceOptions, IssueTgaParameters issueTgaParameters, ETgaAssessmentType assessmentType, RepositoryCommitIssueMappingIndexCache mappingIndexCache, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        issueTgaParameters.patchBranchName(timeIntervalParameters);
        return TgaIssueRequest.createRequest(issueId, coverageSourceOptions, issueTgaParameters, assessmentType, mappingIndexCache, indexLayer, projectId);
    }

    public static TgaIssueRequest createRequest(TeamscaleIssueId issueId, CoverageSourceParameterBase coverageSourceOptions, IssueTgaParameters issueTgaParameters, ETgaAssessmentType assessmentType, RepositoryCommitIssueMappingIndexCache mappingIndexCache, IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        return TgaIssueRequest.createRequest(issueId, coverageSourceOptions, issueTgaParameters, assessmentType, Long.MAX_VALUE, projectId, indexLayer, mappingIndexCache);
    }

    public static TgaIssueRequest createRequest(TeamscaleIssueId issueId, CoverageSourceParameterBase coverageSourceOptions, IssueTgaParameters issueTgaParameters, ETgaAssessmentType assessmentType, long endCommitTimestamp, IProjectId projectId, IndexLayer indexLayer, RepositoryCommitIssueMappingIndexCache mappingIndexCache) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
        HashSet<TeamscaleIssueId> issueIds = new HashSet<TeamscaleIssueId>();
        issueIds.add(issueId);
        if (issueTgaParameters.shouldIncludeChildIssues()) {
            issueIds.addAll(IssueUtils.determineChildIssues(issueId, (ProjectStorageSystem)projectStorageSystem, indexLayer.openGlobalStorageSystem()));
        }
        FirstLastCommit firstLastCommit = mappingIndexCache.getValue(issueId);
        String selectedBranch = TgaIssueRequest.determineIssueBranch(issueTgaParameters, firstLastCommit, projectStorageSystem);
        CommitDescriptor endCommit = new CommitDescriptor(selectedBranch, endCommitTimestamp);
        List<FirstLastCommit> firstLastCommits = mappingIndexCache.getValues(new ArrayList<TeamscaleIssueId>(issueIds));
        long baselineTimestamp = firstLastCommits.stream().filter(Objects::nonNull).mapToLong(issueCommits -> issueCommits.firstCommit.getTimestamp() - 1L).min().orElse(0L);
        long lastCommitToIssueTimestamp = firstLastCommits.stream().filter(Objects::nonNull).mapToLong(issueCommits -> issueCommits.lastCommit.getTimestamp()).max().orElse(-1L);
        return new TgaIssueRequest(issueIds, endCommit, baselineTimestamp, lastCommitToIssueTimestamp, coverageSourceOptions, assessmentType, projectId, indexLayer);
    }

    public static String determineIssueBranch(IssueTgaParameters issueTgaParameters, @Nullable FirstLastCommit firstLastCommit, CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
        if (issueTgaParameters.isBranchExplicitlySpecified()) {
            return issueTgaParameters.getBranchName();
        }
        if (firstLastCommit != null) {
            return firstLastCommit.lastCommit.getBranchName();
        }
        return TgaIssueRequest.getDefaultBranchName((ProjectStorageSystem)projectStorageSystem);
    }

    @Override
    protected String getTgaRequestPrefix() {
        return "Test gap data for issue(s) '" + String.valueOf(this.issueIds) + "'";
    }
}

