/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.treemap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.testgap.treemap.MethodTreeMapNodeBase;
import io.swagger.v3.oas.annotations.media.Schema;
import java.awt.Color;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.conqat.lib.commons.treemap.ITreeMapNode;

@NoIndexValueClass
@Schema(allOf={MethodTreeMapNodeBase.class})
public class CoverageOverlapMethodTreeMapNode
extends MethodTreeMapNodeBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="overlapStates")
    private final CounterSet<EOverlapState> overlapStates = new CounterSet();

    public CoverageOverlapMethodTreeMapNode() {
        this("");
    }

    public CoverageOverlapMethodTreeMapNode(String uniformPath) {
        super(uniformPath, new OffsetBasedRegion(0, 0), "");
        this.area = 0.0;
    }

    public CoverageOverlapMethodTreeMapNode(String uniformPath, OffsetBasedRegion region, String methodName, EOverlapState overlapState) {
        super(uniformPath, region, methodName);
        this.area = region.getLength();
        this.overlapStates.inc((Object)overlapState);
    }

    public Color getColor() {
        return null;
    }

    @Override
    public String getUniformPath() {
        return this.uniformPath;
    }

    public void aggregateValues() {
        if (this.getChildren().isEmpty()) {
            return;
        }
        this.overlapStates.clear();
        for (ITreeMapNode child : this.getChildren()) {
            CoverageOverlapMethodTreeMapNode overlapMethodTreeMapNodeChild = (CoverageOverlapMethodTreeMapNode)child;
            overlapMethodTreeMapNodeChild.aggregateValues();
            this.overlapStates.add(overlapMethodTreeMapNodeChild.overlapStates);
        }
    }

    public static CoverageOverlapMethodTreeMapNode findOrCreateNode(CoverageOverlapMethodTreeMapNode root, String uniformPath) {
        return (CoverageOverlapMethodTreeMapNode)root.getOrCreateChild(uniformPath, CoverageOverlapMethodTreeMapNode::new);
    }

    @ExportToTypeScript
    public static enum EOverlapState {
        NONE,
        SET_ONE,
        SET_TWO,
        BOTH;

    }
}

